/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;

public class VertxMeterBinderContainerFilter
implements ContainerRequestFilter {
    private static final Logger log = Logger.getLogger(VertxMeterBinderContainerFilter.class);

    public void filter(ContainerRequestContext requestContext) {
        RoutingContext routingContext = ((CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get()).getCurrent();
        if (routingContext == null || routingContext.get("HTTP_REQUEST_MATCHED_PATH") != null) {
            return;
        }
        UriInfo info = requestContext.getUriInfo();
        String path = info.getPath();
        MultivaluedMap pathParameters = info.getPathParameters();
        if (!pathParameters.isEmpty()) {
            for (Map.Entry entry : pathParameters.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    path = path.replace(value, "{" + (String)entry.getKey() + "}");
                }
            }
            log.debugf("Saving parameterized path %s in %s", (Object)path, (Object)routingContext);
        }
        routingContext.put("HTTP_REQUEST_PATH", (Object)path);
    }
}

