/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.config;

import io.quarkus.micrometer.runtime.config.AzureMonitorConfig;
import io.quarkus.micrometer.runtime.config.DatadogConfig;
import io.quarkus.micrometer.runtime.config.JmxConfig;
import io.quarkus.micrometer.runtime.config.JsonConfig;
import io.quarkus.micrometer.runtime.config.KafkaConfig;
import io.quarkus.micrometer.runtime.config.MicroprofileMetricsConfig;
import io.quarkus.micrometer.runtime.config.PrometheusConfig;
import io.quarkus.micrometer.runtime.config.StackdriverConfig;
import io.quarkus.micrometer.runtime.config.VertxConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Optional;

@ConfigRoot(name="micrometer", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public final class MicrometerConfig {
    @ConfigItem(defaultValue="true")
    public boolean enabled;
    @ConfigItem(defaultValue="true")
    public boolean registryEnabledDefault;
    @ConfigItem(defaultValue="true")
    public boolean binderEnabledDefault;
    public BinderConfig binder;
    public ExportConfig export;

    public boolean checkRegistryEnabledWithDefault(CapabilityEnabled config) {
        if (this.enabled) {
            Optional<Boolean> configValue = config.getEnabled();
            if (configValue.isPresent()) {
                return configValue.get();
            }
            return this.registryEnabledDefault;
        }
        return false;
    }

    public boolean checkBinderEnabledWithDefault(CapabilityEnabled config) {
        if (this.enabled) {
            Optional<Boolean> configValue = config.getEnabled();
            if (configValue.isPresent()) {
                return configValue.get();
            }
            return this.binderEnabledDefault;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{enabled=" + this.enabled + ",binderEnabledDefault=" + this.binderEnabledDefault + ",registryEnabledDefault=" + this.registryEnabledDefault + '}';
    }

    public static interface CapabilityEnabled {
        public Optional<Boolean> getEnabled();
    }

    @ConfigGroup
    public static class ExportConfig {
        public DatadogConfig datadog;
        public JmxConfig jmx;
        public PrometheusConfig prometheus;
        public StackdriverConfig stackdriver;
        public JsonConfig json;
        public AzureMonitorConfig azuremonitor;
    }

    @ConfigGroup
    public static class BinderConfig {
        public VertxConfig vertx;
        public MicroprofileMetricsConfig mpMetrics;
        public KafkaConfig kafka;
        @ConfigItem(defaultValue="true")
        public boolean jvm;
        @ConfigItem(defaultValue="true")
        public boolean system;
    }
}

