/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.HttpCommonTags;
import io.quarkus.micrometer.runtime.binder.vertx.HttpRequestMetric;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMetricsTags;
import io.quarkus.micrometer.runtime.binder.vertx.VertxTcpMetrics;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.jboss.logging.Logger;

public class VertxHttpServerMetrics
extends VertxTcpMetrics
implements HttpServerMetrics<HttpRequestMetric, LongTaskTimer.Sample, Map<String, Object>> {
    static final Logger log = Logger.getLogger(VertxHttpServerMetrics.class);
    static final String METRICS_CONTEXT = "HTTP_REQUEST_METRICS_CONTEXT";
    HttpBinderConfiguration config;
    final String nameWebsocketConnections;
    final String nameHttpServerPush;
    final String nameHttpServerRequests;
    final LongAdder activeRequests;

    VertxHttpServerMetrics(MeterRegistry registry, HttpBinderConfiguration config) {
        super(registry, "http.server");
        this.config = config;
        this.nameWebsocketConnections = config.getHttpServerWebSocketConnectionsName();
        this.nameHttpServerPush = config.getHttpServerPushName();
        this.nameHttpServerRequests = config.getHttpServerRequestsName();
        this.activeRequests = new LongAdder();
        Gauge.builder((String)config.getHttpServerActiveRequestsName(), (Object)this.activeRequests, LongAdder::doubleValue).register(registry);
    }

    public HttpRequestMetric responsePushed(Map<String, Object> socketMetric, HttpMethod method, String uri, HttpResponse response) {
        HttpRequestMetric requestMetric = new HttpRequestMetric(uri, this.activeRequests);
        String path = requestMetric.getNormalizedUriPath(this.config.getServerMatchPatterns(), this.config.getServerIgnorePatterns());
        if (path != null) {
            this.registry.counter(this.nameHttpServerPush, (Iterable)Tags.of((Tag[])new Tag[]{HttpCommonTags.uri(path, response.statusCode()), VertxMetricsTags.method(method), VertxMetricsTags.outcome(response), HttpCommonTags.status(response.statusCode())})).increment();
        }
        log.debugf("responsePushed %s, %s", socketMetric, (Object)requestMetric);
        return requestMetric;
    }

    public void requestRouted(HttpRequestMetric requestMetric, String route) {
        log.debugf("requestRouted %s %s", (Object)route, (Object)requestMetric);
        requestMetric.appendCurrentRoutePath(route);
        if (route != null) {
            requestMetric.request().context().putLocal((Object)"VertxRoute", (Object)route);
        }
    }

    public HttpRequestMetric requestBegin(Map<String, Object> socketMetric, HttpRequest request) {
        HttpRequestMetric requestMetric = new HttpRequestMetric(request, this.activeRequests);
        requestMetric.setSample(Timer.start((MeterRegistry)this.registry));
        requestMetric.requestStarted();
        log.debugf("requestBegin %s, %s", socketMetric, (Object)requestMetric);
        return requestMetric;
    }

    public void requestReset(HttpRequestMetric requestMetric) {
        log.debugf("requestReset %s", (Object)requestMetric);
        String path = requestMetric.getNormalizedUriPath(this.config.getServerMatchPatterns(), this.config.getServerIgnorePatterns());
        if (path != null) {
            Timer.Sample sample = requestMetric.getSample();
            Timer.Builder builder = Timer.builder((String)this.nameHttpServerRequests).tags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.method(requestMetric.request().method()), HttpCommonTags.uri(path, 0), Outcome.CLIENT_ERROR.asTag(), HttpCommonTags.STATUS_RESET}));
            sample.stop(builder.register(this.registry));
        }
        requestMetric.requestEnded();
    }

    public void responseEnd(HttpRequestMetric requestMetric, HttpResponse response, long bytesWritten) {
        log.debugf("responseEnd %s, %s", (Object)response, (Object)requestMetric);
        String path = requestMetric.getNormalizedUriPath(this.config.getServerMatchPatterns(), this.config.getServerIgnorePatterns());
        if (path != null) {
            Timer.Sample sample = requestMetric.getSample();
            Timer.Builder builder = Timer.builder((String)this.nameHttpServerRequests).tags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.method(requestMetric.request().method()), HttpCommonTags.uri(path, response.statusCode()), VertxMetricsTags.outcome(response), HttpCommonTags.status(response.statusCode())}));
            sample.stop(builder.register(this.registry));
        }
        requestMetric.requestEnded();
    }

    public LongTaskTimer.Sample connected(Map<String, Object> socketMetric, HttpRequestMetric requestMetric, ServerWebSocket serverWebSocket) {
        log.debugf("websocket connected %s, %s, %s", socketMetric, (Object)serverWebSocket, (Object)requestMetric);
        String path = requestMetric.getNormalizedUriPath(this.config.getServerMatchPatterns(), this.config.getServerIgnorePatterns());
        if (path != null) {
            return LongTaskTimer.builder((String)this.nameWebsocketConnections).tags((Iterable)Tags.of((Tag[])new Tag[]{HttpCommonTags.uri(path, 0)})).register(this.registry).start();
        }
        return null;
    }

    public void disconnected(LongTaskTimer.Sample websocketMetric) {
        log.debugf("websocket disconnected %s", (Object)websocketMetric);
        if (websocketMetric != null) {
            websocketMetric.stop();
        }
    }
}

