/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.vertx.VertxHttpServerMetrics;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import org.jboss.logging.Logger;

public class VertxMeterBinderAdapter
extends MetricsOptions
implements VertxMetricsFactory,
VertxMetrics {
    private static final Logger log = Logger.getLogger(VertxMeterBinderAdapter.class);
    private HttpBinderConfiguration httpBinderConfiguration;

    void setHttpConfig(HttpBinderConfiguration httpBinderConfiguration) {
        this.httpBinderConfiguration = httpBinderConfiguration;
    }

    public boolean isEnabled() {
        return true;
    }

    public VertxMetricsFactory getFactory() {
        return this;
    }

    public VertxMetrics metrics(VertxOptions vertxOptions) {
        return this;
    }

    public MetricsOptions newOptions() {
        return this;
    }

    public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
        if (this.httpBinderConfiguration == null) {
            throw new IllegalStateException("HttpBinderConfiguration was not found");
        }
        if (this.httpBinderConfiguration.isServerEnabled()) {
            log.debugf("Create HttpServerMetrics with options %s and address %s", (Object)options, (Object)localAddress);
            return new VertxHttpServerMetrics((MeterRegistry)Metrics.globalRegistry, this.httpBinderConfiguration);
        }
        return null;
    }
}

