/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export.handlers;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import org.jboss.logging.Logger;

public class PrometheusHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger(PrometheusHandler.class);
    private PrometheusMeterRegistry registry;
    private boolean setup = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext routingContext) {
        if (!this.setup) {
            this.setup();
        }
        HttpServerResponse response = routingContext.response();
        if (this.registry == null) {
            response.setStatusCode(500).setStatusMessage("Unable to resolve Prometheus registry instance");
        } else {
            ManagedContext requestContext = Arc.container().requestContext();
            if (requestContext.isActive()) {
                this.doHandle(response);
            } else {
                requestContext.activate();
                try {
                    this.doHandle(response);
                }
                finally {
                    requestContext.terminate();
                }
            }
        }
    }

    private void doHandle(HttpServerResponse response) {
        response.putHeader("Content-Type", "application/openmetrics-text; version=1.0.0; charset=utf-8").end(Buffer.buffer((String)this.registry.scrape("application/openmetrics-text; version=1.0.0; charset=utf-8")));
    }

    private void setup() {
        Instance registries = CDI.current().select(PrometheusMeterRegistry.class, new Annotation[]{Default.Literal.INSTANCE});
        if (registries.isUnsatisfied()) {
            this.registry = null;
        } else if (registries.isAmbiguous()) {
            this.registry = (PrometheusMeterRegistry)registries.iterator().next();
            log.warnf("Multiple prometheus registries present. Using %s with the built-in scrape endpoint", (Object)this.registry);
        } else {
            this.registry = (PrometheusMeterRegistry)registries.get();
        }
        this.setup = true;
    }
}

