/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.redis;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.redis.runtime.client.ObservableRedisMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;

@ApplicationScoped
@Typed(value={ObservableRedisMetrics.class})
public class RedisMetricsBean
implements ObservableRedisMetrics {
    final MeterRegistry registry = Metrics.globalRegistry;
    final Map<String, RedisMetrics> reportedMetrics = new ConcurrentHashMap<String, RedisMetrics>();

    public void report(String name, long durationInNs, boolean succeeded) {
        this.reportedMetrics.computeIfAbsent(name, n -> new RedisMetrics(this.registry, (String)n)).report(name, durationInNs, succeeded);
    }

    private class RedisMetrics
    implements ObservableRedisMetrics {
        private final Tags tags;
        private final Counter operationCounter;
        private final Counter successCounter;
        private final Counter failureCounter;
        private final Timer timer;
        private String name;

        private RedisMetrics(MeterRegistry registry, String name) {
            this.name = name;
            this.tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"client-name", (String)name)});
            this.operationCounter = Counter.builder((String)"redis.commands.count").description("The number of operations (commands or batches) executed").tags((Iterable)this.tags).register(registry);
            this.successCounter = Counter.builder((String)"redis.commands.success").description("The number of operations (commands or batches) that have been executed successfully").tags((Iterable)this.tags).register(registry);
            this.failureCounter = Counter.builder((String)"redis.commands.failure").description("The number of operations (commands or batches) that have been failed").tags((Iterable)this.tags).register(registry);
            this.timer = Timer.builder((String)"redis.commands.duration").description("The duration of the operations (commands of batches").tags((Iterable)this.tags).register(registry);
        }

        public void report(String name, long durationInNs, boolean succeeded) {
            this.operationCounter.increment();
            if (succeeded) {
                this.successCounter.increment();
            } else {
                this.failureCounter.increment();
            }
            this.timer.record(durationInNs, TimeUnit.NANOSECONDS);
        }
    }
}

