/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.arc.Arc;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.HttpCommonTags;
import io.quarkus.micrometer.runtime.binder.RequestMetricInfo;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

public class RestClientMetricsListener
implements RestClientListener {
    private static final String REQUEST_METRIC_PROPERTY = "restClientMetrics";
    final MeterRegistry registry = Metrics.globalRegistry;
    boolean initialized = false;
    boolean clientMetricsEnabled = false;
    HttpBinderConfiguration httpMetricsConfig;
    MetricsClientRequestFilter clientRequestFilter;
    MetricsClientResponseFilter clientResponseFilter;

    public void onNewClient(Class<?> serviceInterface, RestClientBuilder builder) {
        MicrometerConfig micrometerConfig = (MicrometerConfig)Arc.container().instance(MicrometerConfig.class, new Annotation[0]).get();
        if (!micrometerConfig.enabled) {
            return;
        }
        if (this.prepClientMetrics()) {
            builder.register((Object)this.clientRequestFilter, 3001);
            builder.register((Object)this.clientResponseFilter, 3001);
        }
    }

    boolean prepClientMetrics() {
        boolean clientMetricsEnabled = this.clientMetricsEnabled;
        if (!this.initialized) {
            this.httpMetricsConfig = (HttpBinderConfiguration)Arc.container().instance(HttpBinderConfiguration.class, new Annotation[0]).get();
            clientMetricsEnabled = this.httpMetricsConfig.isClientEnabled();
            if (clientMetricsEnabled) {
                this.clientRequestFilter = new MetricsClientRequestFilter(this.httpMetricsConfig);
                this.clientResponseFilter = new MetricsClientResponseFilter();
            }
            this.clientMetricsEnabled = clientMetricsEnabled;
            this.initialized = true;
        }
        return clientMetricsEnabled;
    }

    class RestClientMetricInfo
    extends RequestMetricInfo {
        ClientRequestContext requestContext;

        RestClientMetricInfo(ClientRequestContext requestContext) {
            this.requestContext = requestContext;
        }
    }

    class MetricsClientResponseFilter
    implements ClientResponseFilter {
        MetricsClientResponseFilter() {
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
            RequestMetricInfo requestMetric = this.getRequestMetric(requestContext);
            if (requestMetric != null) {
                String templatePath = (String)requestContext.getProperty("UrlPathTemplate");
                String requestPath = requestMetric.getNormalizedUriPath(RestClientMetricsListener.this.httpMetricsConfig.getClientMatchPatterns(), RestClientMetricsListener.this.httpMetricsConfig.getClientIgnorePatterns(), templatePath == null ? requestContext.getUri().getPath() : templatePath);
                if (requestPath != null) {
                    Timer.Sample sample = requestMetric.getSample();
                    int statusCode = responseContext.getStatus();
                    Timer.Builder builder = Timer.builder((String)RestClientMetricsListener.this.httpMetricsConfig.getHttpClientRequestsName()).tags((Iterable)Tags.of((Tag[])new Tag[]{HttpCommonTags.method(requestContext.getMethod()), HttpCommonTags.uri(requestPath, statusCode), HttpCommonTags.outcome(statusCode), HttpCommonTags.status(statusCode), this.clientName(requestContext)}));
                    sample.stop(builder.register(RestClientMetricsListener.this.registry));
                }
            }
        }

        private RequestMetricInfo getRequestMetric(ClientRequestContext requestContext) {
            return (RequestMetricInfo)requestContext.getProperty(RestClientMetricsListener.REQUEST_METRIC_PROPERTY);
        }

        private Tag clientName(ClientRequestContext requestContext) {
            String host = requestContext.getUri().getHost();
            if (host == null) {
                host = "none";
            }
            return Tag.of((String)"clientName", (String)host);
        }
    }

    class MetricsClientRequestFilter
    implements ClientRequestFilter {
        HttpBinderConfiguration binderConfiguration;

        MetricsClientRequestFilter(HttpBinderConfiguration binderConfiguration) {
            this.binderConfiguration = binderConfiguration;
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            RestClientMetricInfo requestMetric = new RestClientMetricInfo(requestContext);
            requestMetric.setSample(Timer.start((MeterRegistry)RestClientMetricsListener.this.registry));
            requestContext.setProperty(RestClientMetricsListener.REQUEST_METRIC_PROPERTY, (Object)requestMetric);
        }
    }
}

