/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.config;

import io.quarkus.micrometer.runtime.config.GrpcClientConfigGroup;
import io.quarkus.micrometer.runtime.config.GrpcServerConfigGroup;
import io.quarkus.micrometer.runtime.config.HttpClientConfigGroup;
import io.quarkus.micrometer.runtime.config.HttpServerConfigGroup;
import io.quarkus.micrometer.runtime.config.JsonConfigGroup;
import io.quarkus.micrometer.runtime.config.KafkaConfigGroup;
import io.quarkus.micrometer.runtime.config.MPMetricsConfigGroup;
import io.quarkus.micrometer.runtime.config.NettyConfigGroup;
import io.quarkus.micrometer.runtime.config.PrometheusConfigGroup;
import io.quarkus.micrometer.runtime.config.ReactiveMessagingConfigGroup;
import io.quarkus.micrometer.runtime.config.RedisConfigGroup;
import io.quarkus.micrometer.runtime.config.StorkConfigGroup;
import io.quarkus.micrometer.runtime.config.VertxConfigGroup;
import io.quarkus.micrometer.runtime.config.VirtualThreadsConfigGroup;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Optional;

@ConfigRoot(name="micrometer", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public final class MicrometerConfig {
    @ConfigItem(defaultValue="true")
    public boolean enabled;
    @ConfigItem(defaultValue="true")
    public boolean registryEnabledDefault;
    @ConfigItem(defaultValue="true")
    public boolean binderEnabledDefault;
    public BinderConfig binder;
    public ExportConfig export;

    public boolean checkRegistryEnabledWithDefault(CapabilityEnabled config) {
        if (this.enabled) {
            Optional<Boolean> configValue = config.getEnabled();
            return configValue.orElseGet(() -> this.registryEnabledDefault);
        }
        return false;
    }

    public boolean checkBinderEnabledWithDefault(CapabilityEnabled config) {
        if (this.enabled) {
            Optional<Boolean> configValue = config.getEnabled();
            return configValue.orElseGet(() -> this.binderEnabledDefault);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{enabled=" + this.enabled + ",binderEnabledDefault=" + this.binderEnabledDefault + ",registryEnabledDefault=" + this.registryEnabledDefault + "}";
    }

    public static interface CapabilityEnabled {
        public Optional<Boolean> getEnabled();
    }

    @ConfigGroup
    public static class ExportConfig {
        public JsonConfigGroup json;
        public PrometheusConfigGroup prometheus;
    }

    @ConfigGroup
    public static class BinderConfig {
        public HttpClientConfigGroup httpClient;
        public HttpServerConfigGroup httpServer;
        @ConfigItem
        public Optional<Boolean> jvm;
        public KafkaConfigGroup kafka;
        public RedisConfigGroup redis;
        public StorkConfigGroup stork;
        public GrpcServerConfigGroup grpcServer;
        public GrpcClientConfigGroup grpcClient;
        public ReactiveMessagingConfigGroup messaging;
        public MPMetricsConfigGroup mpMetrics;
        public VirtualThreadsConfigGroup virtualThreads;
        @ConfigItem
        public Optional<Boolean> system;
        public VertxConfigGroup vertx;
        public NettyConfigGroup netty;
    }
}

