/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.mpmetrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.quarkus.micrometer.runtime.binder.mpmetrics.AnnotatedGaugeAdapter;
import io.quarkus.micrometer.runtime.binder.mpmetrics.ConcurrentGaugeImpl;
import io.quarkus.micrometer.runtime.binder.mpmetrics.CounterAdapter;
import io.quarkus.micrometer.runtime.binder.mpmetrics.GaugeAdapter;
import io.quarkus.micrometer.runtime.binder.mpmetrics.HistogramAdapter;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MeterAdapter;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MeterHolder;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MetricDescriptor;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetadata;
import io.quarkus.micrometer.runtime.binder.mpmetrics.TimerAdapter;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;

public class MetricRegistryAdapter
implements MetricRegistry {
    final MetricRegistry.Type type;
    final MeterRegistry registry;
    Map<MetricDescriptor, MeterHolder> constructedMeters = new ConcurrentHashMap<MetricDescriptor, MeterHolder>();
    Map<String, MpMetadata> metadataMap = new ConcurrentHashMap<String, MpMetadata>();

    public MetricRegistryAdapter(MetricRegistry.Type type, MeterRegistry registry) {
        this.type = type;
        this.registry = registry;
    }

    public <T extends org.eclipse.microprofile.metrics.Metric> T register(String name, T t) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Can not register a pre-constructed Metric with Micrometer");
    }

    public <T extends org.eclipse.microprofile.metrics.Metric> T register(Metadata metadata, T t) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Can not register a pre-constructed Metric with Micrometer");
    }

    public <T extends org.eclipse.microprofile.metrics.Metric> T register(Metadata metadata, T t, Tag ... tags) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Can not register a pre-constructed Metric with Micrometer");
    }

    public Counter counter(String name) {
        return this.internalCounter(this.internalGetMetadata(name, MetricType.COUNTER), new MetricDescriptor(name, this.scopeTags()));
    }

    public Counter counter(String name, Tag ... tags) {
        return this.internalCounter(this.internalGetMetadata(name, MetricType.COUNTER), new MetricDescriptor(name, this.scopeTags(tags)));
    }

    public Counter counter(MetricID metricID) {
        String name = metricID.getName();
        return this.internalCounter(this.internalGetMetadata(name, MetricType.COUNTER), new MetricDescriptor(name, this.scopeTags(metricID.getTagsAsArray())));
    }

    public Counter counter(Metadata metadata) {
        return this.internalCounter(this.internalGetMetadata(metadata, MetricType.COUNTER), new MetricDescriptor(metadata.getName(), this.scopeTags()));
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        return this.internalCounter(this.internalGetMetadata(metadata, MetricType.COUNTER), new MetricDescriptor(metadata.getName(), this.scopeTags(tags)));
    }

    Counter interceptorCounter(Metadata metadata, String ... tags) {
        return this.internalCounter(this.internalGetMetadata(metadata, MetricType.COUNTER), new MetricDescriptor(metadata.getName(), this.scopeTags(tags)));
    }

    Counter injectedCounter(Metric annotation) {
        return this.internalCounter(this.internalGetMetadata(annotation.name(), MetricType.COUNTER).merge(annotation), new MetricDescriptor(annotation.name(), this.scopeTags(annotation.tags())));
    }

    CounterAdapter internalCounter(MpMetadata metadata, MetricDescriptor id) {
        CounterAdapter result = this.checkCast(CounterAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new CounterAdapter()));
        return result.register(metadata, id, this.registry);
    }

    public ConcurrentGauge concurrentGauge(String name) {
        return this.internalConcurrentGauge(this.internalGetMetadata(name, MetricType.CONCURRENT_GAUGE), new MetricDescriptor(name, this.scopeTags()));
    }

    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        return this.internalConcurrentGauge(this.internalGetMetadata(name, MetricType.CONCURRENT_GAUGE), new MetricDescriptor(name, this.scopeTags(tags)));
    }

    public ConcurrentGauge concurrentGauge(MetricID metricID) {
        String name = metricID.getName();
        return this.internalConcurrentGauge(this.internalGetMetadata(name, MetricType.CONCURRENT_GAUGE), new MetricDescriptor(name, this.scopeTags(metricID.getTagsAsArray())));
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata) {
        return this.internalConcurrentGauge(this.internalGetMetadata(metadata, MetricType.CONCURRENT_GAUGE), new MetricDescriptor(metadata.getName(), this.scopeTags()));
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return this.internalConcurrentGauge(this.internalGetMetadata(metadata, MetricType.CONCURRENT_GAUGE), new MetricDescriptor(metadata.getName(), this.scopeTags(tags)));
    }

    ConcurrentGaugeImpl interceptorConcurrentGauge(Metadata metadata, String ... tags) {
        return this.internalConcurrentGauge(this.internalGetMetadata(metadata, MetricType.CONCURRENT_GAUGE), new MetricDescriptor(metadata.getName(), this.scopeTags(tags)));
    }

    ConcurrentGaugeImpl injectedConcurrentGauge(Metric annotation) {
        return this.internalConcurrentGauge(this.internalGetMetadata(annotation.name(), MetricType.CONCURRENT_GAUGE).merge(annotation), new MetricDescriptor(annotation.name(), this.scopeTags(annotation.tags())));
    }

    ConcurrentGaugeImpl internalConcurrentGauge(MpMetadata metadata, MetricDescriptor id) {
        ConcurrentGaugeImpl result = this.checkCast(ConcurrentGaugeImpl.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new ConcurrentGaugeImpl()));
        return result.register(metadata, id, this.registry);
    }

    public <T> Gauge<Double> gauge(String name, T o, ToDoubleFunction<T> f) {
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.scopeTags()), o, f);
    }

    public <T> Gauge<Double> gauge(String name, T o, ToDoubleFunction<T> f, Tag ... tags) {
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.scopeTags(tags)), o, f);
    }

    public <T, R extends Number> Gauge<R> gauge(String name, T o, Function<T, R> f, Tag ... tags) {
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.scopeTags(tags)), o, f);
    }

    public <T, R extends Number> Gauge<R> gauge(MetricID metricID, T o, Function<T, R> f) {
        String name = metricID.getName();
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.scopeTags()), o, f);
    }

    public <T, R extends Number> Gauge<R> gauge(Metadata metadata, T o, Function<T, R> f, Tag ... tags) {
        String name = metadata.getName();
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.scopeTags(tags)), o, f);
    }

    <T> GaugeAdapter<Double> internalGauge(MpMetadata metadata, MetricDescriptor id, T obj, ToDoubleFunction<T> f) {
        GaugeAdapter.DoubleFunctionGauge result = this.checkCast(GaugeAdapter.DoubleFunctionGauge.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new GaugeAdapter.DoubleFunctionGauge<Object>(obj, f)));
        return result.register(metadata, id, this.registry);
    }

    <T, R extends Number> GaugeAdapter<R> internalGauge(MpMetadata metadata, MetricDescriptor id, T obj, Function<T, R> f) {
        GaugeAdapter.FunctionGauge result = this.checkCast(GaugeAdapter.FunctionGauge.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new GaugeAdapter.FunctionGauge(obj, f)));
        return result.register(metadata, id, this.registry);
    }

    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> f) {
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.scopeTags()), f);
    }

    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> f, Tag ... tags) {
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.scopeTags(tags)), f);
    }

    public <T extends Number> Gauge<T> gauge(MetricID metricID, Supplier<T> f) {
        String name = metricID.getName();
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.scopeTags()), f);
    }

    public <T extends Number> Gauge<T> gauge(Metadata metadata, Supplier<T> f, Tag ... tags) {
        String name = metadata.getName();
        return this.internalGauge(this.internalGetMetadata(name, MetricType.GAUGE), new MetricDescriptor(name, this.scopeTags(tags)), f);
    }

    <T extends Number> GaugeAdapter<T> internalGauge(MpMetadata metadata, MetricDescriptor id, Supplier<T> f) {
        GaugeAdapter result = this.checkCast(GaugeAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new GaugeAdapter.NumberSupplierGauge(f)));
        return result.register(metadata, id, this.registry);
    }

    void bindAnnotatedGauge(AnnotatedGaugeAdapter adapter) {
        MetricDescriptor id = new MetricDescriptor(adapter.name(), adapter.tags());
        AnnotatedGaugeAdapter oops = this.checkCast(AnnotatedGaugeAdapter.class, adapter.getMetadata(), this.constructedMeters.putIfAbsent(id, adapter));
        if (oops != null) {
            throw new IllegalArgumentException(String.format("Gauge %s already exists. (existing='%s', new='%s')", adapter.getId(), oops.getTargetName(), adapter.getTargetName()));
        }
        this.metadataMap.put(adapter.name(), adapter.getMetadata());
        adapter.register(id, this.registry);
    }

    public Histogram histogram(String name) {
        return this.internalHistogram(this.internalGetMetadata(name, MetricType.HISTOGRAM), new MetricDescriptor(name, this.scopeTags()));
    }

    public Histogram histogram(String name, Tag ... tags) {
        return this.internalHistogram(this.internalGetMetadata(name, MetricType.HISTOGRAM), new MetricDescriptor(name, this.scopeTags(tags)));
    }

    public Histogram histogram(MetricID metricID) {
        String name = metricID.getName();
        return this.internalHistogram(this.internalGetMetadata(name, MetricType.HISTOGRAM), new MetricDescriptor(name, this.scopeTags(metricID.getTagsAsArray())));
    }

    public Histogram histogram(Metadata metadata) {
        return this.internalHistogram(this.internalGetMetadata(metadata, MetricType.HISTOGRAM), new MetricDescriptor(metadata.getName(), this.scopeTags()));
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return this.internalHistogram(this.internalGetMetadata(metadata, MetricType.HISTOGRAM), new MetricDescriptor(metadata.getName(), this.scopeTags(tags)));
    }

    HistogramAdapter injectedHistogram(Metric annotation) {
        return this.internalHistogram(this.internalGetMetadata(annotation.name(), MetricType.HISTOGRAM).merge(annotation), new MetricDescriptor(annotation.name(), this.scopeTags(annotation.tags())));
    }

    HistogramAdapter internalHistogram(MpMetadata metadata, MetricDescriptor id) {
        HistogramAdapter result = this.checkCast(HistogramAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new HistogramAdapter()));
        return result.register(metadata, id, this.registry);
    }

    public Meter meter(String name) {
        return this.internalMeter(this.internalGetMetadata(name, MetricType.METERED), new MetricDescriptor(name, this.scopeTags()));
    }

    public Meter meter(String name, Tag ... tags) {
        return this.internalMeter(this.internalGetMetadata(name, MetricType.METERED), new MetricDescriptor(name, this.scopeTags(tags)));
    }

    public Meter meter(MetricID metricID) {
        String name = metricID.getName();
        return this.internalMeter(this.internalGetMetadata(name, MetricType.METERED), new MetricDescriptor(name, this.scopeTags(metricID.getTagsAsArray())));
    }

    public Meter meter(Metadata metadata) {
        return this.internalMeter(this.internalGetMetadata(metadata, MetricType.METERED), new MetricDescriptor(metadata.getName(), this.scopeTags()));
    }

    public Meter meter(Metadata metadata, Tag ... tags) {
        return this.internalMeter(this.internalGetMetadata(metadata, MetricType.METERED), new MetricDescriptor(metadata.getName(), this.scopeTags(tags)));
    }

    MeterAdapter injectedMeter(Metric annotation) {
        return this.internalMeter(this.internalGetMetadata(annotation.name(), MetricType.METERED).merge(annotation), new MetricDescriptor(annotation.name(), this.scopeTags(annotation.tags())));
    }

    MeterAdapter internalMeter(MpMetadata metadata, MetricDescriptor id) {
        MeterAdapter result = this.checkCast(MeterAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new MeterAdapter()));
        return result.register(metadata, id, this.registry);
    }

    public Timer timer(String name) {
        return this.internalTimer(this.internalGetMetadata(name, MetricType.TIMER), new MetricDescriptor(name, this.scopeTags()));
    }

    public Timer timer(String name, Tag ... tags) {
        return this.internalTimer(this.internalGetMetadata(name, MetricType.TIMER), new MetricDescriptor(name, this.scopeTags(tags)));
    }

    public Timer timer(MetricID metricID) {
        String name = metricID.getName();
        return this.internalTimer(this.internalGetMetadata(name, MetricType.TIMER), new MetricDescriptor(name, this.scopeTags(metricID.getTagsAsArray())));
    }

    public Timer timer(Metadata metadata) {
        return this.internalTimer(this.internalGetMetadata(metadata, MetricType.TIMER), new MetricDescriptor(metadata.getName(), this.scopeTags()));
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return this.internalTimer(this.internalGetMetadata(metadata, MetricType.TIMER), new MetricDescriptor(metadata.getName(), this.scopeTags(tags)));
    }

    TimerAdapter injectedTimer(Metric annotation) {
        return this.internalTimer(this.internalGetMetadata(annotation.name(), MetricType.TIMER).merge(annotation), new MetricDescriptor(annotation.name(), this.scopeTags(annotation.tags())));
    }

    TimerAdapter interceptorTimer(Metadata metadata, String ... tags) {
        return this.internalTimer(this.internalGetMetadata(metadata, MetricType.TIMER), new MetricDescriptor(metadata.getName(), this.scopeTags(tags)));
    }

    TimerAdapter internalTimer(MpMetadata metadata, MetricDescriptor id) {
        TimerAdapter result = this.checkCast(TimerAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new TimerAdapter(this.registry)));
        return result.register(metadata, id);
    }

    public SimpleTimer simpleTimer(String name) {
        return this.internalSimpleTimer(this.internalGetMetadata(name, MetricType.SIMPLE_TIMER), new MetricDescriptor(name, this.scopeTags()));
    }

    public SimpleTimer simpleTimer(String name, Tag ... tags) {
        return this.internalSimpleTimer(this.internalGetMetadata(name, MetricType.SIMPLE_TIMER), new MetricDescriptor(name, this.scopeTags(tags)));
    }

    public SimpleTimer simpleTimer(MetricID metricID) {
        String name = metricID.getName();
        return this.internalSimpleTimer(this.internalGetMetadata(name, MetricType.SIMPLE_TIMER), new MetricDescriptor(name, this.scopeTags(metricID.getTagsAsArray())));
    }

    public SimpleTimer simpleTimer(Metadata metadata) {
        return this.internalSimpleTimer(this.internalGetMetadata(metadata, MetricType.SIMPLE_TIMER), new MetricDescriptor(metadata.getName(), this.scopeTags()));
    }

    public SimpleTimer simpleTimer(Metadata metadata, Tag ... tags) {
        return this.internalSimpleTimer(this.internalGetMetadata(metadata, MetricType.SIMPLE_TIMER), new MetricDescriptor(metadata.getName(), this.scopeTags(tags)));
    }

    public org.eclipse.microprofile.metrics.Metric getMetric(MetricID metricID) {
        return this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.scopeTags(metricID.getTagsAsArray())));
    }

    public <T extends org.eclipse.microprofile.metrics.Metric> T getMetric(MetricID metricID, Class<T> asType) {
        return (T)((org.eclipse.microprofile.metrics.Metric)asType.cast(this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.scopeTags(metricID.getTagsAsArray())))));
    }

    public Counter getCounter(MetricID metricID) {
        return (Counter)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.scopeTags(metricID.getTagsAsArray())));
    }

    public ConcurrentGauge getConcurrentGauge(MetricID metricID) {
        return (ConcurrentGauge)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.scopeTags(metricID.getTagsAsArray())));
    }

    public Gauge<?> getGauge(MetricID metricID) {
        return (Gauge)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.scopeTags(metricID.getTagsAsArray())));
    }

    public Histogram getHistogram(MetricID metricID) {
        return (Histogram)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.scopeTags(metricID.getTagsAsArray())));
    }

    public Meter getMeter(MetricID metricID) {
        return (Meter)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.scopeTags(metricID.getTagsAsArray())));
    }

    public Timer getTimer(MetricID metricID) {
        return (Timer)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.scopeTags(metricID.getTagsAsArray())));
    }

    public SimpleTimer getSimpleTimer(MetricID metricID) {
        return (SimpleTimer)this.constructedMeters.get(new MetricDescriptor(metricID.getName(), this.scopeTags(metricID.getTagsAsArray())));
    }

    public Metadata getMetadata(String name) {
        return this.metadataMap.get(name);
    }

    TimerAdapter injectedSimpleTimer(Metric annotation) {
        return this.internalSimpleTimer(this.internalGetMetadata(annotation.name(), MetricType.SIMPLE_TIMER).merge(annotation), new MetricDescriptor(annotation.name(), this.scopeTags(annotation.tags())));
    }

    TimerAdapter internalSimpleTimer(MpMetadata metadata, MetricDescriptor id) {
        TimerAdapter result = this.checkCast(TimerAdapter.class, metadata, this.constructedMeters.computeIfAbsent(id, k -> new TimerAdapter(this.registry)));
        return result.register(metadata, id);
    }

    public boolean remove(String name) {
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            if (!e.getKey().name().equals(name)) continue;
            this.constructedMeters.remove(e.getKey());
            this.registry.remove(e.getValue().getMeter());
        }
        return this.metadataMap.remove(name) != null;
    }

    public boolean remove(MetricID metricID) {
        return this.internalRemove(new MetricDescriptor(metricID));
    }

    public void removeMatching(MetricFilter metricFilter) {
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid = e.getKey().toMetricID();
            if (!metricFilter.matches(mid, (org.eclipse.microprofile.metrics.Metric)e.getValue())) continue;
            this.internalRemove(e.getKey());
        }
    }

    boolean internalRemove(MetricDescriptor match) {
        MeterHolder holder = this.constructedMeters.remove(match);
        if (holder != null) {
            this.registry.remove(holder.getMeter());
            if (this.constructedMeters.keySet().stream().noneMatch(id -> id.name.equals(match.name))) {
                this.metadataMap.remove(match.name);
            }
        }
        return holder != null;
    }

    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.metadataMap.keySet());
    }

    public SortedSet<MetricID> getMetricIDs() {
        TreeSet<MetricID> out = new TreeSet<MetricID>();
        for (MetricDescriptor key : this.constructedMeters.keySet()) {
            out.add(key.toMetricID());
        }
        return out;
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.GAUGE, metricFilter);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.COUNTER, metricFilter);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.getConcurrentGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.CONCURRENT_GAUGE, metricFilter);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.HISTOGRAM, metricFilter);
    }

    public SortedMap<MetricID, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Meter> getMeters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.METERED, metricFilter);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.TIMER, metricFilter);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers() {
        return this.getSimpleTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.SIMPLE_TIMER, metricFilter);
    }

    public SortedMap<MetricID, org.eclipse.microprofile.metrics.Metric> getMetrics(MetricFilter filter) {
        TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric> out = new TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid = e.getKey().toMetricID();
            if (!filter.matches(mid, (org.eclipse.microprofile.metrics.Metric)e.getValue())) continue;
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    public <T extends org.eclipse.microprofile.metrics.Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric> out = new TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid;
            if (!e.getValue().getType().equals((Object)MetricType.from(ofType)) || !filter.matches(mid = e.getKey().toMetricID(), (org.eclipse.microprofile.metrics.Metric)e.getValue())) continue;
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    public Map<MetricID, org.eclipse.microprofile.metrics.Metric> getMetrics() {
        TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric> out = new TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    <T extends org.eclipse.microprofile.metrics.Metric> SortedMap<MetricID, T> getMetrics(MetricType type, MetricFilter filter) {
        TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric> out = new TreeMap<MetricID, org.eclipse.microprofile.metrics.Metric>();
        for (Map.Entry<MetricDescriptor, MeterHolder> e : this.constructedMeters.entrySet()) {
            MetricID mid;
            if (e.getValue().getType() != type || !filter.matches(mid = e.getKey().toMetricID(), (org.eclipse.microprofile.metrics.Metric)e.getValue())) continue;
            out.put(e.getKey().toMetricID(), e.getValue());
        }
        return out;
    }

    public Map<String, Metadata> getMetadata() {
        return Collections.unmodifiableMap(this.metadataMap);
    }

    public MetricRegistry.Type getType() {
        return null;
    }

    Tags scopeTags() {
        return Tags.of((String)"scope", (String)this.type.getName());
    }

    Tags scopeTags(Tag ... tags) {
        Tags out = this.scopeTags();
        for (Tag t : tags) {
            out = out.and(t.getTagName(), t.getTagValue());
        }
        return out;
    }

    Tags scopeTags(String ... tags) {
        Tags in = Tags.of((String[])tags);
        return this.scopeTags().and((Iterable)in);
    }

    private MpMetadata internalGetMetadata(String name, MetricType type) {
        MpMetadata result = this.metadataMap.computeIfAbsent(name, k -> new MpMetadata(name, type));
        if (result.type != type) {
            throw new IllegalArgumentException(String.format("Metric %s already defined using a different type (%s)", name, result.getType()));
        }
        return result;
    }

    private MpMetadata internalGetMetadata(Metadata metadata, MetricType type) {
        MpMetadata result = this.metadataMap.computeIfAbsent(metadata.getName(), k -> MpMetadata.sanitize(metadata, type));
        if (!result.mergeSameType(metadata)) {
            throw new IllegalArgumentException(String.format("Metric %s already defined using a different type (%s)", metadata.getName(), result.getType()));
        }
        return result;
    }

    <T> T checkCast(Class<T> type, MpMetadata metadata, MeterHolder o) {
        try {
            return type.cast(o);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(String.format("Metric %s already defined using a different type (%s)", metadata.name, o.getType().name()), cce);
        }
    }
}

