/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.deployment;

import com.mongodb.client.MongoClient;
import com.mongodb.event.ConnectionPoolListener;
import io.quarkus.arc.Unremovable;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.annotations.Weak;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.mongodb.ReactiveMongoClient;
import io.quarkus.mongodb.deployment.BsonDiscriminatorBuildItem;
import io.quarkus.mongodb.deployment.CodecProviderBuildItem;
import io.quarkus.mongodb.deployment.MongoClientBuildItem;
import io.quarkus.mongodb.deployment.MongoClientBuildTimeConfig;
import io.quarkus.mongodb.deployment.MongoClientNameBuildItem;
import io.quarkus.mongodb.deployment.MongoConnectionNameBuildItem;
import io.quarkus.mongodb.deployment.MongoConnectionPoolListenerBuildItem;
import io.quarkus.mongodb.deployment.MongoUnremovableClientsBuildItem;
import io.quarkus.mongodb.metrics.MongoMetricsConnectionPoolListener;
import io.quarkus.mongodb.runtime.AbstractMongoClientProducer;
import io.quarkus.mongodb.runtime.MongoClientConfig;
import io.quarkus.mongodb.runtime.MongoClientName;
import io.quarkus.mongodb.runtime.MongoClientRecorder;
import io.quarkus.mongodb.runtime.MongodbConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.pojo.annotations.BsonDiscriminator;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class MongoClientProcessor {
    private static DotName MONGOCLIENT_ANNOTATION = DotName.createSimple((String)MongoClientName.class.getName());
    private static final DotName UNREMOVABLE_BEAN = DotName.createSimple((String)AbstractMongoClientProducer.class.getName());

    @BuildStep
    BeanDefiningAnnotationBuildItem registerConnectionBean() {
        return new BeanDefiningAnnotationBuildItem(MONGOCLIENT_ANNOTATION);
    }

    @BuildStep
    UnremovableBeanBuildItem markBeansAsUnremovable() {
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanTypeExclusion(UNREMOVABLE_BEAN));
    }

    @BuildStep
    CodecProviderBuildItem collectCodecProviders(CombinedIndexBuildItem indexBuildItem) {
        Collection codecProviderClasses = indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)CodecProvider.class.getName()));
        List<String> names = codecProviderClasses.stream().map(ci -> ci.name().toString()).collect(Collectors.toList());
        return new CodecProviderBuildItem(names);
    }

    @BuildStep
    BsonDiscriminatorBuildItem collectBsonDiscriminators(CombinedIndexBuildItem indexBuildItem) {
        ArrayList<String> names = new ArrayList<String>();
        DotName bsonDiscriminatorName = DotName.createSimple((String)BsonDiscriminator.class.getName());
        for (AnnotationInstance annotationInstance : indexBuildItem.getIndex().getAnnotations(bsonDiscriminatorName)) {
            names.add(annotationInstance.target().asClass().name().toString());
        }
        return new BsonDiscriminatorBuildItem(names);
    }

    @BuildStep
    List<ReflectiveClassBuildItem> addCodecsAndDiscriminatorsToNative(CodecProviderBuildItem codecProviders, BsonDiscriminatorBuildItem bsonDiscriminators) {
        ArrayList<String> reflectiveClassNames = new ArrayList<String>();
        reflectiveClassNames.addAll(codecProviders.getCodecProviderClassNames());
        reflectiveClassNames.addAll(bsonDiscriminators.getBsonDiscriminatorClassNames());
        return reflectiveClassNames.stream().map(s -> new ReflectiveClassBuildItem(true, true, false, new String[]{s})).collect(Collectors.toList());
    }

    @BuildStep
    public void mongoClientNames(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<MongoClientNameBuildItem> mongoClientName) {
        HashSet<String> values = new HashSet<String>();
        IndexView indexView = applicationArchivesBuildItem.getRootArchive().getIndex();
        Collection mongoClientAnnotations = indexView.getAnnotations(MONGOCLIENT_ANNOTATION);
        for (AnnotationInstance annotation : mongoClientAnnotations) {
            values.add(annotation.value().asString());
        }
        for (String value : values) {
            mongoClientName.produce((BuildItem)new MongoClientNameBuildItem(value));
        }
    }

    private void createMongoClientProducerBean(List<MongoClientNameBuildItem> mongoClientNames, BuildProducer<GeneratedBeanBuildItem> generatedBean, String mongoClientProducerClassName, boolean makeUnremovable) {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBean);
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(mongoClientProducerClassName).superClass(AbstractMongoClientProducer.class).build();){
            ResultHandle defaultReactiveMongoClientNameRH;
            ResultHandle mongoReactiveClientConfig2;
            classCreator.addAnnotation(ApplicationScoped.class);
            try (MethodCreator defaultMongoClientMethodCreator = classCreator.getMethodCreator("createDefaultMongoClient", MongoClient.class, new Class[0]);){
                defaultMongoClientMethodCreator.addAnnotation(ApplicationScoped.class);
                defaultMongoClientMethodCreator.addAnnotation(Produces.class);
                defaultMongoClientMethodCreator.addAnnotation(Default.class);
                if (makeUnremovable) {
                    defaultMongoClientMethodCreator.addAnnotation(Unremovable.class);
                }
                ResultHandle mongoClientConfig = defaultMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"getDefaultMongoClientConfig", MongoClientConfig.class, (Class[])new Class[0]), defaultMongoClientMethodCreator.getThis(), new ResultHandle[0]);
                ResultHandle defaultMongoClientNameRH = defaultMongoClientMethodCreator.load("<default>");
                defaultMongoClientMethodCreator.returnValue(defaultMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"createMongoClient", MongoClient.class, (Class[])new Class[]{MongoClientConfig.class, String.class}), defaultMongoClientMethodCreator.getThis(), new ResultHandle[]{mongoClientConfig, defaultMongoClientNameRH}));
            }
            var9_11 = null;
            try (MethodCreator defaultReactiveMongoClientMethodCreator = classCreator.getMethodCreator("createDefaultLegacyReactiveMongoClient", ReactiveMongoClient.class, new Class[0]);){
                defaultReactiveMongoClientMethodCreator.addAnnotation(ApplicationScoped.class);
                defaultReactiveMongoClientMethodCreator.addAnnotation(Produces.class);
                defaultReactiveMongoClientMethodCreator.addAnnotation(Default.class);
                mongoReactiveClientConfig2 = defaultReactiveMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"getDefaultMongoClientConfig", MongoClientConfig.class, (Class[])new Class[0]), defaultReactiveMongoClientMethodCreator.getThis(), new ResultHandle[0]);
                defaultReactiveMongoClientNameRH = defaultReactiveMongoClientMethodCreator.load("<default>");
                defaultReactiveMongoClientMethodCreator.returnValue(defaultReactiveMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"createLegacyReactiveMongoClient", ReactiveMongoClient.class, (Class[])new Class[]{MongoClientConfig.class, String.class}), defaultReactiveMongoClientMethodCreator.getThis(), new ResultHandle[]{mongoReactiveClientConfig2, defaultReactiveMongoClientNameRH}));
            }
            catch (Throwable mongoReactiveClientConfig2) {
                var9_11 = mongoReactiveClientConfig2;
                throw mongoReactiveClientConfig2;
            }
            defaultReactiveMongoClientMethodCreator = classCreator.getMethodCreator("createDefaultReactiveMongoClient", io.quarkus.mongodb.reactive.ReactiveMongoClient.class, new Class[0]);
            var9_11 = null;
            try {
                defaultReactiveMongoClientMethodCreator.addAnnotation(ApplicationScoped.class);
                defaultReactiveMongoClientMethodCreator.addAnnotation(Produces.class);
                defaultReactiveMongoClientMethodCreator.addAnnotation(Default.class);
                if (makeUnremovable) {
                    defaultReactiveMongoClientMethodCreator.addAnnotation(Unremovable.class);
                }
                mongoReactiveClientConfig2 = defaultReactiveMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"getDefaultMongoClientConfig", MongoClientConfig.class, (Class[])new Class[0]), defaultReactiveMongoClientMethodCreator.getThis(), new ResultHandle[0]);
                defaultReactiveMongoClientNameRH = defaultReactiveMongoClientMethodCreator.load("<default>");
                defaultReactiveMongoClientMethodCreator.returnValue(defaultReactiveMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"createReactiveMongoClient", io.quarkus.mongodb.reactive.ReactiveMongoClient.class, (Class[])new Class[]{MongoClientConfig.class, String.class}), defaultReactiveMongoClientMethodCreator.getThis(), new ResultHandle[]{mongoReactiveClientConfig2, defaultReactiveMongoClientNameRH}));
            }
            catch (Throwable mongoReactiveClientConfig3) {
                var9_11 = mongoReactiveClientConfig3;
                throw mongoReactiveClientConfig3;
            }
            finally {
                if (defaultReactiveMongoClientMethodCreator != null) {
                    if (var9_11 != null) {
                        try {
                            defaultReactiveMongoClientMethodCreator.close();
                        }
                        catch (Throwable mongoReactiveClientConfig3) {
                            var9_11.addSuppressed(mongoReactiveClientConfig3);
                        }
                    } else {
                        defaultReactiveMongoClientMethodCreator.close();
                    }
                }
            }
            for (MongoClientNameBuildItem bi : mongoClientNames) {
                ResultHandle namedReactiveMongoClientConfig;
                ResultHandle namedReactiveMongoClientNameRH2;
                String namedMongoClientName = bi.getName();
                try (MethodCreator namedMongoClientMethodCreator = classCreator.getMethodCreator("createNamedMongoClient_" + HashUtil.sha1((String)namedMongoClientName), MongoClient.class, new Class[0]);){
                    namedMongoClientMethodCreator.addAnnotation(ApplicationScoped.class);
                    namedMongoClientMethodCreator.addAnnotation(Produces.class);
                    namedMongoClientMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)namedMongoClientName)}));
                    namedMongoClientMethodCreator.addAnnotation(AnnotationInstance.create((DotName)MONGOCLIENT_ANNOTATION, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)namedMongoClientName)}));
                    if (makeUnremovable) {
                        namedMongoClientMethodCreator.addAnnotation(Unremovable.class);
                    }
                    ResultHandle namedMongoClientNameRH = namedMongoClientMethodCreator.load(namedMongoClientName);
                    ResultHandle namedMongoClientConfig = namedMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"getMongoClientConfig", MongoClientConfig.class, (Class[])new Class[]{String.class}), namedMongoClientMethodCreator.getThis(), new ResultHandle[]{namedMongoClientNameRH});
                    namedMongoClientMethodCreator.returnValue(namedMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"createMongoClient", MongoClient.class, (Class[])new Class[]{MongoClientConfig.class, String.class}), namedMongoClientMethodCreator.getThis(), new ResultHandle[]{namedMongoClientConfig, namedMongoClientNameRH}));
                }
                var12_21 = null;
                try (MethodCreator namedReactiveMongoClientMethodCreator = classCreator.getMethodCreator("createNamedLegacyReactiveMongoClient_" + HashUtil.sha1((String)namedMongoClientName), ReactiveMongoClient.class, new Class[0]);){
                    namedReactiveMongoClientMethodCreator.addAnnotation(ApplicationScoped.class);
                    namedReactiveMongoClientMethodCreator.addAnnotation(Produces.class);
                    namedReactiveMongoClientMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)(namedMongoClientName + "reactive-legacy"))}));
                    namedReactiveMongoClientMethodCreator.addAnnotation(AnnotationInstance.create((DotName)MONGOCLIENT_ANNOTATION, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)namedMongoClientName)}));
                    namedReactiveMongoClientNameRH2 = namedReactiveMongoClientMethodCreator.load(namedMongoClientName);
                    namedReactiveMongoClientConfig = namedReactiveMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"getMongoClientConfig", MongoClientConfig.class, (Class[])new Class[]{String.class}), namedReactiveMongoClientMethodCreator.getThis(), new ResultHandle[]{namedReactiveMongoClientNameRH2});
                    namedReactiveMongoClientMethodCreator.returnValue(namedReactiveMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"createLegacyReactiveMongoClient", ReactiveMongoClient.class, (Class[])new Class[]{MongoClientConfig.class, String.class}), namedReactiveMongoClientMethodCreator.getThis(), new ResultHandle[]{namedReactiveMongoClientConfig, namedReactiveMongoClientNameRH2}));
                }
                catch (Throwable namedReactiveMongoClientNameRH2) {
                    var12_21 = namedReactiveMongoClientNameRH2;
                    throw namedReactiveMongoClientNameRH2;
                }
                namedReactiveMongoClientMethodCreator = classCreator.getMethodCreator("createNamedReactiveMongoClient_" + HashUtil.sha1((String)namedMongoClientName), io.quarkus.mongodb.reactive.ReactiveMongoClient.class, new Class[0]);
                var12_21 = null;
                try {
                    namedReactiveMongoClientMethodCreator.addAnnotation(ApplicationScoped.class);
                    namedReactiveMongoClientMethodCreator.addAnnotation(Produces.class);
                    namedReactiveMongoClientMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)(namedMongoClientName + "reactive"))}));
                    namedReactiveMongoClientMethodCreator.addAnnotation(AnnotationInstance.create((DotName)MONGOCLIENT_ANNOTATION, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)namedMongoClientName)}));
                    if (makeUnremovable) {
                        namedReactiveMongoClientMethodCreator.addAnnotation(Unremovable.class);
                    }
                    namedReactiveMongoClientNameRH2 = namedReactiveMongoClientMethodCreator.load(namedMongoClientName);
                    namedReactiveMongoClientConfig = namedReactiveMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"getMongoClientConfig", MongoClientConfig.class, (Class[])new Class[]{String.class}), namedReactiveMongoClientMethodCreator.getThis(), new ResultHandle[]{namedReactiveMongoClientNameRH2});
                    namedReactiveMongoClientMethodCreator.returnValue(namedReactiveMongoClientMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractMongoClientProducer.class, (String)"createReactiveMongoClient", io.quarkus.mongodb.reactive.ReactiveMongoClient.class, (Class[])new Class[]{MongoClientConfig.class, String.class}), namedReactiveMongoClientMethodCreator.getThis(), new ResultHandle[]{namedReactiveMongoClientConfig, namedReactiveMongoClientNameRH2}));
                }
                catch (Throwable throwable) {
                    var12_21 = throwable;
                    throw throwable;
                }
                finally {
                    if (namedReactiveMongoClientMethodCreator == null) continue;
                    if (var12_21 != null) {
                        try {
                            namedReactiveMongoClientMethodCreator.close();
                        }
                        catch (Throwable throwable) {
                            var12_21.addSuppressed(throwable);
                        }
                        continue;
                    }
                    namedReactiveMongoClientMethodCreator.close();
                }
            }
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    BeanContainerListenerBuildItem build(List<MongoClientNameBuildItem> mongoClientNames, RecorderContext recorderContext, MongoClientRecorder recorder, BuildProducer<FeatureBuildItem> feature, Optional<MongoUnremovableClientsBuildItem> mongoUnremovableClientsBuildItem, SslNativeConfigBuildItem sslNativeConfig, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<GeneratedBeanBuildItem> generatedBean) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("mongodb-client"));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem("mongodb-client"));
        String mongoClientProducerClassName = this.getMongoClientProducerClassName();
        this.createMongoClientProducerBean(mongoClientNames, generatedBean, mongoClientProducerClassName, mongoUnremovableClientsBuildItem.isPresent());
        return new BeanContainerListenerBuildItem(recorder.addMongoClient(recorderContext.classProxy(mongoClientProducerClassName), sslNativeConfig.isExplicitlyDisabled()));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configureRuntimePropertiesAndBuildClients(MongoClientRecorder recorder, CodecProviderBuildItem codecProvider, BsonDiscriminatorBuildItem bsonDiscriminator, List<MongoConnectionPoolListenerBuildItem> connectionPoolListenerProvider, List<MongoClientNameBuildItem> mongoClientNames, MongodbConfig mongodbConfig, ConfigurationBuildItem config, BuildProducer<MongoConnectionNameBuildItem> mongoConnections) {
        List poolListenerList = connectionPoolListenerProvider.stream().map(MongoConnectionPoolListenerBuildItem::getConnectionPoolListener).collect(Collectors.toList());
        recorder.configureRuntimeProperties(codecProvider.getCodecProviderClassNames(), bsonDiscriminator.getBsonDiscriminatorClassNames(), mongodbConfig, poolListenerList);
        mongoConnections.produce((BuildItem)new MongoConnectionNameBuildItem("<default>"));
        for (MongoClientNameBuildItem bi : mongoClientNames) {
            mongoConnections.produce((BuildItem)new MongoConnectionNameBuildItem(bi.getName()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT, optional=true)
    List<MongoClientBuildItem> mongoClients(MongoClientRecorder recorder, List<MongoConnectionNameBuildItem> mongoConnections) {
        ArrayList<MongoClientBuildItem> result = new ArrayList<MongoClientBuildItem>(mongoConnections.size());
        for (MongoConnectionNameBuildItem mongoConnection : mongoConnections) {
            String name = mongoConnection.getName();
            result.add(new MongoClientBuildItem((RuntimeValue<MongoClient>)recorder.getClient(name), (RuntimeValue<io.quarkus.mongodb.reactive.ReactiveMongoClient>)recorder.getReactiveClient(name), name));
        }
        return result;
    }

    @BuildStep
    @Weak
    MongoUnremovableClientsBuildItem unremovable(BuildProducer<MongoClientBuildItem> producer) {
        return new MongoUnremovableClientsBuildItem();
    }

    private String getMongoClientProducerClassName() {
        return AbstractMongoClientProducer.class.getPackage().getName() + ".MongoClientProducer";
    }

    @BuildStep
    HealthBuildItem addHealthCheck(MongoClientBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.mongodb.health.MongoHealthCheck", buildTimeConfig.healthEnabled, "mongodb");
    }

    @BuildStep
    void setupMetrics(MongoClientBuildTimeConfig buildTimeConfig, Capabilities capabilities, BuildProducer<MongoConnectionPoolListenerBuildItem> producer) {
        if (buildTimeConfig.metricsEnabled && capabilities.isCapabilityPresent("io.quarkus.metrics")) {
            producer.produce((BuildItem)new MongoConnectionPoolListenerBuildItem((ConnectionPoolListener)new MongoMetricsConnectionPoolListener()));
        }
    }
}

