/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.deployment;

import com.mongodb.client.MongoClient;
import com.mongodb.event.ConnectionPoolListener;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.annotations.Weak;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.mongodb.deployment.BsonDiscriminatorBuildItem;
import io.quarkus.mongodb.deployment.CodecProviderBuildItem;
import io.quarkus.mongodb.deployment.MongoClientBuildItem;
import io.quarkus.mongodb.deployment.MongoClientBuildTimeConfig;
import io.quarkus.mongodb.deployment.MongoClientNameBuildItem;
import io.quarkus.mongodb.deployment.MongoConnectionNameBuildItem;
import io.quarkus.mongodb.deployment.MongoConnectionPoolListenerBuildItem;
import io.quarkus.mongodb.deployment.MongoUnremovableClientsBuildItem;
import io.quarkus.mongodb.metrics.MongoMetricsConnectionPoolListener;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.quarkus.mongodb.runtime.MongoClientBeanUtil;
import io.quarkus.mongodb.runtime.MongoClientName;
import io.quarkus.mongodb.runtime.MongoClientRecorder;
import io.quarkus.mongodb.runtime.MongoClientSupport;
import io.quarkus.mongodb.runtime.MongoClients;
import io.quarkus.mongodb.runtime.MongodbConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.pojo.annotations.BsonDiscriminator;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class MongoClientProcessor {
    private static final DotName MONGOCLIENT_ANNOTATION = DotName.createSimple((String)MongoClientName.class.getName());

    @BuildStep
    BeanDefiningAnnotationBuildItem registerConnectionBean() {
        return new BeanDefiningAnnotationBuildItem(MONGOCLIENT_ANNOTATION);
    }

    @BuildStep
    CodecProviderBuildItem collectCodecProviders(CombinedIndexBuildItem indexBuildItem) {
        Collection codecProviderClasses = indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)CodecProvider.class.getName()));
        List<String> names = codecProviderClasses.stream().map(ci -> ci.name().toString()).collect(Collectors.toList());
        return new CodecProviderBuildItem(names);
    }

    @BuildStep
    BsonDiscriminatorBuildItem collectBsonDiscriminators(CombinedIndexBuildItem indexBuildItem) {
        ArrayList<String> names = new ArrayList<String>();
        DotName bsonDiscriminatorName = DotName.createSimple((String)BsonDiscriminator.class.getName());
        for (AnnotationInstance annotationInstance : indexBuildItem.getIndex().getAnnotations(bsonDiscriminatorName)) {
            names.add(annotationInstance.target().asClass().name().toString());
        }
        return new BsonDiscriminatorBuildItem(names);
    }

    @BuildStep
    List<ReflectiveClassBuildItem> addCodecsAndDiscriminatorsToNative(CodecProviderBuildItem codecProviders, BsonDiscriminatorBuildItem bsonDiscriminators) {
        ArrayList<String> reflectiveClassNames = new ArrayList<String>();
        reflectiveClassNames.addAll(codecProviders.getCodecProviderClassNames());
        reflectiveClassNames.addAll(bsonDiscriminators.getBsonDiscriminatorClassNames());
        return reflectiveClassNames.stream().map(s -> new ReflectiveClassBuildItem(true, true, false, new String[]{s})).collect(Collectors.toList());
    }

    @BuildStep
    public void mongoClientNames(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<MongoClientNameBuildItem> mongoClientName) {
        HashSet<String> values = new HashSet<String>();
        IndexView indexView = applicationArchivesBuildItem.getRootArchive().getIndex();
        Collection mongoClientAnnotations = indexView.getAnnotations(MONGOCLIENT_ANNOTATION);
        for (AnnotationInstance annotation : mongoClientAnnotations) {
            values.add(annotation.value().asString());
        }
        for (String value : values) {
            mongoClientName.produce((BuildItem)new MongoClientNameBuildItem(value));
        }
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.MONGODB_CLIENT);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem ssl() {
        return new ExtensionSslNativeSupportBuildItem(Feature.MONGODB_CLIENT);
    }

    @BuildStep
    MongoConnectionPoolListenerBuildItem setupMetrics(MongoClientBuildTimeConfig buildTimeConfig, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (buildTimeConfig.metricsEnabled && metricsCapability.isPresent()) {
            return new MongoConnectionPoolListenerBuildItem((ConnectionPoolListener)new MongoMetricsConnectionPoolListener());
        }
        return null;
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void build(List<MongoClientNameBuildItem> mongoClientNames, MongoClientRecorder recorder, SslNativeConfigBuildItem sslNativeConfig, CodecProviderBuildItem codecProvider, BsonDiscriminatorBuildItem bsonDiscriminator, List<MongoConnectionPoolListenerBuildItem> connectionPoolListenerProvider, BuildProducer<MongoConnectionNameBuildItem> mongoConnections, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        List poolListenerList = connectionPoolListenerProvider.stream().map(MongoConnectionPoolListenerBuildItem::getConnectionPoolListener).collect(Collectors.toList());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{MongoClients.class}).setUnremovable().build());
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MongoClientSupport.class).scope(Singleton.class)).supplier(recorder.mongoClientSupportSupplier(codecProvider.getCodecProviderClassNames(), bsonDiscriminator.getBsonDiscriminatorClassNames(), poolListenerList, sslNativeConfig.isExplicitlyDisabled())).done());
        mongoConnections.produce((BuildItem)new MongoConnectionNameBuildItem("<default>"));
        for (MongoClientNameBuildItem bi : mongoClientNames) {
            mongoConnections.produce((BuildItem)new MongoConnectionNameBuildItem(bi.getName()));
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateClientBeans(MongoClientRecorder recorder, List<MongoClientNameBuildItem> mongoClientNames, MongodbConfig mongodbConfig, List<MongoUnremovableClientsBuildItem> mongoUnremovableClientsBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        boolean makeUnremovable = !mongoUnremovableClientsBuildItem.isEmpty();
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)this.createBlockingSyntheticBean(recorder, mongodbConfig, makeUnremovable, "<default>", false));
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)this.createReactiveSyntheticBean(recorder, mongodbConfig, makeUnremovable, "<default>", false));
        for (MongoClientNameBuildItem mongoClientName : mongoClientNames) {
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)this.createBlockingSyntheticBean(recorder, mongodbConfig, makeUnremovable, mongoClientName.getName(), mongoClientName.isAddQualifier()));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)this.createReactiveSyntheticBean(recorder, mongodbConfig, makeUnremovable, mongoClientName.getName(), mongoClientName.isAddQualifier()));
        }
    }

    private SyntheticBeanBuildItem createBlockingSyntheticBean(MongoClientRecorder recorder, MongodbConfig mongodbConfig, boolean makeUnremovable, String clientName, boolean addMongoClientQualifier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MongoClient.class).scope(Singleton.class)).supplier(recorder.mongoClientSupplier(clientName, mongodbConfig)).setRuntimeInit();
        return this.applyCommonBeanConfig(makeUnremovable, clientName, addMongoClientQualifier, configurator);
    }

    private SyntheticBeanBuildItem createReactiveSyntheticBean(MongoClientRecorder recorder, MongodbConfig mongodbConfig, boolean makeUnremovable, String clientName, boolean addMongoClientQualifier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ReactiveMongoClient.class).scope(Singleton.class)).supplier(recorder.reactiveMongoClientSupplier(clientName, mongodbConfig)).setRuntimeInit();
        return this.applyCommonBeanConfig(makeUnremovable, clientName, addMongoClientQualifier, configurator);
    }

    private SyntheticBeanBuildItem applyCommonBeanConfig(boolean makeUnremovable, String clientName, boolean addMongoClientQualifier, SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator) {
        if (makeUnremovable) {
            configurator.unremovable();
        }
        if (MongoClientBeanUtil.isDefault((String)clientName)) {
            configurator.addQualifier(Default.class);
        } else {
            String namedQualifier = MongoClientBeanUtil.namedQualifier((String)clientName, (boolean)false);
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)namedQualifier).done();
            if (addMongoClientQualifier) {
                configurator.addQualifier().annotation(MONGOCLIENT_ANNOTATION).addValue("value", (Object)clientName).done();
            }
        }
        return configurator.done();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT, optional=true)
    List<MongoClientBuildItem> mongoClients(MongoClientRecorder recorder, List<MongoConnectionNameBuildItem> mongoConnections, BeanContainerBuildItem beanContainer) {
        ArrayList<MongoClientBuildItem> result = new ArrayList<MongoClientBuildItem>(mongoConnections.size());
        for (MongoConnectionNameBuildItem mongoConnection : mongoConnections) {
            String name = mongoConnection.getName();
            result.add(new MongoClientBuildItem((RuntimeValue<MongoClient>)recorder.getClient(name), (RuntimeValue<ReactiveMongoClient>)recorder.getReactiveClient(name), name));
        }
        return result;
    }

    @BuildStep
    @Weak
    MongoUnremovableClientsBuildItem unremovable(BuildProducer<MongoClientBuildItem> producer) {
        return new MongoUnremovableClientsBuildItem();
    }

    @BuildStep
    HealthBuildItem addHealthCheck(MongoClientBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.mongodb.health.MongoHealthCheck", buildTimeConfig.healthEnabled);
    }
}

