/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.deployment;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.message.BasicNameValuePair;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.net.URLEncodedUtils;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesNativeConfigResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.mongodb.deployment.DevServicesBuildTimeConfig;
import io.quarkus.mongodb.deployment.MongoClientBuildTimeConfig;
import io.quarkus.mongodb.deployment.MongoConnectionNameBuildItem;
import io.quarkus.mongodb.runtime.MongoClientBeanUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

public class DevServicesMongoProcessor {
    private static final Logger log = Logger.getLogger(DevServicesMongoProcessor.class);
    static volatile List<Closeable> closeables;
    static volatile Map<String, CapturedProperties> capturedProperties;
    static volatile boolean first;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @BuildStep(onlyIfNot={IsNormal.class})
    public void startMongo(List<MongoConnectionNameBuildItem> mongoConnections, MongoClientBuildTimeConfig mongoClientBuildTimeConfig, LaunchModeBuildItem launchMode, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration, BuildProducer<ServiceStartBuildItem> serviceStartBuildItemBuildProducer, BuildProducer<DevServicesNativeConfigResultBuildItem> devServices) {
        ArrayList<String> connectionNames = new ArrayList<String>(mongoConnections.size());
        for (MongoConnectionNameBuildItem mongoConnection : mongoConnections) {
            connectionNames.add(mongoConnection.getName());
        }
        if (connectionNames.size() != 1) {
            return;
        }
        if (!MongoClientBeanUtil.isDefault((String)((String)connectionNames.get(0)))) {
            return;
        }
        Map<String, CapturedProperties> currentCapturedProperties = this.captureProperties(connectionNames, mongoClientBuildTimeConfig);
        if (closeables != null) {
            boolean restartRequired;
            boolean bl = restartRequired = launchMode.getLaunchMode() == LaunchMode.TEST;
            if (!restartRequired) {
                boolean bl2 = restartRequired = !currentCapturedProperties.equals(capturedProperties);
            }
            if (!restartRequired) {
                return;
            }
            for (Closeable i : closeables) {
                try {
                    i.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop database", e);
                }
            }
            closeables = null;
            capturedProperties = null;
        }
        ArrayList<Closeable> currentCloseables = new ArrayList<Closeable>(mongoConnections.size());
        String connectionName = (String)connectionNames.get(0);
        StartResult startResult = this.startMongo(connectionName, currentCapturedProperties.get(connectionName));
        if (startResult != null) {
            currentCloseables.add(startResult.getCloseable());
            String connectionStringPropertyName = this.getConfigPrefix(connectionName) + "connection-string";
            String connectionStringPropertyValue = startResult.getUrl();
            runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(connectionStringPropertyName, connectionStringPropertyValue));
            devServices.produce((BuildItem)new DevServicesNativeConfigResultBuildItem(connectionStringPropertyName, connectionStringPropertyValue));
        }
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (closeables != null) {
                        for (Closeable i : closeables) {
                            try {
                                i.close();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to stop database", t);
                            }
                        }
                    }
                    first = true;
                    closeables = null;
                    capturedProperties = null;
                }
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
        }
        closeables = currentCloseables;
        capturedProperties = currentCapturedProperties;
    }

    private StartResult startMongo(String connectionName, CapturedProperties capturedProperties) {
        boolean needToStart;
        if (!capturedProperties.devServicesEnabled) {
            log.debug((Object)("Not starting devservices for " + (MongoClientBeanUtil.isDefault((String)connectionName) ? "default datasource" : connectionName) + " as it has been disabled in the config"));
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            log.warn((Object)("Please configure datasource URL for " + (MongoClientBeanUtil.isDefault((String)connectionName) ? "default datasource" : connectionName) + " or get a working docker instance"));
            return null;
        }
        String configPrefix = this.getConfigPrefix(connectionName);
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)(configPrefix + "connection-string"));
        if (!needToStart) {
            log.debug((Object)("Not starting devservices for " + (MongoClientBeanUtil.isDefault((String)connectionName) ? "default datasource" : connectionName) + " as a connection string has been provided"));
            return null;
        }
        final FixedExposedPortMongoDBContainer mongoDBContainer = capturedProperties.imageName != null ? new FixedExposedPortMongoDBContainer(DockerImageName.parse((String)capturedProperties.imageName).asCompatibleSubstituteFor("mongo"), capturedProperties.fixedExposedPort) : new FixedExposedPortMongoDBContainer(capturedProperties.fixedExposedPort);
        mongoDBContainer.start();
        Optional databaseName = ConfigProvider.getConfig().getOptionalValue(configPrefix + "database", String.class);
        Object effectiveURL = databaseName.map(arg_0 -> ((MongoDBContainer)mongoDBContainer).getReplicaSetUrl(arg_0)).orElse(mongoDBContainer.getReplicaSetUrl());
        if (capturedProperties.connectionProperties != null && !capturedProperties.connectionProperties.isEmpty()) {
            effectiveURL = (String)effectiveURL + "?" + URLEncodedUtils.format((Iterable)capturedProperties.connectionProperties.entrySet().stream().map(e -> new BasicNameValuePair((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()), (Charset)StandardCharsets.UTF_8);
        }
        return new StartResult((String)effectiveURL, new Closeable(){

            @Override
            public void close() {
                mongoDBContainer.close();
            }
        });
    }

    private String getConfigPrefix(String connectionName) {
        Object configPrefix = "quarkus.mongodb.";
        if (!MongoClientBeanUtil.isDefault((String)connectionName)) {
            configPrefix = (String)configPrefix + connectionName + ".";
        }
        return configPrefix;
    }

    private Map<String, CapturedProperties> captureProperties(List<String> connectionNames, MongoClientBuildTimeConfig mongoClientBuildTimeConfig) {
        HashMap<String, CapturedProperties> result = new HashMap<String, CapturedProperties>();
        for (String connectionName : connectionNames) {
            result.put(connectionName, this.captureProperties(connectionName, mongoClientBuildTimeConfig));
        }
        return result;
    }

    private CapturedProperties captureProperties(String connectionName, MongoClientBuildTimeConfig mongoClientBuildTimeConfig) {
        String configPrefix = this.getConfigPrefix(connectionName);
        String databaseName = ConfigProvider.getConfig().getOptionalValue(configPrefix + "database", String.class).orElse(null);
        String connectionString = ConfigProvider.getConfig().getOptionalValue(configPrefix + "connection-string", String.class).orElse(null);
        DevServicesBuildTimeConfig devServicesConfig = mongoClientBuildTimeConfig.devservices;
        boolean devServicesEnabled = devServicesConfig.enabled.orElse(true);
        return new CapturedProperties(databaseName, connectionString, devServicesEnabled, devServicesConfig.imageName.orElse(null), devServicesConfig.port.orElse(null), devServicesConfig.properties);
    }

    static {
        first = true;
    }

    private static final class FixedExposedPortMongoDBContainer
    extends MongoDBContainer {
        private final Integer fixedExposedPort;

        private FixedExposedPortMongoDBContainer(Integer fixedExposedPort) {
            this.fixedExposedPort = fixedExposedPort;
        }

        private FixedExposedPortMongoDBContainer(DockerImageName dockerImageName, Integer fixedExposedPort) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
        }

        protected void configure() {
            super.configure();
            if (this.fixedExposedPort != null) {
                this.addFixedExposedPort(this.fixedExposedPort, 27017);
            }
        }
    }

    private static final class CapturedProperties {
        private final String database;
        private final String connectionString;
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final Map<String, String> connectionProperties;

        public CapturedProperties(String database, String connectionString, boolean devServicesEnabled, String imageName, Integer fixedExposedPort, Map<String, String> connectionProperties) {
            this.database = database;
            this.connectionString = connectionString;
            this.devServicesEnabled = devServicesEnabled;
            this.imageName = imageName;
            this.fixedExposedPort = fixedExposedPort;
            this.connectionProperties = connectionProperties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapturedProperties that = (CapturedProperties)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.database, that.database) && Objects.equals(this.connectionString, that.connectionString) && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort) && Objects.equals(this.connectionProperties, that.connectionProperties);
        }

        public int hashCode() {
            return Objects.hash(this.database, this.connectionString, this.devServicesEnabled, this.imageName, this.fixedExposedPort, this.connectionProperties);
        }
    }

    private static class StartResult {
        private final String url;
        private final Closeable closeable;

        public StartResult(String url, Closeable closeable) {
            this.url = url;
            this.closeable = closeable;
        }

        public String getUrl() {
            return this.url;
        }

        public Closeable getCloseable() {
            return this.closeable;
        }
    }
}

