/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.deployment;

import com.mongodb.client.MongoClient;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.annotations.Weak;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.AllowJNDIBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.mongodb.MongoClientName;
import io.quarkus.mongodb.deployment.BsonDiscriminatorBuildItem;
import io.quarkus.mongodb.deployment.CodecProviderBuildItem;
import io.quarkus.mongodb.deployment.CommandListenerBuildItem;
import io.quarkus.mongodb.deployment.MongoClientBuildItem;
import io.quarkus.mongodb.deployment.MongoClientBuildTimeConfig;
import io.quarkus.mongodb.deployment.MongoClientNameBuildItem;
import io.quarkus.mongodb.deployment.MongoConnectionNameBuildItem;
import io.quarkus.mongodb.deployment.MongoConnectionPoolListenerBuildItem;
import io.quarkus.mongodb.deployment.MongoUnremovableClientsBuildItem;
import io.quarkus.mongodb.deployment.PropertyCodecProviderBuildItem;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.quarkus.mongodb.runtime.MongoClientBeanUtil;
import io.quarkus.mongodb.runtime.MongoClientRecorder;
import io.quarkus.mongodb.runtime.MongoClientSupport;
import io.quarkus.mongodb.runtime.MongoClients;
import io.quarkus.mongodb.runtime.MongoServiceBindingConverter;
import io.quarkus.mongodb.runtime.MongodbConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.bson.codecs.pojo.annotations.BsonDiscriminator;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class MongoClientProcessor {
    private static final String MONGODB_TRACING_COMMANDLISTENER_CLASSNAME = "io.quarkus.mongodb.tracing.MongoTracingCommandListener";
    private static final DotName MONGO_CLIENT_ANNOTATION = DotName.createSimple((String)MongoClientName.class.getName());
    private static final DotName MONGO_CLIENT = DotName.createSimple((String)MongoClient.class.getName());
    private static final DotName REACTIVE_MONGO_CLIENT = DotName.createSimple((String)ReactiveMongoClient.class.getName());
    private static final String SERVICE_BINDING_INTERFACE_NAME = "io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter";

    @BuildStep
    AllowJNDIBuildItem enableJndi() {
        return new AllowJNDIBuildItem();
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem includeBsonTypesToIndex() {
        return new AdditionalIndexedClassesBuildItem(new String[]{"org.bson.types.BasicBSONList", "org.bson.types.Binary", "org.bson.types.BSONTimestamp", "org.bson.types.Code", "org.bson.types.CodeWithScope", "org.bson.types.CodeWScope", "org.bson.types.Decimal128", "org.bson.types.MaxKey", "org.bson.types.MinKey", "org.bson.types.ObjectId", "org.bson.types.StringRangeSet", "org.bson.types.Symbol"});
    }

    @BuildStep
    CodecProviderBuildItem collectCodecProviders(CombinedIndexBuildItem indexBuildItem) {
        Collection codecProviderClasses = indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)CodecProvider.class.getName()));
        List<String> names = codecProviderClasses.stream().map(ci -> ci.name().toString()).collect(Collectors.toList());
        return new CodecProviderBuildItem(names);
    }

    @BuildStep
    PropertyCodecProviderBuildItem collectPropertyCodecProviders(CombinedIndexBuildItem indexBuildItem) {
        Collection propertyCodecProviderClasses = indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)PropertyCodecProvider.class.getName()));
        List<String> names = propertyCodecProviderClasses.stream().map(ci -> ci.name().toString()).collect(Collectors.toList());
        return new PropertyCodecProviderBuildItem(names);
    }

    @BuildStep
    BsonDiscriminatorBuildItem collectBsonDiscriminators(CombinedIndexBuildItem indexBuildItem) {
        ArrayList<String> names = new ArrayList<String>();
        DotName bsonDiscriminatorName = DotName.createSimple((String)BsonDiscriminator.class.getName());
        for (AnnotationInstance annotationInstance : indexBuildItem.getIndex().getAnnotations(bsonDiscriminatorName)) {
            names.add(annotationInstance.target().asClass().name().toString());
        }
        return new BsonDiscriminatorBuildItem(names);
    }

    @BuildStep
    CommandListenerBuildItem collectCommandListeners(CombinedIndexBuildItem indexBuildItem, MongoClientBuildTimeConfig buildTimeConfig, Capabilities capabilities) {
        Collection commandListenerClasses = indexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)CommandListener.class.getName()));
        List<String> names = commandListenerClasses.stream().map(ci -> ci.name().toString()).collect(Collectors.toList());
        if (buildTimeConfig.tracingEnabled && capabilities.isPresent("io.quarkus.opentracing")) {
            names.add(MONGODB_TRACING_COMMANDLISTENER_CLASSNAME);
        }
        return new CommandListenerBuildItem(names);
    }

    @BuildStep
    List<ReflectiveClassBuildItem> addExtensionPointsToNative(CodecProviderBuildItem codecProviders, PropertyCodecProviderBuildItem propertyCodecProviders, BsonDiscriminatorBuildItem bsonDiscriminators, CommandListenerBuildItem commandListeners) {
        ArrayList<String> reflectiveClassNames = new ArrayList<String>();
        reflectiveClassNames.addAll(codecProviders.getCodecProviderClassNames());
        reflectiveClassNames.addAll(propertyCodecProviders.getPropertyCodecProviderClassNames());
        reflectiveClassNames.addAll(bsonDiscriminators.getBsonDiscriminatorClassNames());
        reflectiveClassNames.addAll(commandListeners.getCommandListenerClassNames());
        List reflectiveClass = reflectiveClassNames.stream().map(s -> new ReflectiveClassBuildItem(true, true, false, new String[]{s})).collect(Collectors.toCollection(ArrayList::new));
        reflectiveClass.add(new ReflectiveClassBuildItem(true, true, true, new String[]{ChangeStreamDocument.class.getName()}));
        return reflectiveClass;
    }

    @BuildStep
    public void mongoClientNames(CombinedIndexBuildItem indexBuildItem, BuildProducer<MongoClientNameBuildItem> mongoClientName) {
        HashSet<String> values = new HashSet<String>();
        IndexView indexView = indexBuildItem.getIndex();
        this.addMongoClientNameValues(MONGO_CLIENT_ANNOTATION, indexView, values);
        for (String value : values) {
            mongoClientName.produce((BuildItem)new MongoClientNameBuildItem(value));
        }
    }

    private void addMongoClientNameValues(DotName annotationName, IndexView indexView, Set<String> values) {
        Collection mongoClientAnnotations = indexView.getAnnotations(annotationName);
        for (AnnotationInstance annotation : mongoClientAnnotations) {
            values.add(annotation.value().asString());
        }
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.MONGODB_CLIENT);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem ssl() {
        return new ExtensionSslNativeSupportBuildItem(Feature.MONGODB_CLIENT);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    MongoConnectionPoolListenerBuildItem setupMetrics(MongoClientBuildTimeConfig buildTimeConfig, MongoClientRecorder recorder, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (buildTimeConfig.metricsEnabled && metricsCapability.isPresent()) {
            if (metricsCapability.get().metricsSupported("micrometer")) {
                return new MongoConnectionPoolListenerBuildItem(recorder.createMicrometerConnectionPoolListener());
            }
            return new MongoConnectionPoolListenerBuildItem(recorder.createMPMetricsConnectionPoolListener());
        }
        return null;
    }

    @BuildStep
    void additionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(MongoClientName.class).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{MongoClients.class}).setUnremovable().build());
    }

    @BuildStep
    void connectionNames(List<MongoClientNameBuildItem> mongoClientNames, BuildProducer<MongoConnectionNameBuildItem> mongoConnections) {
        mongoConnections.produce((BuildItem)new MongoConnectionNameBuildItem("<default>"));
        for (MongoClientNameBuildItem bi : mongoClientNames) {
            mongoConnections.produce((BuildItem)new MongoConnectionNameBuildItem(bi.getName()));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void build(MongoClientRecorder recorder, SslNativeConfigBuildItem sslNativeConfig, CodecProviderBuildItem codecProvider, PropertyCodecProviderBuildItem propertyCodecProvider, BsonDiscriminatorBuildItem bsonDiscriminator, CommandListenerBuildItem commandListener, List<MongoConnectionPoolListenerBuildItem> connectionPoolListenerProvider, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemProducer, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        ArrayList<Supplier<ConnectionPoolListener>> poolListenerList = new ArrayList<Supplier<ConnectionPoolListener>>(connectionPoolListenerProvider.size());
        for (MongoConnectionPoolListenerBuildItem item : connectionPoolListenerProvider) {
            poolListenerList.add(item.getConnectionPoolListener());
        }
        List<String> codecProviderClassNames = codecProvider.getCodecProviderClassNames();
        AdditionalBeanBuildItem.Builder additionalBeansBuilder = AdditionalBeanBuildItem.builder();
        additionalBeansBuilder.setDefaultScope(DotNames.SINGLETON);
        for (String name : codecProviderClassNames) {
            additionalBeansBuilder.addBeanClass(name);
        }
        for (String name : propertyCodecProvider.getPropertyCodecProviderClassNames()) {
            additionalBeansBuilder.addBeanClass(name);
        }
        for (String name : commandListener.getCommandListenerClassNames()) {
            additionalBeansBuilder.addBeanClass(name);
        }
        additionalBeanBuildItemProducer.produce((BuildItem)additionalBeansBuilder.build());
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MongoClientSupport.class).scope(Singleton.class)).supplier(recorder.mongoClientSupportSupplier(bsonDiscriminator.getBsonDiscriminatorClassNames(), poolListenerList, sslNativeConfig.isExplicitlyDisabled())).done());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateClientBeans(MongoClientRecorder recorder, BeanRegistrationPhaseBuildItem registrationPhase, List<MongoClientNameBuildItem> mongoClientNames, MongoClientBuildTimeConfig mongoClientBuildTimeConfig, MongodbConfig mongodbConfig, List<MongoUnremovableClientsBuildItem> mongoUnremovableClientsBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        boolean makeUnremovable = !mongoUnremovableClientsBuildItem.isEmpty();
        boolean createDefaultBlockingMongoClient = false;
        boolean createDefaultReactiveMongoClient = false;
        if (makeUnremovable || mongoClientBuildTimeConfig.forceDefaultClients) {
            createDefaultBlockingMongoClient = true;
            createDefaultReactiveMongoClient = true;
        } else {
            for (InjectionPointInfo injectionPoint : (Collection)registrationPhase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
                DotName injectionPointType = injectionPoint.getRequiredType().name();
                if (injectionPointType.equals((Object)MONGO_CLIENT) && injectionPoint.hasDefaultedQualifier()) {
                    createDefaultBlockingMongoClient = true;
                } else if (injectionPointType.equals((Object)REACTIVE_MONGO_CLIENT) && injectionPoint.hasDefaultedQualifier()) {
                    createDefaultReactiveMongoClient = true;
                }
                if (!createDefaultBlockingMongoClient || !createDefaultReactiveMongoClient) continue;
                break;
            }
        }
        if (createDefaultBlockingMongoClient) {
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)this.createBlockingSyntheticBean(recorder, mongodbConfig, makeUnremovable || mongoClientBuildTimeConfig.forceDefaultClients, "<default>", false));
        }
        if (createDefaultReactiveMongoClient) {
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)this.createReactiveSyntheticBean(recorder, mongodbConfig, makeUnremovable || mongoClientBuildTimeConfig.forceDefaultClients, "<default>", false));
        }
        for (MongoClientNameBuildItem mongoClientName : mongoClientNames) {
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)this.createBlockingSyntheticBean(recorder, mongodbConfig, makeUnremovable, mongoClientName.getName(), mongoClientName.isAddQualifier()));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)this.createReactiveSyntheticBean(recorder, mongodbConfig, makeUnremovable, mongoClientName.getName(), mongoClientName.isAddQualifier()));
        }
    }

    private SyntheticBeanBuildItem createBlockingSyntheticBean(MongoClientRecorder recorder, MongodbConfig mongodbConfig, boolean makeUnremovable, String clientName, boolean addMongoClientQualifier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MongoClient.class).scope(ApplicationScoped.class)).supplier(recorder.mongoClientSupplier(clientName, mongodbConfig)).setRuntimeInit();
        return this.applyCommonBeanConfig(makeUnremovable, clientName, addMongoClientQualifier, configurator, false);
    }

    private SyntheticBeanBuildItem createReactiveSyntheticBean(MongoClientRecorder recorder, MongodbConfig mongodbConfig, boolean makeUnremovable, String clientName, boolean addMongoClientQualifier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ReactiveMongoClient.class).scope(ApplicationScoped.class)).supplier(recorder.reactiveMongoClientSupplier(clientName, mongodbConfig)).setRuntimeInit();
        return this.applyCommonBeanConfig(makeUnremovable, clientName, addMongoClientQualifier, configurator, true);
    }

    private SyntheticBeanBuildItem applyCommonBeanConfig(boolean makeUnremovable, String clientName, boolean addMongoClientQualifier, SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator, boolean isReactive) {
        if (makeUnremovable) {
            configurator.unremovable();
        }
        if (MongoClientBeanUtil.isDefault((String)clientName)) {
            configurator.addQualifier(Default.class);
        } else {
            String namedQualifier = MongoClientBeanUtil.namedQualifier((String)clientName, (boolean)isReactive);
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)namedQualifier).done();
            if (addMongoClientQualifier) {
                configurator.addQualifier().annotation(MONGO_CLIENT_ANNOTATION).addValue("value", (Object)clientName).done();
            }
        }
        return configurator.done();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT, optional=true)
    List<MongoClientBuildItem> mongoClients(MongoClientRecorder recorder, List<MongoConnectionNameBuildItem> mongoConnections, BeanContainerBuildItem beanContainer) {
        ArrayList<MongoClientBuildItem> result = new ArrayList<MongoClientBuildItem>(mongoConnections.size());
        for (MongoConnectionNameBuildItem mongoConnection : mongoConnections) {
            String name = mongoConnection.getName();
            result.add(new MongoClientBuildItem((RuntimeValue<MongoClient>)recorder.getClient(name), (RuntimeValue<ReactiveMongoClient>)recorder.getReactiveClient(name), name));
        }
        return result;
    }

    @BuildStep
    @Weak
    MongoUnremovableClientsBuildItem unremovable(BuildProducer<MongoClientBuildItem> producer) {
        return new MongoUnremovableClientsBuildItem();
    }

    @BuildStep
    HealthBuildItem addHealthCheck(MongoClientBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkus.mongodb.health.MongoHealthCheck", buildTimeConfig.healthEnabled);
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> buildProducer) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            buildProducer.produce((BuildItem)new ServiceProviderBuildItem(SERVICE_BINDING_INTERFACE_NAME, new String[]{MongoServiceBindingConverter.class.getName()}));
        }
    }
}

