/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.reactivestreams.client.MongoClients;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.mongodb.ReactiveMongoClient;
import io.quarkus.mongodb.impl.ReactiveMongoClientImpl;
import io.quarkus.mongodb.runtime.MongoClientConfig;
import io.quarkus.mongodb.runtime.MongoClientProducer;
import io.quarkus.mongodb.runtime.WriteConcernConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.Conventions;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.jboss.logging.Logger;

@Recorder
public class MongoClientRecorder {
    private static final Logger LOGGER = Logger.getLogger(MongoClientRecorder.class);
    private static final Pattern COLON_PATTERN = Pattern.compile(":");
    private static volatile MongoClient client;
    private static volatile ReactiveMongoClient reactiveMongoClient;

    public RuntimeValue<MongoClient> configureTheClient(MongoClientConfig config, BeanContainer container, LaunchMode launchMode, ShutdownContext shutdown, List<String> codecProviders) {
        this.initialize(config, codecProviders);
        MongoClientProducer producer = (MongoClientProducer)container.instance(MongoClientProducer.class, new Annotation[0]);
        producer.initialize(client, reactiveMongoClient);
        if (!launchMode.isDevOrTest()) {
            shutdown.addShutdownTask(this::close);
        }
        return new RuntimeValue((Object)client);
    }

    public RuntimeValue<ReactiveMongoClient> configureTheReactiveClient() {
        return new RuntimeValue((Object)reactiveMongoClient);
    }

    private void close() {
        if (client != null) {
            client.close();
        }
        if (reactiveMongoClient != null) {
            reactiveMongoClient.close();
        }
    }

    void initialize(MongoClientConfig config, List<String> codecProviders) {
        MongoCredential credential;
        CodecRegistry defaultCodecRegistry = com.mongodb.MongoClient.getDefaultCodecRegistry();
        MongoClientSettings.Builder settings = MongoClientSettings.builder();
        Optional<String> maybeConnectionString = config.connectionString;
        if (maybeConnectionString.isPresent()) {
            ConnectionString connectionString = new ConnectionString(maybeConnectionString.get());
            settings.applyConnectionString(connectionString);
        }
        ArrayList<Object> providers = new ArrayList<Object>();
        if (!codecProviders.isEmpty()) {
            providers.addAll(this.getCodecProviders(codecProviders));
        }
        PojoCodecProvider pojoCodecProvider = PojoCodecProvider.builder().automatic(true).conventions(Conventions.DEFAULT_CONVENTIONS).build();
        providers.add(pojoCodecProvider);
        CodecRegistry registry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{defaultCodecRegistry, CodecRegistries.fromProviders(providers)});
        settings.codecRegistry(registry);
        config.applicationName.ifPresent(arg_0 -> ((MongoClientSettings.Builder)settings).applicationName(arg_0));
        if (config.credentials != null && (credential = this.createMongoCredential(config)) != null) {
            settings.credential(credential);
        }
        if (config.writeConcern != null) {
            Optional<String> maybeW;
            WriteConcernConfig wc = config.writeConcern;
            WriteConcern concern = (wc.safe ? WriteConcern.ACKNOWLEDGED : WriteConcern.UNACKNOWLEDGED).withJournal(Boolean.valueOf(wc.journal));
            if (wc.wTimeout.isPresent()) {
                concern = concern.withWTimeout(wc.wTimeout.get().toMillis(), TimeUnit.MILLISECONDS);
            }
            if ((maybeW = wc.w).isPresent()) {
                concern = concern.withW(maybeW.get());
            }
            settings.writeConcern(concern);
            settings.retryWrites(wc.retryWrites);
        }
        if (config.tls) {
            settings.applyToSslSettings(builder -> builder.enabled(true).invalidHostNameAllowed(config.tlsInsecure));
        }
        settings.applyToClusterSettings(builder -> {
            if (!maybeConnectionString.isPresent()) {
                List<ServerAddress> hosts = MongoClientRecorder.parseHosts(config.hosts);
                builder.hosts(hosts);
                if (hosts.size() == 1 && !config.replicaSetName.isPresent()) {
                    builder.mode(ClusterConnectionMode.SINGLE);
                } else {
                    builder.mode(ClusterConnectionMode.MULTIPLE);
                }
            }
            config.localThreshold.ifPresent(i -> builder.localThreshold(i.toMillis(), TimeUnit.MILLISECONDS));
            config.maxWaitQueueSize.ifPresent(arg_0 -> ((ClusterSettings.Builder)builder).maxWaitQueueSize(arg_0));
            config.replicaSetName.ifPresent(arg_0 -> ((ClusterSettings.Builder)builder).requiredReplicaSetName(arg_0));
            config.serverSelectionTimeout.ifPresent(i -> builder.serverSelectionTimeout(i.toMillis(), TimeUnit.MILLISECONDS));
        });
        settings.applyToConnectionPoolSettings(builder -> {
            config.maxPoolSize.ifPresent(arg_0 -> ((ConnectionPoolSettings.Builder)builder).maxSize(arg_0));
            config.minPoolSize.ifPresent(arg_0 -> ((ConnectionPoolSettings.Builder)builder).minSize(arg_0));
            config.maxWaitQueueSize.ifPresent(arg_0 -> ((ConnectionPoolSettings.Builder)builder).maxWaitQueueSize(arg_0));
            config.maxConnectionIdleTime.ifPresent(i -> builder.maxConnectionIdleTime(i.toMillis(), TimeUnit.MILLISECONDS));
            config.maxConnectionLifeTime.ifPresent(i -> builder.maxConnectionLifeTime(i.toMillis(), TimeUnit.MILLISECONDS));
            config.maintenanceFrequency.ifPresent(i -> builder.maintenanceFrequency(i.toMillis(), TimeUnit.MILLISECONDS));
            config.maintenanceInitialDelay.ifPresent(i -> builder.maintenanceInitialDelay(i.toMillis(), TimeUnit.MILLISECONDS));
        });
        settings.applyToServerSettings(builder -> config.heartbeatFrequency.ifPresent(i -> builder.heartbeatFrequency(i.toMillis(), TimeUnit.MILLISECONDS)));
        settings.applyToSocketSettings(builder -> config.connectTimeout.ifPresent(i -> builder.connectTimeout((int)i.toMillis(), TimeUnit.MILLISECONDS)));
        config.readPreference.ifPresent(pref -> settings.readPreference(ReadPreference.valueOf((String)pref)));
        MongoClientSettings mongoConfiguration = settings.build();
        client = com.mongodb.client.MongoClients.create((MongoClientSettings)mongoConfiguration);
        reactiveMongoClient = new ReactiveMongoClientImpl(MongoClients.create((MongoClientSettings)mongoConfiguration));
    }

    List<CodecProvider> getCodecProviders(List<String> classNames) {
        ArrayList<CodecProvider> providers = new ArrayList<CodecProvider>();
        for (String name : classNames) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(name);
                providers.add((CodecProvider)clazz.newInstance());
            }
            catch (Exception e) {
                LOGGER.warnf((Throwable)e, "Unable to load the codec provider class %s", (Object)name);
            }
        }
        return providers;
    }

    private AuthenticationMechanism getAuthenticationMechanism(String authMechanism) {
        AuthenticationMechanism mechanism;
        try {
            mechanism = AuthenticationMechanism.fromMechanismName((String)authMechanism.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid authMechanism '" + authMechanism + "'");
        }
        return mechanism;
    }

    private MongoCredential createMongoCredential(MongoClientConfig config) {
        MongoCredential credential;
        String username = config.credentials.username.orElse(null);
        if (username == null) {
            return null;
        }
        char[] password = config.credentials.password.map(String::toCharArray).orElse(null);
        String authSource = config.credentials.authSource.orElse(config.database.orElse("admin"));
        AuthenticationMechanism mechanism = null;
        Optional<String> maybeMechanism = config.credentials.authMechanism;
        if (maybeMechanism.isPresent()) {
            mechanism = this.getAuthenticationMechanism(maybeMechanism.get());
        }
        if (mechanism == AuthenticationMechanism.GSSAPI) {
            credential = MongoCredential.createGSSAPICredential((String)username);
        } else if (mechanism == AuthenticationMechanism.PLAIN) {
            credential = MongoCredential.createPlainCredential((String)username, (String)authSource, (char[])password);
        } else if (mechanism == AuthenticationMechanism.MONGODB_X509) {
            credential = MongoCredential.createMongoX509Credential((String)username);
        } else if (mechanism == AuthenticationMechanism.SCRAM_SHA_1) {
            credential = MongoCredential.createScramSha1Credential((String)username, (String)authSource, (char[])password);
        } else if (mechanism == null) {
            credential = MongoCredential.createCredential((String)username, (String)authSource, (char[])password);
        } else {
            throw new IllegalArgumentException("Unsupported authentication mechanism " + mechanism);
        }
        if (!config.credentials.authMechanismProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : config.credentials.authMechanismProperties.entrySet()) {
                credential = credential.withMechanismProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
        return credential;
    }

    private static List<ServerAddress> parseHosts(List<String> addresses) {
        if (addresses.isEmpty()) {
            return Collections.singletonList(new ServerAddress(ServerAddress.defaultHost(), ServerAddress.defaultPort()));
        }
        return addresses.stream().map(String::trim).map(address -> {
            String[] segments = COLON_PATTERN.split((CharSequence)address);
            if (segments.length == 1) {
                return new ServerAddress(address);
            }
            if (segments.length == 2) {
                return new ServerAddress(segments[0], Integer.parseInt(segments[1]));
            }
            throw new IllegalArgumentException("Invalid server address " + address);
        }).collect(Collectors.toList());
    }
}

