/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.health;

import com.mongodb.client.MongoClient;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.mongodb.MongoClientName;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class MongoHealthCheck
implements HealthCheck {
    public static final String CLIENT_DEFAULT = "<default>";
    public static final String CLIENT_DEFAULT_REACTIVE = "<default-reactive>";
    private Map<String, MongoClient> clients = new HashMap<String, MongoClient>();
    private Map<String, ReactiveMongoClient> reactiveClients = new HashMap<String, ReactiveMongoClient>();

    @PostConstruct
    protected void init() {
        String clientName;
        for (InstanceHandle handle : Arc.container().select(MongoClient.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            clientName = this.getMongoClientName((Bean)handle.getBean());
            this.clients.put(clientName == null ? CLIENT_DEFAULT : clientName, (MongoClient)handle.get());
        }
        for (InstanceHandle handle : Arc.container().select(ReactiveMongoClient.class, new Annotation[]{Any.Literal.INSTANCE}).handles()) {
            clientName = this.getMongoClientName((Bean)handle.getBean());
            this.reactiveClients.put(clientName == null ? CLIENT_DEFAULT_REACTIVE : clientName, (ReactiveMongoClient)handle.get());
        }
    }

    private String getMongoClientName(Bean bean) {
        for (Object qualifier : bean.getQualifiers()) {
            if (!(qualifier instanceof MongoClientName)) continue;
            return ((MongoClientName)qualifier).value();
        }
        return null;
    }

    public HealthCheckResponse call() {
        Document document;
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"MongoDB connection health check").up();
        Document command = new Document("ping", (Object)1);
        for (Map.Entry<String, MongoClient> entry : this.clients.entrySet()) {
            try {
                document = entry.getValue().getDatabase("admin").runCommand((Bson)command);
                builder.up().withData(entry.getKey(), document.toJson());
            }
            catch (Exception e) {
                return builder.down().withData("reason", "client [" + entry.getKey() + "]: " + e.getMessage()).build();
            }
        }
        for (Map.Entry<String, Object> entry : this.reactiveClients.entrySet()) {
            try {
                document = (Document)((ReactiveMongoClient)entry.getValue()).getDatabase("admin").runCommand((Bson)command).await().indefinitely();
                builder.up().withData(entry.getKey(), document.toJson());
            }
            catch (Exception e) {
                return builder.down().withData("reason", "reactive client [" + entry.getKey() + "]: " + e.getMessage()).build();
            }
        }
        return builder.build();
    }
}

