/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.health;

import com.mongodb.client.MongoClient;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class MongoHealthCheck
implements HealthCheck {
    @Inject
    MongoClient mongoClient;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"MongoDB connection health check").up();
        try {
            StringBuilder databases = new StringBuilder();
            for (String db : this.mongoClient.listDatabaseNames()) {
                if (databases.length() != 0) {
                    databases.append(", ");
                }
                databases.append(db);
            }
            return builder.withData("databases", databases.toString()).build();
        }
        catch (Exception e) {
            return builder.down().withData("reason", e.getMessage()).build();
        }
    }
}

