/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.impl;

import com.mongodb.ClientSessionOptions;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import io.quarkus.mongodb.ChangeStreamOptions;
import io.quarkus.mongodb.DatabaseListOptions;
import io.quarkus.mongodb.ReactiveMongoClient;
import io.quarkus.mongodb.ReactiveMongoDatabase;
import io.quarkus.mongodb.impl.AxleReactiveMongoDatabaseImpl;
import io.quarkus.mongodb.impl.Wrappers;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.reactivestreams.Publisher;

public class AxleReactiveMongoClientImpl
implements ReactiveMongoClient {
    private final MongoClient client;

    public AxleReactiveMongoClientImpl(MongoClient client) {
        this.client = client;
    }

    public AxleReactiveMongoClientImpl(io.quarkus.mongodb.reactive.ReactiveMongoClient client) {
        this(client.unwrap());
    }

    @Override
    public ReactiveMongoDatabase getDatabase(String name) {
        return new AxleReactiveMongoDatabaseImpl(this.client.getDatabase(name));
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public PublisherBuilder<String> listDatabaseNames() {
        return Wrappers.toPublisherBuilder(this.client.listDatabaseNames());
    }

    @Override
    public Publisher<String> listDatabaseNamesAsPublisher() {
        return this.client.listDatabaseNames();
    }

    @Override
    public PublisherBuilder<String> listDatabaseNames(ClientSession clientSession) {
        return Wrappers.toPublisherBuilder(this.client.listDatabaseNames(clientSession));
    }

    @Override
    public Publisher<String> listDatabaseNamesAsPublisher(ClientSession clientSession) {
        return this.client.listDatabaseNames(clientSession);
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabasesAsPublisher() {
        return this.client.listDatabases();
    }

    @Override
    public PublisherBuilder<Document> listDatabases() {
        return Wrappers.toPublisherBuilder(this.client.listDatabases());
    }

    @Override
    public PublisherBuilder<Document> listDatabases(DatabaseListOptions options) {
        if (options != null) {
            ListDatabasesPublisher publisher = this.apply(options, this.client.listDatabases());
            return Wrappers.toPublisherBuilder(publisher);
        }
        return this.listDatabases();
    }

    private <T> ListDatabasesPublisher<T> apply(DatabaseListOptions options, ListDatabasesPublisher<T> publisher) {
        if (options == null) {
            return publisher;
        }
        return options.apply(publisher);
    }

    private <T> ChangeStreamPublisher<T> apply(ChangeStreamOptions options, ChangeStreamPublisher<T> publisher) {
        if (options == null) {
            return publisher;
        }
        return options.apply(publisher);
    }

    @Override
    public <T> ListDatabasesPublisher<T> listDatabasesAsPublisher(Class<T> clazz) {
        return this.client.listDatabases(clazz);
    }

    @Override
    public <T> PublisherBuilder<T> listDatabases(Class<T> clazz) {
        return Wrappers.toPublisherBuilder(this.client.listDatabases(clazz));
    }

    @Override
    public <T> PublisherBuilder<T> listDatabases(Class<T> clazz, DatabaseListOptions options) {
        if (options != null) {
            ListDatabasesPublisher<T> publisher = this.apply(options, this.client.listDatabases(clazz));
            return Wrappers.toPublisherBuilder(publisher);
        }
        return this.listDatabases(clazz);
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabasesAsPublisher(ClientSession clientSession) {
        return this.client.listDatabases(clientSession);
    }

    @Override
    public PublisherBuilder<Document> listDatabases(ClientSession clientSession) {
        return Wrappers.toPublisherBuilder(this.client.listDatabases(clientSession));
    }

    @Override
    public PublisherBuilder<Document> listDatabases(ClientSession clientSession, DatabaseListOptions options) {
        ListDatabasesPublisher publisher = this.apply(options, this.client.listDatabases(clientSession));
        return Wrappers.toPublisherBuilder(publisher);
    }

    @Override
    public <T> ListDatabasesPublisher<T> listDatabasesAsPublisher(ClientSession clientSession, Class<T> clazz) {
        return this.client.listDatabases(clientSession, clazz);
    }

    @Override
    public <T> PublisherBuilder<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        return Wrappers.toPublisherBuilder(this.client.listDatabases(clientSession, clazz));
    }

    @Override
    public <T> PublisherBuilder<T> listDatabases(ClientSession clientSession, Class<T> clazz, DatabaseListOptions options) {
        return Wrappers.toPublisherBuilder(this.apply(options, this.client.listDatabases(clientSession, clazz)));
    }

    @Override
    public ChangeStreamPublisher<Document> watchAsPublisher() {
        return this.client.watch();
    }

    @Override
    public PublisherBuilder<ChangeStreamDocument<Document>> watch() {
        return Wrappers.toPublisherBuilder(this.client.watch());
    }

    @Override
    public PublisherBuilder<ChangeStreamDocument<Document>> watch(ChangeStreamOptions options) {
        ChangeStreamPublisher publisher = this.apply(options, this.client.watch());
        return Wrappers.toPublisherBuilder(publisher);
    }

    @Override
    public <T> ChangeStreamPublisher<T> watchAsPublisher(Class<T> clazz) {
        return this.client.watch(clazz);
    }

    @Override
    public <T> PublisherBuilder<ChangeStreamDocument<T>> watch(Class<T> clazz) {
        return Wrappers.toPublisherBuilder(this.client.watch(clazz));
    }

    @Override
    public <T> PublisherBuilder<ChangeStreamDocument<T>> watch(Class<T> clazz, ChangeStreamOptions options) {
        ChangeStreamPublisher<T> publisher = this.apply(options, this.client.watch(clazz));
        return Wrappers.toPublisherBuilder(publisher);
    }

    @Override
    public ChangeStreamPublisher<Document> watchAsPublisher(List<? extends Bson> pipeline) {
        return this.client.watch(pipeline);
    }

    @Override
    public PublisherBuilder<ChangeStreamDocument<Document>> watch(List<? extends Bson> pipeline) {
        return Wrappers.toPublisherBuilder(this.client.watch(pipeline));
    }

    @Override
    public PublisherBuilder<ChangeStreamDocument<Document>> watch(List<? extends Bson> pipeline, ChangeStreamOptions options) {
        ChangeStreamPublisher publisher = this.apply(options, this.client.watch(pipeline));
        return Wrappers.toPublisherBuilder(publisher);
    }

    @Override
    public <T> ChangeStreamPublisher<T> watchAsPublisher(List<? extends Bson> pipeline, Class<T> clazz) {
        return this.client.watch(pipeline, clazz);
    }

    @Override
    public <T> PublisherBuilder<ChangeStreamDocument<T>> watch(List<? extends Bson> pipeline, Class<T> clazz) {
        return Wrappers.toPublisherBuilder(this.client.watch(pipeline, clazz));
    }

    @Override
    public <T> PublisherBuilder<ChangeStreamDocument<T>> watch(List<? extends Bson> pipeline, Class<T> clazz, ChangeStreamOptions options) {
        ChangeStreamPublisher<T> publisher = this.apply(options, this.client.watch(pipeline, clazz));
        return Wrappers.toPublisherBuilder(publisher);
    }

    @Override
    public ChangeStreamPublisher<Document> watchAsPublisher(ClientSession clientSession) {
        return this.client.watch(clientSession);
    }

    @Override
    public PublisherBuilder<ChangeStreamDocument<Document>> watch(ClientSession clientSession) {
        return Wrappers.toPublisherBuilder(this.client.watch(clientSession));
    }

    @Override
    public PublisherBuilder<ChangeStreamDocument<Document>> watch(ClientSession clientSession, ChangeStreamOptions options) {
        ChangeStreamPublisher publisher = this.apply(options, this.client.watch(clientSession));
        return Wrappers.toPublisherBuilder(publisher);
    }

    @Override
    public <T> ChangeStreamPublisher<T> watchAsPublisher(ClientSession clientSession, Class<T> clazz) {
        return this.client.watch(clientSession, clazz);
    }

    @Override
    public <T> PublisherBuilder<ChangeStreamDocument<T>> watch(ClientSession clientSession, Class<T> clazz) {
        return Wrappers.toPublisherBuilder(this.client.watch(clientSession, clazz));
    }

    @Override
    public <T> PublisherBuilder<ChangeStreamDocument<T>> watch(ClientSession clientSession, Class<T> clazz, ChangeStreamOptions options) {
        ChangeStreamPublisher<T> publisher = this.apply(options, this.client.watch(clientSession, clazz));
        return Wrappers.toPublisherBuilder(publisher);
    }

    @Override
    public ChangeStreamPublisher<Document> watchAsPublisher(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.client.watch(clientSession, pipeline);
    }

    @Override
    public PublisherBuilder<ChangeStreamDocument<Document>> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return Wrappers.toPublisherBuilder(this.client.watch(clientSession, pipeline));
    }

    @Override
    public PublisherBuilder<ChangeStreamDocument<Document>> watch(ClientSession clientSession, List<? extends Bson> pipeline, ChangeStreamOptions options) {
        ChangeStreamPublisher publisher = this.apply(options, this.client.watch(clientSession, pipeline));
        return Wrappers.toPublisherBuilder(publisher);
    }

    @Override
    public <T> ChangeStreamPublisher<T> watchAsPublisher(ClientSession clientSession, List<? extends Bson> pipeline, Class<T> clazz) {
        return this.client.watch(clientSession, pipeline, clazz);
    }

    @Override
    public <T> PublisherBuilder<ChangeStreamDocument<T>> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<T> clazz) {
        return Wrappers.toPublisherBuilder(this.client.watch(clientSession, pipeline, clazz));
    }

    @Override
    public <T> PublisherBuilder<ChangeStreamDocument<T>> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<T> clazz, ChangeStreamOptions options) {
        ChangeStreamPublisher<T> publisher = this.apply(options, this.client.watch(clientSession, pipeline, clazz));
        return Wrappers.toPublisherBuilder(publisher);
    }

    @Override
    public CompletionStage<ClientSession> startSession() {
        return Wrappers.toCompletionStage(this.client.startSession());
    }

    @Override
    public CompletionStage<ClientSession> startSession(ClientSessionOptions options) {
        return Wrappers.toCompletionStage(this.client.startSession(options));
    }
}

