/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.metrics;

import com.mongodb.connection.ServerId;
import com.mongodb.event.ConnectionAddedEvent;
import com.mongodb.event.ConnectionCheckedInEvent;
import com.mongodb.event.ConnectionCheckedOutEvent;
import com.mongodb.event.ConnectionPoolClosedEvent;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.event.ConnectionPoolOpenedEvent;
import com.mongodb.event.ConnectionPoolWaitQueueEnteredEvent;
import com.mongodb.event.ConnectionPoolWaitQueueExitedEvent;
import com.mongodb.event.ConnectionRemovedEvent;
import io.quarkus.mongodb.metrics.ConnectionPoolGauge;
import io.smallrye.metrics.MetricRegistries;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public class MongoMetricsConnectionPoolListener
implements ConnectionPoolListener {
    private static final String SIZE_NAME = "mongodb.connection-pool.size";
    private static final String CHECKED_OUT_COUNT_NAME = "mongodb.connection-pool.checked-out-count";

    public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
        Tag[] tags = this.createTags(event.getServerId());
        this.registerGauge(SIZE_NAME, "the current size of the pool, including idle and and in-use members", tags);
        this.registerGauge(CHECKED_OUT_COUNT_NAME, "the current count of connections that are currently in use", tags);
    }

    public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
    }

    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        MetricID metricID = this.createMetricID(CHECKED_OUT_COUNT_NAME, event.getConnectionId().getServerId());
        Metric metric = (Metric)this.getMetricRegistry().getMetrics().get(metricID);
        if (metric != null) {
            ((ConnectionPoolGauge)metric).increment();
        }
    }

    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        MetricID metricID = this.createMetricID(CHECKED_OUT_COUNT_NAME, event.getConnectionId().getServerId());
        Metric metric = (Metric)this.getMetricRegistry().getMetrics().get(metricID);
        if (metric != null) {
            ((ConnectionPoolGauge)metric).decrement();
        }
    }

    public void waitQueueEntered(ConnectionPoolWaitQueueEnteredEvent connectionPoolWaitQueueEnteredEvent) {
    }

    public void waitQueueExited(ConnectionPoolWaitQueueExitedEvent connectionPoolWaitQueueExitedEvent) {
    }

    public void connectionAdded(ConnectionAddedEvent event) {
        MetricID metricID = this.createMetricID(SIZE_NAME, event.getConnectionId().getServerId());
        Metric metric = (Metric)this.getMetricRegistry().getMetrics().get(metricID);
        if (metric != null) {
            ((ConnectionPoolGauge)metric).increment();
        }
    }

    public void connectionRemoved(ConnectionRemovedEvent event) {
        MetricID metricID = this.createMetricID(SIZE_NAME, event.getConnectionId().getServerId());
        Metric metric = (Metric)this.getMetricRegistry().getMetrics().get(metricID);
        if (metric != null) {
            ((ConnectionPoolGauge)metric).decrement();
        }
    }

    private void registerGauge(String metricName, String description, Tag[] tags) {
        this.getMetricRegistry().remove(new MetricID(metricName, tags));
        Metadata metaData = Metadata.builder().withName(metricName).withType(MetricType.GAUGE).withDescription(description).build();
        this.getMetricRegistry().register(metaData, (Metric)new ConnectionPoolGauge(), tags);
    }

    private MetricRegistry getMetricRegistry() {
        return MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
    }

    private Tag[] createTags(ServerId server) {
        return new Tag[]{new Tag("host", server.getAddress().getHost()), new Tag("port", String.valueOf(server.getAddress().getPort()))};
    }

    private MetricID createMetricID(String metricName, ServerId server) {
        return new MetricID(metricName, this.createTags(server));
    }
}

