/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

class Wrappers {
    private Wrappers() {
    }

    static <T> Uni<T> toUni(Publisher<T> publisher) {
        Context context = Vertx.currentContext();
        Uni uni = Uni.createFrom().publisher(publisher);
        if (context != null) {
            return uni.emitOn(command -> context.runOnContext(x -> command.run()));
        }
        return uni;
    }

    static <T> Multi<T> toMulti(Publisher<T> publisher) {
        @Nullable Context context = Vertx.currentContext();
        if (context != null) {
            return Multi.createFrom().publisher(publisher).emitOn(command -> context.runOnContext(x -> command.run()));
        }
        return Multi.createFrom().publisher(publisher);
    }

    static <T> Uni<List<T>> toUniOfList(Publisher<T> publisher) {
        @Nullable Context context = Vertx.currentContext();
        Uni uni = Multi.createFrom().publisher(publisher).collectItems().asList();
        if (context != null) {
            return uni.emitOn(command -> context.runOnContext(x -> command.run()));
        }
        return uni;
    }

    static <T> PublisherBuilder<T> toPublisherBuilder(Publisher<T> publisher) {
        @Nullable Context context = Vertx.currentContext();
        if (context != null) {
            Multi multi = Multi.createFrom().publisher(publisher).emitOn(command -> context.runOnContext(x -> command.run()));
            return ReactiveStreams.fromPublisher((Publisher)multi);
        }
        return ReactiveStreams.fromPublisher(publisher);
    }

    public static <T> CompletionStage<T> toCompletionStage(Publisher<T> publisher) {
        Context context = Vertx.currentContext();
        CompletableFuture future = Multi.createFrom().publisher(publisher).collectItems().first().subscribeAsCompletionStage();
        CompletableFuture result = new CompletableFuture();
        future.whenComplete((value, err) -> {
            if (context != null) {
                context.runOnContext(x -> Wrappers.completeOrFailedTheFuture(result, value, err));
            } else {
                Wrappers.completeOrFailedTheFuture(result, value, err);
            }
        });
        return result;
    }

    private static <T> void completeOrFailedTheFuture(CompletableFuture<T> cf, T value, Throwable err) {
        if (err != null) {
            cf.completeExceptionally(err);
        } else {
            cf.complete(value);
        }
    }

    static <T> CompletionStage<List<T>> toCompletionStageOfList(Publisher<T> publisher) {
        @Nullable Context context = Vertx.currentContext();
        CompletableFuture run = Multi.createFrom().publisher(publisher).collectItems().asList().subscribeAsCompletionStage();
        CompletableFuture cf = new CompletableFuture();
        run.thenAccept(list -> {
            if (context != null) {
                context.runOnContext(x -> cf.complete((List)list));
            } else {
                cf.complete((List)list);
            }
        });
        return cf;
    }
}

