/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime;

import com.mongodb.client.MongoClient;
import com.mongodb.event.ConnectionPoolListener;
import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.quarkus.mongodb.runtime.AbstractMongoClientProducer;
import io.quarkus.mongodb.runtime.MongodbConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.util.AnnotationLiteral;

@Recorder
public class MongoClientRecorder {
    public static final String DEFAULT_MONGOCLIENT_NAME = "<default>";
    public static final String REACTIVE_CLIENT_NAME_SUFFIX = "reactive";

    public BeanContainerListener addMongoClient(final Class<? extends AbstractMongoClientProducer> mongoClientProducerClass, final boolean disableSslSupport) {
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                AbstractMongoClientProducer producer = (AbstractMongoClientProducer)beanContainer.instance(mongoClientProducerClass, new Annotation[0]);
                if (disableSslSupport) {
                    producer.disableSslSupport();
                }
            }
        };
    }

    public void configureRuntimeProperties(List<String> codecs, List<String> bsonDiscriminators, MongodbConfig config, List<ConnectionPoolListener> connectionPoolListeners) {
        AbstractMongoClientProducer producer = (AbstractMongoClientProducer)Arc.container().instance(AbstractMongoClientProducer.class, new Annotation[0]).get();
        producer.setCodecs(codecs);
        producer.setBsonDiscriminators(bsonDiscriminators);
        producer.setConfig(config);
        producer.setConnectionPoolListeners(connectionPoolListeners);
    }

    public RuntimeValue<MongoClient> getClient(String name) {
        return new RuntimeValue(Arc.container().instance(MongoClient.class, new Annotation[]{this.literal(name)}).get());
    }

    public RuntimeValue<ReactiveMongoClient> getReactiveClient(String name) {
        return new RuntimeValue(Arc.container().instance(ReactiveMongoClient.class, new Annotation[]{this.literal(name + REACTIVE_CLIENT_NAME_SUFFIX)}).get());
    }

    private AnnotationLiteral literal(String name) {
        if (name.startsWith(DEFAULT_MONGOCLIENT_NAME)) {
            return Default.Literal.INSTANCE;
        }
        return NamedLiteral.of((String)name);
    }
}

