/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.health;

import com.mongodb.client.MongoClient;
import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class MongoHealthCheck
implements HealthCheck {
    private static final String DEFAULT_CLIENT = "__default__";
    private Map<String, MongoClient> clients = new HashMap<String, MongoClient>();

    @PostConstruct
    protected void init() {
        Set beans = Arc.container().beanManager().getBeans(MongoClient.class, new Annotation[0]);
        for (Bean bean : beans) {
            if (bean.getName() == null) {
                MongoClient defaultClient = (MongoClient)Arc.container().instance(MongoClient.class, new Annotation[0]).get();
                this.clients.put(DEFAULT_CLIENT, defaultClient);
                continue;
            }
            MongoClient client = (MongoClient)Arc.container().instance(bean.getName()).get();
            this.clients.put(bean.getName(), client);
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"MongoDB connection health check").up();
        for (Map.Entry<String, MongoClient> client : this.clients.entrySet()) {
            boolean isDefault = DEFAULT_CLIENT.equals(client.getKey());
            MongoClient mongoClient = client.getValue();
            try {
                Document document = mongoClient.getDatabase("admin").runCommand((Bson)new Document("ping", (Object)1));
                String mongoClientName = isDefault ? "default" : client.getKey();
                builder.up().withData(mongoClientName, document.toJson());
            }
            catch (Exception e) {
                return builder.down().withData("reason", e.getMessage()).build();
            }
        }
        return builder.build();
    }
}

