/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime;

import com.mongodb.client.MongoClient;
import com.mongodb.event.ConnectionPoolListener;
import io.quarkus.arc.Arc;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.quarkus.mongodb.runtime.MongoClientSupport;
import io.quarkus.mongodb.runtime.MongoClients;
import io.quarkus.mongodb.runtime.MongodbConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Supplier;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.util.AnnotationLiteral;

@Recorder
public class MongoClientRecorder {
    public Supplier<MongoClientSupport> mongoClientSupportSupplier(final List<String> codecProviders, final List<String> bsonDiscriminators, final List<ConnectionPoolListener> connectionPoolListeners, final boolean disableSslSupport) {
        return new Supplier<MongoClientSupport>(){

            @Override
            public MongoClientSupport get() {
                return new MongoClientSupport(codecProviders, bsonDiscriminators, connectionPoolListeners, disableSslSupport);
            }
        };
    }

    public Supplier<MongoClient> mongoClientSupplier(String clientName, MongodbConfig mongodbConfig) {
        final MongoClient mongoClient = ((MongoClients)Arc.container().instance(MongoClients.class, new Annotation[0]).get()).createMongoClient(clientName);
        return new Supplier<MongoClient>(){

            @Override
            public MongoClient get() {
                return mongoClient;
            }
        };
    }

    public Supplier<ReactiveMongoClient> reactiveMongoClientSupplier(String clientName, MongodbConfig mongodbConfig) {
        final ReactiveMongoClient reactiveMongoClient = ((MongoClients)Arc.container().instance(MongoClients.class, new Annotation[0]).get()).createReactiveMongoClient(clientName);
        return new Supplier<ReactiveMongoClient>(){

            @Override
            public ReactiveMongoClient get() {
                return reactiveMongoClient;
            }
        };
    }

    public RuntimeValue<MongoClient> getClient(String name) {
        return new RuntimeValue(Arc.container().instance(MongoClient.class, new Annotation[]{this.literal(name)}).get());
    }

    public RuntimeValue<ReactiveMongoClient> getReactiveClient(String name) {
        return new RuntimeValue(Arc.container().instance(ReactiveMongoClient.class, new Annotation[]{this.literal(name + "reactive")}).get());
    }

    private AnnotationLiteral literal(String name) {
        if (name.startsWith("<default>")) {
            return Default.Literal.INSTANCE;
        }
        return NamedLiteral.of((String)name);
    }
}

