/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb;

import com.mongodb.CursorType;
import com.mongodb.client.model.Collation;
import com.mongodb.reactivestreams.client.FindPublisher;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

public class FindOptions {
    private Bson filter;
    private int limit;
    private int skip;
    private long maxTime;
    private TimeUnit maxTimeUnit;
    private Bson projection;
    private Bson sort;
    private boolean noCursorTimeout;
    private boolean oplogReplay;
    private boolean partial;
    private CursorType cursorType;
    private Collation collation;
    private String comment;
    private Bson hint;
    private Bson max;
    private Bson min;
    private boolean returnKey;
    private boolean showRecordId;
    private long maxAwaitTime;
    private TimeUnit maxAwaitTimeUnit;

    public FindOptions filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    public FindOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public FindOptions skip(int skip) {
        this.skip = skip;
        return this;
    }

    public FindOptions maxTime(long maxTime, TimeUnit timeUnit) {
        this.maxTime = maxTime;
        this.maxTimeUnit = timeUnit;
        return this;
    }

    public FindOptions maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.maxAwaitTime = this.maxTime;
        this.maxAwaitTimeUnit = timeUnit;
        return this;
    }

    public FindOptions projection(Bson projection) {
        this.projection = projection;
        return this;
    }

    public FindOptions sort(Bson sort) {
        this.sort = sort;
        return this;
    }

    public FindOptions noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public FindOptions oplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
        return this;
    }

    public FindOptions partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public FindOptions cursorType(CursorType cursorType) {
        this.cursorType = cursorType;
        return this;
    }

    public FindOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public FindOptions comment(String comment) {
        this.comment = comment;
        return this;
    }

    public FindOptions hint(Bson hint) {
        this.hint = hint;
        return this;
    }

    public FindOptions max(Bson max) {
        this.max = max;
        return this;
    }

    public FindOptions min(Bson min) {
        this.min = min;
        return this;
    }

    public FindOptions returnKey(boolean returnKey) {
        this.returnKey = returnKey;
        return this;
    }

    public FindOptions showRecordId(boolean showRecordId) {
        this.showRecordId = showRecordId;
        return this;
    }

    public <T> FindPublisher<T> apply(FindPublisher<T> stream) {
        FindPublisher publisher = stream;
        if (this.filter != null) {
            publisher = publisher.filter(this.filter);
        }
        if (this.limit > 0) {
            publisher = publisher.limit(this.limit);
        }
        if (this.skip > 0) {
            publisher = publisher.skip(this.skip);
        }
        if (this.maxTime > 0L) {
            publisher = publisher.maxTime(this.maxTime, this.maxTimeUnit);
        }
        if (this.maxAwaitTime > 0L) {
            publisher = publisher.maxAwaitTime(this.maxAwaitTime, this.maxAwaitTimeUnit);
        }
        if (this.projection != null) {
            publisher = publisher.projection(this.projection);
        }
        if (this.sort != null) {
            publisher = publisher.sort(this.sort);
        }
        if (this.noCursorTimeout) {
            publisher = publisher.noCursorTimeout(true);
        }
        if (this.oplogReplay) {
            publisher = publisher.oplogReplay(true);
        }
        if (this.partial) {
            publisher = publisher.partial(true);
        }
        if (this.cursorType != null) {
            publisher = publisher.cursorType(this.cursorType);
        }
        if (this.collation != null) {
            publisher = publisher.collation(this.collation);
        }
        if (this.comment != null) {
            publisher = publisher.comment(this.comment);
        }
        if (this.hint != null) {
            publisher = publisher.hint(this.hint);
        }
        if (this.max != null) {
            publisher = publisher.max(this.max);
        }
        if (this.min != null) {
            publisher = publisher.min(this.min);
        }
        if (this.returnKey) {
            publisher = publisher.returnKey(true);
        }
        if (this.showRecordId) {
            publisher = publisher.showRecordId(true);
        }
        return publisher;
    }
}

