/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.reactive;

import com.mongodb.MongoNamespace;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.ClientSession;
import io.quarkus.mongodb.AggregateOptions;
import io.quarkus.mongodb.ChangeStreamOptions;
import io.quarkus.mongodb.DistinctOptions;
import io.quarkus.mongodb.FindOptions;
import io.quarkus.mongodb.MapReduceOptions;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public interface ReactiveMongoCollection<T> {
    public MongoNamespace getNamespace();

    public Class<T> getDocumentClass();

    public Uni<Long> estimatedDocumentCount();

    public Uni<Long> estimatedDocumentCount(EstimatedDocumentCountOptions var1);

    public Uni<Long> countDocuments();

    public Uni<Long> countDocuments(Bson var1);

    public Uni<Long> countDocuments(Bson var1, CountOptions var2);

    public Uni<Long> countDocuments(ClientSession var1);

    public Uni<Long> countDocuments(ClientSession var1, Bson var2);

    public Uni<Long> countDocuments(ClientSession var1, Bson var2, CountOptions var3);

    public <D> Multi<D> distinct(String var1, Class<D> var2);

    public <D> Multi<D> distinct(String var1, Bson var2, Class<D> var3);

    public <D> Multi<D> distinct(ClientSession var1, String var2, Class<D> var3);

    public <D> Multi<D> distinct(ClientSession var1, String var2, Bson var3, Class<D> var4);

    public <D> Multi<D> distinct(String var1, Class<D> var2, DistinctOptions var3);

    public <D> Multi<D> distinct(String var1, Bson var2, Class<D> var3, DistinctOptions var4);

    public <D> Multi<D> distinct(ClientSession var1, String var2, Class<D> var3, DistinctOptions var4);

    public <D> Multi<D> distinct(ClientSession var1, String var2, Bson var3, Class<D> var4, DistinctOptions var5);

    public Multi<T> find();

    public <D> Multi<D> find(Class<D> var1);

    public Multi<T> find(Bson var1);

    public <D> Multi<D> find(Bson var1, Class<D> var2);

    public Multi<T> find(ClientSession var1);

    public <D> Multi<D> find(ClientSession var1, Class<D> var2);

    public Multi<T> find(ClientSession var1, Bson var2);

    public <D> Multi<D> find(ClientSession var1, Bson var2, Class<D> var3);

    public Multi<T> find(FindOptions var1);

    public <D> Multi<D> find(Class<D> var1, FindOptions var2);

    public Multi<T> find(Bson var1, FindOptions var2);

    public <D> Multi<D> find(Bson var1, Class<D> var2, FindOptions var3);

    public Multi<T> find(ClientSession var1, FindOptions var2);

    public <D> Multi<D> find(ClientSession var1, Class<D> var2, FindOptions var3);

    public Multi<T> find(ClientSession var1, Bson var2, FindOptions var3);

    public <D> Multi<D> find(ClientSession var1, Bson var2, Class<D> var3, FindOptions var4);

    public Multi<T> aggregate(List<? extends Bson> var1);

    public <D> Multi<D> aggregate(List<? extends Bson> var1, Class<D> var2);

    public Multi<T> aggregate(ClientSession var1, List<? extends Bson> var2);

    public <D> Multi<D> aggregate(ClientSession var1, List<? extends Bson> var2, Class<D> var3);

    public Multi<T> aggregate(List<? extends Bson> var1, AggregateOptions var2);

    public <D> Multi<D> aggregate(List<? extends Bson> var1, Class<D> var2, AggregateOptions var3);

    public Multi<T> aggregate(ClientSession var1, List<? extends Bson> var2, AggregateOptions var3);

    public <D> Multi<D> aggregate(ClientSession var1, List<? extends Bson> var2, Class<D> var3, AggregateOptions var4);

    public Multi<ChangeStreamDocument<Document>> watch();

    public <D> Multi<ChangeStreamDocument<D>> watch(Class<D> var1);

    public Multi<ChangeStreamDocument<Document>> watch(List<? extends Bson> var1);

    public <D> Multi<ChangeStreamDocument<D>> watch(List<? extends Bson> var1, Class<D> var2);

    public Multi<ChangeStreamDocument<Document>> watch(ClientSession var1);

    public <D> Multi<ChangeStreamDocument<D>> watch(ClientSession var1, Class<D> var2);

    public Multi<ChangeStreamDocument<Document>> watch(ClientSession var1, List<? extends Bson> var2);

    public <D> Multi<ChangeStreamDocument<D>> watch(ClientSession var1, List<? extends Bson> var2, Class<D> var3);

    public Multi<ChangeStreamDocument<Document>> watch(ChangeStreamOptions var1);

    public <D> Multi<ChangeStreamDocument<D>> watch(Class<D> var1, ChangeStreamOptions var2);

    public Multi<ChangeStreamDocument<Document>> watch(List<? extends Bson> var1, ChangeStreamOptions var2);

    public <D> Multi<ChangeStreamDocument<D>> watch(List<? extends Bson> var1, Class<D> var2, ChangeStreamOptions var3);

    public Multi<ChangeStreamDocument<Document>> watch(ClientSession var1, ChangeStreamOptions var2);

    public <D> Multi<ChangeStreamDocument<D>> watch(ClientSession var1, Class<D> var2, ChangeStreamOptions var3);

    public Multi<ChangeStreamDocument<Document>> watch(ClientSession var1, List<? extends Bson> var2, ChangeStreamOptions var3);

    public <D> Multi<ChangeStreamDocument<D>> watch(ClientSession var1, List<? extends Bson> var2, Class<D> var3, ChangeStreamOptions var4);

    public Multi<T> mapReduce(String var1, String var2);

    public <D> Multi<D> mapReduce(String var1, String var2, Class<D> var3);

    public Multi<T> mapReduce(ClientSession var1, String var2, String var3);

    public <D> Multi<D> mapReduce(ClientSession var1, String var2, String var3, Class<D> var4);

    public Multi<T> mapReduce(String var1, String var2, MapReduceOptions var3);

    public <D> Multi<D> mapReduce(String var1, String var2, Class<D> var3, MapReduceOptions var4);

    public Multi<T> mapReduce(ClientSession var1, String var2, String var3, MapReduceOptions var4);

    public <D> Multi<D> mapReduce(ClientSession var1, String var2, String var3, Class<D> var4, MapReduceOptions var5);

    public Uni<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends T>> var1);

    public Uni<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends T>> var1, BulkWriteOptions var2);

    public Uni<BulkWriteResult> bulkWrite(ClientSession var1, List<? extends WriteModel<? extends T>> var2);

    public Uni<BulkWriteResult> bulkWrite(ClientSession var1, List<? extends WriteModel<? extends T>> var2, BulkWriteOptions var3);

    public Uni<InsertOneResult> insertOne(T var1);

    public Uni<InsertOneResult> insertOne(T var1, InsertOneOptions var2);

    public Uni<InsertOneResult> insertOne(ClientSession var1, T var2);

    public Uni<InsertOneResult> insertOne(ClientSession var1, T var2, InsertOneOptions var3);

    public Uni<InsertManyResult> insertMany(List<? extends T> var1);

    public Uni<InsertManyResult> insertMany(List<? extends T> var1, InsertManyOptions var2);

    public Uni<InsertManyResult> insertMany(ClientSession var1, List<? extends T> var2);

    public Uni<InsertManyResult> insertMany(ClientSession var1, List<? extends T> var2, InsertManyOptions var3);

    public Uni<DeleteResult> deleteOne(Bson var1);

    public Uni<DeleteResult> deleteOne(Bson var1, DeleteOptions var2);

    public Uni<DeleteResult> deleteOne(ClientSession var1, Bson var2);

    public Uni<DeleteResult> deleteOne(ClientSession var1, Bson var2, DeleteOptions var3);

    public Uni<DeleteResult> deleteMany(Bson var1);

    public Uni<DeleteResult> deleteMany(Bson var1, DeleteOptions var2);

    public Uni<DeleteResult> deleteMany(ClientSession var1, Bson var2);

    public Uni<DeleteResult> deleteMany(ClientSession var1, Bson var2, DeleteOptions var3);

    public Uni<UpdateResult> replaceOne(Bson var1, T var2);

    public Uni<UpdateResult> replaceOne(Bson var1, T var2, ReplaceOptions var3);

    public Uni<UpdateResult> replaceOne(ClientSession var1, Bson var2, T var3);

    public Uni<UpdateResult> replaceOne(ClientSession var1, Bson var2, T var3, ReplaceOptions var4);

    public Uni<UpdateResult> updateOne(Bson var1, Bson var2);

    public Uni<UpdateResult> updateOne(Bson var1, Bson var2, UpdateOptions var3);

    public Uni<UpdateResult> updateOne(ClientSession var1, Bson var2, Bson var3);

    public Uni<UpdateResult> updateOne(ClientSession var1, Bson var2, Bson var3, UpdateOptions var4);

    public Uni<UpdateResult> updateMany(Bson var1, Bson var2);

    public Uni<UpdateResult> updateMany(Bson var1, Bson var2, UpdateOptions var3);

    public Uni<UpdateResult> updateMany(ClientSession var1, Bson var2, Bson var3);

    public Uni<UpdateResult> updateMany(ClientSession var1, Bson var2, Bson var3, UpdateOptions var4);

    public Uni<T> findOneAndDelete(Bson var1);

    public Uni<T> findOneAndDelete(Bson var1, FindOneAndDeleteOptions var2);

    public Uni<T> findOneAndDelete(ClientSession var1, Bson var2);

    public Uni<T> findOneAndDelete(ClientSession var1, Bson var2, FindOneAndDeleteOptions var3);

    public Uni<T> findOneAndReplace(Bson var1, T var2);

    public Uni<T> findOneAndReplace(Bson var1, T var2, FindOneAndReplaceOptions var3);

    public Uni<T> findOneAndReplace(ClientSession var1, Bson var2, T var3);

    public Uni<T> findOneAndReplace(ClientSession var1, Bson var2, T var3, FindOneAndReplaceOptions var4);

    public Uni<T> findOneAndUpdate(Bson var1, Bson var2);

    public Uni<T> findOneAndUpdate(Bson var1, Bson var2, FindOneAndUpdateOptions var3);

    public Uni<T> findOneAndUpdate(ClientSession var1, Bson var2, Bson var3);

    public Uni<T> findOneAndUpdate(ClientSession var1, Bson var2, Bson var3, FindOneAndUpdateOptions var4);

    public Uni<Void> drop();

    public Uni<Void> drop(ClientSession var1);

    public Uni<String> createIndex(Bson var1);

    public Uni<String> createIndex(Bson var1, IndexOptions var2);

    public Uni<String> createIndex(ClientSession var1, Bson var2);

    public Uni<String> createIndex(ClientSession var1, Bson var2, IndexOptions var3);

    public Uni<List<String>> createIndexes(List<IndexModel> var1);

    public Uni<List<String>> createIndexes(List<IndexModel> var1, CreateIndexOptions var2);

    public Uni<List<String>> createIndexes(ClientSession var1, List<IndexModel> var2);

    public Uni<List<String>> createIndexes(ClientSession var1, List<IndexModel> var2, CreateIndexOptions var3);

    public Multi<Document> listIndexes();

    public <D> Multi<D> listIndexes(Class<D> var1);

    public Multi<Document> listIndexes(ClientSession var1);

    public <D> Multi<D> listIndexes(ClientSession var1, Class<D> var2);

    public Uni<Void> dropIndex(String var1);

    public Uni<Void> dropIndex(Bson var1);

    public Uni<Void> dropIndex(String var1, DropIndexOptions var2);

    public Uni<Void> dropIndex(Bson var1, DropIndexOptions var2);

    public Uni<Void> dropIndex(ClientSession var1, String var2);

    public Uni<Void> dropIndex(ClientSession var1, Bson var2);

    public Uni<Void> dropIndex(ClientSession var1, String var2, DropIndexOptions var3);

    public Uni<Void> dropIndex(ClientSession var1, Bson var2, DropIndexOptions var3);

    public Uni<Void> dropIndexes();

    public Uni<Void> dropIndexes(DropIndexOptions var1);

    public Uni<Void> dropIndexes(ClientSession var1);

    public Uni<Void> dropIndexes(ClientSession var1, DropIndexOptions var2);

    public Uni<Void> renameCollection(MongoNamespace var1);

    public Uni<Void> renameCollection(MongoNamespace var1, RenameCollectionOptions var2);

    public Uni<Void> renameCollection(ClientSession var1, MongoNamespace var2);

    public Uni<Void> renameCollection(ClientSession var1, MongoNamespace var2, RenameCollectionOptions var3);

    public CodecRegistry getCodecRegistry();

    public <NewTDocument> ReactiveMongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> var1);
}

