/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.impl;

import com.mongodb.ClientSessionOptions;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import io.quarkus.mongodb.ChangeStreamOptions;
import io.quarkus.mongodb.DatabaseListOptions;
import io.quarkus.mongodb.impl.ReactiveMongoDatabaseImpl;
import io.quarkus.mongodb.impl.Wrappers;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.quarkus.mongodb.reactive.ReactiveMongoDatabase;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ReactiveMongoClientImpl
implements ReactiveMongoClient {
    private final MongoClient client;

    public ReactiveMongoClientImpl(MongoClient client) {
        this.client = client;
    }

    @Override
    public ReactiveMongoDatabase getDatabase(String name) {
        return new ReactiveMongoDatabaseImpl(this.client.getDatabase(name));
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Multi<String> listDatabaseNames() {
        return Wrappers.toMulti(this.client.listDatabaseNames());
    }

    @Override
    public Multi<String> listDatabaseNames(ClientSession clientSession) {
        return Wrappers.toMulti(this.client.listDatabaseNames(clientSession));
    }

    @Override
    public Multi<Document> listDatabases() {
        return Wrappers.toMulti(this.client.listDatabases());
    }

    @Override
    public Multi<Document> listDatabases(DatabaseListOptions options) {
        if (options != null) {
            ListDatabasesPublisher publisher = this.apply(options, this.client.listDatabases());
            return Wrappers.toMulti(publisher);
        }
        return this.listDatabases();
    }

    private <T> ListDatabasesPublisher<T> apply(DatabaseListOptions options, ListDatabasesPublisher<T> publisher) {
        if (options == null) {
            return publisher;
        }
        return options.apply(publisher);
    }

    private <T> ChangeStreamPublisher<T> apply(ChangeStreamOptions options, ChangeStreamPublisher<T> publisher) {
        if (options == null) {
            return publisher;
        }
        return options.apply(publisher);
    }

    @Override
    public <T> Multi<T> listDatabases(Class<T> clazz) {
        return Wrappers.toMulti(this.client.listDatabases(clazz));
    }

    @Override
    public <T> Multi<T> listDatabases(Class<T> clazz, DatabaseListOptions options) {
        if (options != null) {
            ListDatabasesPublisher<T> publisher = this.apply(options, this.client.listDatabases(clazz));
            return Wrappers.toMulti(publisher);
        }
        return this.listDatabases(clazz);
    }

    @Override
    public Multi<Document> listDatabases(ClientSession clientSession) {
        return Wrappers.toMulti(this.client.listDatabases(clientSession));
    }

    @Override
    public Multi<Document> listDatabases(ClientSession clientSession, DatabaseListOptions options) {
        ListDatabasesPublisher publisher = this.apply(options, this.client.listDatabases(clientSession));
        return Wrappers.toMulti(publisher);
    }

    @Override
    public <T> Multi<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        return Wrappers.toMulti(this.client.listDatabases(clientSession, clazz));
    }

    @Override
    public <T> Multi<T> listDatabases(ClientSession clientSession, Class<T> clazz, DatabaseListOptions options) {
        return Wrappers.toMulti(this.apply(options, this.client.listDatabases(clientSession, clazz)));
    }

    @Override
    public Multi<ChangeStreamDocument<Document>> watch() {
        return Wrappers.toMulti(this.client.watch());
    }

    @Override
    public Multi<ChangeStreamDocument<Document>> watch(ChangeStreamOptions options) {
        ChangeStreamPublisher publisher = this.apply(options, this.client.watch());
        return Wrappers.toMulti(publisher);
    }

    @Override
    public <T> Multi<ChangeStreamDocument<T>> watch(Class<T> clazz) {
        return Wrappers.toMulti(this.client.watch(clazz));
    }

    @Override
    public <T> Multi<ChangeStreamDocument<T>> watch(Class<T> clazz, ChangeStreamOptions options) {
        ChangeStreamPublisher<T> publisher = this.apply(options, this.client.watch(clazz));
        return Wrappers.toMulti(publisher);
    }

    @Override
    public Multi<ChangeStreamDocument<Document>> watch(List<? extends Bson> pipeline) {
        return Wrappers.toMulti(this.client.watch(pipeline));
    }

    @Override
    public Multi<ChangeStreamDocument<Document>> watch(List<? extends Bson> pipeline, ChangeStreamOptions options) {
        ChangeStreamPublisher publisher = this.apply(options, this.client.watch(pipeline));
        return Wrappers.toMulti(publisher);
    }

    @Override
    public <T> Multi<ChangeStreamDocument<T>> watch(List<? extends Bson> pipeline, Class<T> clazz) {
        return Wrappers.toMulti(this.client.watch(pipeline, clazz));
    }

    @Override
    public <T> Multi<ChangeStreamDocument<T>> watch(List<? extends Bson> pipeline, Class<T> clazz, ChangeStreamOptions options) {
        ChangeStreamPublisher<T> publisher = this.apply(options, this.client.watch(pipeline, clazz));
        return Wrappers.toMulti(publisher);
    }

    @Override
    public Multi<ChangeStreamDocument<Document>> watch(ClientSession clientSession) {
        return Wrappers.toMulti(this.client.watch(clientSession));
    }

    @Override
    public Multi<ChangeStreamDocument<Document>> watch(ClientSession clientSession, ChangeStreamOptions options) {
        ChangeStreamPublisher publisher = this.apply(options, this.client.watch(clientSession));
        return Wrappers.toMulti(publisher);
    }

    @Override
    public <T> Multi<ChangeStreamDocument<T>> watch(ClientSession clientSession, Class<T> clazz) {
        return Wrappers.toMulti(this.client.watch(clientSession, clazz));
    }

    @Override
    public <T> Multi<ChangeStreamDocument<T>> watch(ClientSession clientSession, Class<T> clazz, ChangeStreamOptions options) {
        ChangeStreamPublisher<T> publisher = this.apply(options, this.client.watch(clientSession, clazz));
        return Wrappers.toMulti(publisher);
    }

    @Override
    public Multi<ChangeStreamDocument<Document>> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return Wrappers.toMulti(this.client.watch(clientSession, pipeline));
    }

    @Override
    public Multi<ChangeStreamDocument<Document>> watch(ClientSession clientSession, List<? extends Bson> pipeline, ChangeStreamOptions options) {
        ChangeStreamPublisher publisher = this.apply(options, this.client.watch(clientSession, pipeline));
        return Wrappers.toMulti(publisher);
    }

    @Override
    public <T> Multi<ChangeStreamDocument<T>> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<T> clazz) {
        return Wrappers.toMulti(this.client.watch(clientSession, pipeline, clazz));
    }

    @Override
    public <T> Multi<ChangeStreamDocument<T>> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<T> clazz, ChangeStreamOptions options) {
        ChangeStreamPublisher<T> publisher = this.apply(options, this.client.watch(clientSession, pipeline, clazz));
        return Wrappers.toMulti(publisher);
    }

    @Override
    public Uni<ClientSession> startSession() {
        return Wrappers.toUni(this.client.startSession());
    }

    @Override
    public Uni<ClientSession> startSession(ClientSessionOptions options) {
        return Wrappers.toUni(this.client.startSession(options));
    }

    @Override
    public MongoClient unwrap() {
        return this.client;
    }
}

