/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime.graal;

import com.mongodb.MongoConfigurationException;
import com.mongodb.internal.dns.DefaultDnsResolver;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.quarkus.mongodb.runtime.dns.DnsClientProducer;
import io.vertx.mutiny.core.dns.DnsClient;
import io.vertx.mutiny.core.dns.SrvRecord;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@TargetClass(value=DefaultDnsResolver.class)
final class DefaultDnsResolverSubstitution {
    DefaultDnsResolverSubstitution() {
    }

    @Substitute
    public List<String> resolveHostFromSrvRecords(String srvHost, String srvServiceName) {
        Config config = ConfigProvider.getConfig();
        if (!config.getOptionalValue("quarkus.mongodb.native.dns.use-vertx-dns-resolver", Boolean.class).orElse(false).booleanValue()) {
            throw new MongoConfigurationException("'mongo+srv://' is not supported in native. You can set 'quarkus.mongodb.native.dns.use-vertx-dns-resolver' to `true` to use an alternative DNS resolver.");
        }
        DnsClient dnsClient = DnsClientProducer.createDnsClient();
        String srvHostDomain = srvHost.substring(srvHost.indexOf(46) + 1);
        List<String> srvHostDomainParts = Arrays.asList(srvHostDomain.split("\\."));
        ArrayList<String> hosts = new ArrayList<String>();
        Duration timeout = config.getOptionalValue("quarkus.mongodb.native.dns.lookup-timeout", Duration.class).orElse(Duration.ofSeconds(5L));
        String resourceName = "_" + srvServiceName + "._tcp." + srvHost;
        try {
            List srvRecords = (List)dnsClient.resolveSRV(resourceName).await().atMost(timeout);
            if (srvRecords.isEmpty()) {
                throw new MongoConfigurationException("No SRV records available for host " + resourceName);
            }
            for (SrvRecord srvRecord : srvRecords) {
                String resolvedHost = srvRecord.target().endsWith(".") ? srvRecord.target().substring(0, srvRecord.target().length() - 1) : srvRecord.target();
                String resolvedHostDomain = resolvedHost.substring(resolvedHost.indexOf(46) + 1);
                if (!DefaultDnsResolverSubstitution.sameParentDomain(srvHostDomainParts, resolvedHostDomain)) {
                    throw new MongoConfigurationException(String.format("The SRV host name '%s' resolved to a host '%s 'that is not in a sub-domain of the SRV host.", srvHost, resolvedHost));
                }
                hosts.add(resolvedHost + ":" + srvRecord.port());
            }
        }
        catch (Throwable e) {
            throw new MongoConfigurationException("Unable to look up SRV record for host " + srvHost, e);
        }
        return hosts;
    }

    @Substitute
    private static boolean sameParentDomain(List<String> srvHostDomainParts, String resolvedHostDomain) {
        List<String> resolvedHostDomainParts = Arrays.asList(resolvedHostDomain.split("\\."));
        if (srvHostDomainParts.size() > resolvedHostDomainParts.size()) {
            return false;
        }
        return resolvedHostDomainParts.subList(resolvedHostDomainParts.size() - srvHostDomainParts.size(), resolvedHostDomainParts.size()).equals(srvHostDomainParts);
    }

    @Substitute
    public String resolveAdditionalQueryParametersFromTxtRecords(String host) {
        Config config = ConfigProvider.getConfig();
        if (!config.getOptionalValue("quarkus.mongodb.native.dns.use-vertx-dns-resolver", Boolean.class).orElse(false).booleanValue()) {
            throw new MongoConfigurationException("'mongo+srv://' is not supported in native. You can set 'quarkus.mongodb.native.dns.use-vertx-dns-resolver' to `true` to use an alternative DNS resolver.");
        }
        DnsClient dnsClient = DnsClientProducer.createDnsClient();
        String additionalQueryParameters = "";
        try {
            Duration timeout = config.getOptionalValue("quarkus.mongodb.native.dns.lookup-timeout", Duration.class).orElse(Duration.ofSeconds(5L));
            List txtRecordEnumeration = (List)dnsClient.resolveTXT(host).await().atMost(timeout);
            for (String txtRecord : txtRecordEnumeration) {
                additionalQueryParameters = txtRecord.replaceAll("\\s", "");
                if (txtRecordEnumeration.size() <= 1) continue;
                throw new MongoConfigurationException(String.format("Multiple TXT records found for host '%s'.  Only one is permitted", host));
            }
            return additionalQueryParameters;
        }
        catch (Throwable e) {
            throw new MongoConfigurationException("Unable to look up TXT record for host " + host, e);
        }
    }
}

