/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime.dns;

import com.mongodb.MongoConfigurationException;
import com.mongodb.spi.dns.DnsClient;
import com.mongodb.spi.dns.DnsException;
import io.quarkus.arc.Arc;
import io.quarkus.mongodb.runtime.dns.MongoDnsClientProvider;
import io.quarkus.runtime.annotations.RegisterForReflection;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.dns.SrvRecord;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@RegisterForReflection
public class MongoDnsClient
implements DnsClient {
    private static final String BASE_CONFIG_NAME = "quarkus.mongodb.";
    public static final String DNS_LOOKUP_TIMEOUT = "quarkus.mongodb.dns.lookup-timeout";
    public static final String NATIVE_DNS_LOOKUP_TIMEOUT = "quarkus.mongodb.native.dns.lookup-timeout";
    public static final String DNS_LOG_ACTIVITY = "quarkus.mongodb.dns.log-activity";
    public static final String NATIVE_DNS_LOG_ACTIVITY = "quarkus.mongodb.native.dns.log-activity";
    public static final String DNS_SERVER = "quarkus.mongodb.dns.server-host";
    public static final String NATIVE_DNS_SERVER = "quarkus.mongodb.native.dns.server-host";
    public static final String DNS_SERVER_PORT = "quarkus.mongodb.dns.server-port";
    public static final String NATIVE_DNS_SERVER_PORT = "quarkus.mongodb.native.dns.server-port";
    private final Config config = ConfigProvider.getConfig();
    private final io.vertx.mutiny.core.dns.DnsClient dnsClient;

    MongoDnsClient() {
        Vertx vertx = (Vertx)Arc.container().instance(Vertx.class, new Annotation[0]).get();
        boolean activity = this.config.getOptionalValue(DNS_LOG_ACTIVITY, Boolean.class).orElse(false);
        String server = this.config.getOptionalValue(DNS_SERVER, String.class).orElseGet(() -> {
            List<String> list = MongoDnsClient.nameServers();
            if (!list.isEmpty()) {
                return list.get(0);
            }
            return null;
        });
        DnsClientOptions dnsClientOptions = new DnsClientOptions().setLogActivity(activity);
        if (server != null) {
            int port = this.config.getOptionalValue(DNS_SERVER_PORT, Integer.class).orElse(53);
            dnsClientOptions.setHost(server).setPort(port);
        }
        this.dnsClient = vertx.createDnsClient(dnsClientOptions);
    }

    private static List<String> nameServers() {
        Path conf = Paths.get("/etc/resolv.conf", new String[0]);
        List<Object> nameServers = null;
        if (Files.exists(conf, new LinkOption[0])) {
            try (Stream<String> lines = Files.lines(conf);){
                nameServers = lines.filter(line -> line.startsWith("nameserver")).map(line -> line.split(" ")[1]).collect(Collectors.toList());
            }
            catch (IOException | ArrayIndexOutOfBoundsException e) {
                Logger.getLogger(MongoDnsClientProvider.class).info((Object)"Unable to read the /etc/resolv.conf file", (Throwable)e);
                nameServers = new ArrayList();
            }
        }
        return nameServers;
    }

    public List<String> getResourceRecordData(String name, String type) throws DnsException {
        switch (type) {
            case "SRV": {
                return this.resolveSrvRequest(name);
            }
            case "TXT": {
                return this.resolveTxtRequest(name);
            }
        }
        throw new IllegalArgumentException("Unknown DNS record type: " + type);
    }

    private List<String> resolveSrvRequest(String srvHost) {
        ArrayList<String> hosts = new ArrayList<String>();
        Duration timeout = this.config.getOptionalValue(DNS_LOOKUP_TIMEOUT, Duration.class).orElse(Duration.ofSeconds(5L));
        try {
            List srvRecords = (List)this.dnsClient.resolveSRV(srvHost).await().atMost(timeout);
            if (srvRecords.isEmpty()) {
                throw new MongoConfigurationException("No SRV records available for host " + srvHost);
            }
            for (SrvRecord srvRecord : srvRecords) {
                String resolvedHost = srvRecord.target().endsWith(".") ? srvRecord.target().substring(0, srvRecord.target().length() - 1) : srvRecord.target();
                hosts.add(String.format("%d %d %d %s", srvRecord.priority(), srvRecord.weight(), srvRecord.port(), resolvedHost));
            }
        }
        catch (Throwable e) {
            throw new MongoConfigurationException("Unable to look up SRV record for host " + srvHost, e);
        }
        return hosts;
    }

    public List<String> resolveTxtRequest(String host) {
        try {
            Duration timeout = this.config.getOptionalValue(DNS_LOOKUP_TIMEOUT, Duration.class).orElse(Duration.ofSeconds(5L));
            return (List)this.dnsClient.resolveTXT(host).await().atMost(timeout);
        }
        catch (Throwable e) {
            throw new MongoConfigurationException("Unable to look up TXT record for host " + host, e);
        }
    }
}

