/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime.graal;

import com.mongodb.ConnectionString;
import com.mongodb.MongoCompressor;
import com.mongodb.lang.Nullable;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@TargetClass(value=ConnectionString.class)
final class ConnectionStringSubstitution {
    ConnectionStringSubstitution() {
    }

    @Substitute
    private List<MongoCompressor> buildCompressors(String compressors, @Nullable Integer zlibCompressionLevel) {
        ArrayList<MongoCompressor> compressorsList = new ArrayList<MongoCompressor>();
        for (String cur : compressors.split(",")) {
            if (cur.equals("zlib")) {
                MongoCompressor zlibCompressor = MongoCompressor.createZlibCompressor();
                zlibCompressor = zlibCompressor.withProperty("LEVEL", (Object)zlibCompressionLevel);
                compressorsList.add(zlibCompressor);
                continue;
            }
            if (cur.equals("snappy") || cur.isEmpty()) continue;
            throw new IllegalArgumentException("Unsupported compressor '" + cur + "'");
        }
        return Collections.unmodifiableList(compressorsList);
    }
}

