/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.List;
import org.reactivestreams.Publisher;

class Wrappers {
    private Wrappers() {
    }

    static <T> Uni<T> toUni(Publisher<T> publisher) {
        Context context = Vertx.currentContext();
        Uni uni = Uni.createFrom().publisher(publisher);
        if (context != null) {
            return uni.emitOn(command -> context.runOnContext(x -> command.run()));
        }
        return uni;
    }

    static <T> Multi<T> toMulti(Publisher<T> publisher) {
        Context context = Vertx.currentContext();
        if (context != null) {
            return Multi.createFrom().publisher(publisher).emitOn(command -> context.runOnContext(x -> command.run()));
        }
        return Multi.createFrom().publisher(publisher);
    }

    static <T> Uni<List<T>> toUniOfList(Publisher<T> publisher) {
        Context context = Vertx.currentContext();
        Uni uni = Multi.createFrom().publisher(publisher).collect().asList();
        if (context != null) {
            return uni.emitOn(command -> context.runOnContext(x -> command.run()));
        }
        return uni;
    }
}

