/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime.dns;

import io.quarkus.arc.Arc;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.dns.DnsClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public abstract class DnsClientProducer {
    public static final String FLAG = "quarkus.mongodb.native.dns.use-vertx-dns-resolver";
    private static final String DNS_SERVER = "quarkus.mongodb.native.dns.server-host";
    private static final String DNS_SERVER_PORT = "quarkus.mongodb.native.dns.server-port";
    private static final String DNS_SERVER_ACTIVITY = "quarkus.mongodb.native.dns.log-activity";
    public static final String LOOKUP_TIMEOUT = "quarkus.mongodb.native.dns.lookup-timeout";
    private static DnsClient client;

    public static synchronized DnsClient createDnsClient() {
        Config config = ConfigProvider.getConfig();
        if (client == null) {
            Vertx vertx = (Vertx)Arc.container().instance(Vertx.class, new Annotation[0]).get();
            boolean activity = config.getOptionalValue(DNS_SERVER_ACTIVITY, Boolean.class).orElse(false);
            String server = config.getOptionalValue(DNS_SERVER, String.class).orElseGet(() -> {
                List<String> list = DnsClientProducer.nameServers();
                if (!list.isEmpty()) {
                    return list.get(0);
                }
                return null;
            });
            if (server != null) {
                int port = config.getOptionalValue(DNS_SERVER_PORT, Integer.class).orElse(53);
                client = vertx.createDnsClient(new DnsClientOptions().setLogActivity(activity).setPort(port).setHost(server));
            } else {
                client = vertx.createDnsClient(new DnsClientOptions().setLogActivity(activity));
            }
        }
        return client;
    }

    public static List<String> nameServers() {
        String file = "/etc/resolv.conf";
        if (!new File(file).isFile()) {
            return Collections.emptyList();
        }
        Path p = Paths.get(file, new String[0]);
        ArrayList<String> nameServers = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(p, new OpenOption[0])));){
            String line;
            while ((line = br.readLine()) != null) {
                String token;
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens() || !(token = st.nextToken()).startsWith("nameserver")) continue;
                nameServers.add(st.nextToken().trim());
            }
        }
        catch (IOException e) {
            Logger.getLogger(DnsClientProducer.class).error((Object)"Unable to read the /etc/resolv.conf file", (Throwable)e);
        }
        return nameServers;
    }
}

