/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.tracing;

import com.mongodb.event.CommandEvent;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.jboss.logging.Logger;

public class MongoTracingCommandListener
implements CommandListener {
    private static final Logger LOGGER = Logger.getLogger(MongoTracingCommandListener.class);
    private static final String KEY = "mongodb.command";
    private final Map<Integer, ContextEvent> requestMap = new ConcurrentHashMap<Integer, ContextEvent>();
    private final Instrumenter<CommandStartedEvent, Void> instrumenter;

    @Inject
    public MongoTracingCommandListener(OpenTelemetry openTelemetry) {
        SpanNameExtractor spanNameExtractor = CommandEvent::getCommandName;
        this.instrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"quarkus-mongodb-client", (SpanNameExtractor)spanNameExtractor).addAttributesExtractor((AttributesExtractor)new CommandEventAttrExtractor()).buildInstrumenter(SpanKindExtractor.alwaysClient());
        LOGGER.debugf("MongoTracingCommandListener created", new Object[0]);
    }

    public void commandStarted(CommandStartedEvent event) {
        LOGGER.tracef("commandStarted event %s", (Object)event.getCommandName());
        Context parentContext = Context.current();
        if (this.instrumenter.shouldStart(parentContext, (Object)event)) {
            Context context = this.instrumenter.start(parentContext, (Object)event);
            this.requestMap.put(event.getRequestId(), new ContextEvent(context, event));
        }
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        LOGGER.tracef("commandSucceeded event %s", (Object)event.getCommandName());
        ContextEvent contextEvent = this.requestMap.remove(event.getRequestId());
        if (contextEvent != null) {
            this.instrumenter.end(contextEvent.context(), (Object)contextEvent.commandEvent(), null, null);
        }
    }

    public void commandFailed(CommandFailedEvent event) {
        LOGGER.tracef("commandFailed event %s", (Object)event.getCommandName());
        ContextEvent contextEvent = this.requestMap.remove(event.getRequestId());
        if (contextEvent != null) {
            this.instrumenter.end(contextEvent.context(), (Object)contextEvent.commandEvent(), null, event.getThrowable());
        }
    }

    private static class CommandEventAttrExtractor
    implements AttributesExtractor<CommandStartedEvent, Void> {
        private CommandEventAttrExtractor() {
        }

        public void onStart(AttributesBuilder attributesBuilder, Context context, CommandStartedEvent commandStartedEvent) {
            attributesBuilder.put(MongoTracingCommandListener.KEY, commandStartedEvent.getCommand().toJson());
        }

        public void onEnd(AttributesBuilder attributesBuilder, Context context, CommandStartedEvent commandStartedEvent, @Nullable Void unused, @Nullable Throwable throwable) {
        }
    }

    private record ContextEvent(Context context, CommandStartedEvent commandEvent) {
    }
}

