/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime;

import com.mongodb.RequestContext;
import io.opentelemetry.context.Context;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class MongoRequestContext
implements RequestContext {
    public static final String OTEL_CONTEXT_KEY = "otel.context.current";
    private final Map<Object, Object> valuesMap = new ConcurrentHashMap<Object, Object>();

    public MongoRequestContext(Context currentContext) {
        if (currentContext != null) {
            this.valuesMap.put(OTEL_CONTEXT_KEY, currentContext);
        }
    }

    public <T> T get(Object key) {
        return (T)this.valuesMap.get(key);
    }

    public boolean hasKey(Object key) {
        return this.valuesMap.containsKey(key);
    }

    public boolean isEmpty() {
        return this.valuesMap.isEmpty();
    }

    public void put(Object key, Object value) {
        this.valuesMap.put(key, value);
    }

    public void delete(Object key) {
        this.valuesMap.remove(key);
    }

    public int size() {
        return this.valuesMap.size();
    }

    public Stream<Map.Entry<Object, Object>> stream() {
        return this.valuesMap.entrySet().stream();
    }
}

