/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.mongodb.panache.deployment.BasePanacheMongoResourceProcessor;
import io.quarkus.mongodb.panache.deployment.ByteCodeType;
import io.quarkus.mongodb.panache.deployment.TypeBundle;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.visitors.PanacheEntityClassVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class PanacheMongoEntityClassVisitor
extends PanacheEntityClassVisitor<EntityField> {
    private static final ByteCodeType CLASS = new ByteCodeType(Class.class);
    private final TypeBundle typeBundle;

    public PanacheMongoEntityClassVisitor(String className, ClassVisitor outputClassVisitor, MetamodelInfo<EntityModel<EntityField>> modelInfo, ClassInfo panacheEntityBaseClassInfo, ClassInfo entityInfo, List<PanacheMethodCustomizer> methodCustomizers, TypeBundle typeBundle) {
        super(className, outputClassVisitor, modelInfo, panacheEntityBaseClassInfo, entityInfo, methodCustomizers);
        this.typeBundle = typeBundle;
    }

    protected void generateMethod(MethodInfo method, AnnotationValue targetReturnTypeErased) {
        String descriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> null);
        String signature = AsmUtil.getSignature((MethodInfo)method, name -> null);
        List parameters = method.parameters();
        MethodVisitor mv = super.visitMethod(4105, method.name(), descriptor, signature, null);
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        mv.visitCode();
        for (PanacheMethodCustomizer customizer : this.methodCustomizers) {
            customizer.customize(this.thisClass, method, mv);
        }
        mv.visitFieldInsn(178, this.thisClass.getInternalName(), "operations", this.typeBundle.operations().descriptor());
        this.injectModel(mv);
        for (int i = 0; i < parameters.size(); ++i) {
            mv.visitIntInsn(25, i);
        }
        this.invokeOperation(mv, method, method.parameters());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void invokeOperation(MethodVisitor mv, MethodInfo method, List<Type> parameters) {
        Function<String, String> argMapper = type -> null;
        AnnotationInstance bridge = method.annotation(PanacheEntityEnhancer.DOTNAME_GENERATE_BRIDGE);
        AnnotationValue targetReturnTypeErased = bridge.value("targetReturnTypeErased");
        boolean erased = targetReturnTypeErased != null && targetReturnTypeErased.asBoolean();
        StringJoiner joiner = new StringJoiner("", "(", ")");
        joiner.add(CLASS.descriptor());
        for (Type parameter : parameters) {
            joiner.add(AsmUtil.getDescriptor((Type)parameter, argMapper));
        }
        List<String> names = Arrays.asList(this.typeBundle.queryType().dotName().toString(), this.typeBundle.updateType().dotName().toString());
        String operationDescriptor = joiner + (erased || names.contains(method.returnType().name().toString()) ? BasePanacheMongoResourceProcessor.OBJECT_SIGNATURE : AsmUtil.getDescriptor((Type)method.returnType(), argMapper));
        mv.visitMethodInsn(182, this.typeBundle.operations().internalName(), method.name(), operationDescriptor, false);
        if (method.returnType().kind() != Type.Kind.PRIMITIVE) {
            Type type2 = method.returnType();
            String cast = erased ? this.thisClass.getInternalName() : type2.name().toString().replace('.', '/');
            mv.visitTypeInsn(192, cast);
        }
        mv.visitInsn(AsmUtil.getReturnInstruction((Type)method.returnType()));
    }

    protected String getPanacheOperationsInternalName() {
        return this.typeBundle.operations().internalName();
    }

    protected void generateAccessorSetField(MethodVisitor mv, EntityField field) {
        mv.visitFieldInsn(181, this.thisClass.getInternalName(), field.name, field.descriptor);
    }

    protected void generateAccessorGetField(MethodVisitor mv, EntityField field) {
        mv.visitFieldInsn(180, this.thisClass.getInternalName(), field.name, field.descriptor);
    }
}

