/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.deployment;

import io.quarkus.deployment.util.AsmUtil;
import java.util.StringJoiner;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.objectweb.asm.Type;

public class ByteCodeType {
    private final Type type;

    public ByteCodeType(Type type) {
        this.type = type;
    }

    public ByteCodeType(Class<?> type) {
        this.type = Type.getType(type);
    }

    public ByteCodeType(org.jboss.jandex.Type type) {
        String typeDescriptor = type.kind() == Type.Kind.PRIMITIVE ? type.toString() : "L" + type.name().toString().replace('.', '/') + ";";
        this.type = Type.getType((String)typeDescriptor);
    }

    public String descriptor() {
        return this.type.getDescriptor();
    }

    public DotName dotName() {
        return DotName.createSimple((String)this.type.getClassName());
    }

    public String internalName() {
        return this.type.getInternalName();
    }

    public String toString() {
        return new StringJoiner(", ", ByteCodeType.class.getSimpleName() + "[", "]").add(this.type.toString()).toString();
    }

    public Type type() {
        return this.type;
    }

    public ByteCodeType unbox() {
        return new ByteCodeType(AsmUtil.WRAPPER_TO_PRIMITIVE.getOrDefault(this.type, this.type));
    }
}

