/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.runtime;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.DeleteResult;
import io.quarkus.mongodb.panache.MongoEntity;
import io.quarkus.mongodb.panache.binder.NativeQueryBinder;
import io.quarkus.mongodb.panache.binder.PanacheQlQueryBinder;
import io.quarkus.mongodb.panache.runtime.BeanUtils;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.jboss.logging.Logger;

public abstract class MongoOperations<QueryType, UpdateType> {
    public final String ID = "_id";
    private static final Logger LOGGER = Logger.getLogger(MongoOperations.class);
    private final Map<String, String> defaultDatabaseName = new ConcurrentHashMap<String, String>();

    protected abstract QueryType createQuery(MongoCollection<?> var1, Document var2, Document var3);

    protected abstract UpdateType createUpdate(MongoCollection var1, Class<?> var2, Document var3);

    protected abstract List<?> list(QueryType var1);

    protected abstract Stream<?> stream(QueryType var1);

    public void persist(Object entity) {
        MongoCollection collection = this.mongoCollection(entity);
        this.persist(collection, entity);
    }

    public void persist(Iterable<?> entities) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object entity : entities) {
            objects.add(entity);
        }
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = this.mongoCollection(firstEntity);
            this.persist(collection, objects);
        }
    }

    public void persist(Object firstEntity, Object ... entities) {
        MongoCollection collection = this.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            this.persist(collection, firstEntity);
        } else {
            ArrayList<Object> entityList = new ArrayList<Object>();
            entityList.add(firstEntity);
            entityList.addAll(Arrays.asList(entities));
            this.persist(collection, entityList);
        }
    }

    public void persist(Stream<?> entities) {
        List<Object> objects = entities.collect(Collectors.toList());
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = this.mongoCollection(firstEntity);
            this.update(collection, objects);
        }
    }

    public void update(Object entity) {
        MongoCollection collection = this.mongoCollection(entity);
        this.update(collection, entity);
    }

    public void update(Iterable<?> entities) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object entity : entities) {
            objects.add(entity);
        }
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = this.mongoCollection(firstEntity);
            this.update(collection, objects);
        }
    }

    public void update(Object firstEntity, Object ... entities) {
        MongoCollection collection = this.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            this.update(collection, firstEntity);
        } else {
            ArrayList<Object> entityList = new ArrayList<Object>();
            entityList.add(firstEntity);
            entityList.addAll(Arrays.asList(entities));
            this.update(collection, entityList);
        }
    }

    public void update(Stream<?> entities) {
        List<Object> objects = entities.collect(Collectors.toList());
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = this.mongoCollection(firstEntity);
            this.update(collection, objects);
        }
    }

    public void persistOrUpdate(Object entity) {
        MongoCollection collection = this.mongoCollection(entity);
        this.persistOrUpdate(collection, entity);
    }

    public void persistOrUpdate(Iterable<?> entities) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object entity : entities) {
            objects.add(entity);
        }
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = this.mongoCollection(firstEntity);
            this.persistOrUpdate(collection, objects);
        }
    }

    public void persistOrUpdate(Object firstEntity, Object ... entities) {
        MongoCollection collection = this.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            this.persistOrUpdate(collection, firstEntity);
        } else {
            ArrayList<Object> entityList = new ArrayList<Object>();
            entityList.add(firstEntity);
            entityList.addAll(Arrays.asList(entities));
            this.persistOrUpdate(collection, entityList);
        }
    }

    public void persistOrUpdate(Stream<?> entities) {
        List<Object> objects = entities.collect(Collectors.toList());
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = this.mongoCollection(firstEntity);
            this.persistOrUpdate(collection, objects);
        }
    }

    public void delete(Object entity) {
        MongoCollection collection = this.mongoCollection(entity);
        BsonDocument document = this.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)"_id");
        BsonDocument query = new BsonDocument().append("_id", id);
        collection.deleteOne((Bson)query);
    }

    public MongoCollection mongoCollection(Class<?> entityClass) {
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        MongoDatabase database = this.mongoDatabase(mongoEntity);
        if (mongoEntity != null && !mongoEntity.collection().isEmpty()) {
            return database.getCollection(mongoEntity.collection(), entityClass);
        }
        return database.getCollection(entityClass.getSimpleName(), entityClass);
    }

    public MongoDatabase mongoDatabase(Class<?> entityClass) {
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        return this.mongoDatabase(mongoEntity);
    }

    private void persist(MongoCollection collection, Object entity) {
        collection.insertOne(entity);
    }

    private void persist(MongoCollection collection, List<Object> entities) {
        collection.insertMany(entities);
    }

    private void update(MongoCollection collection, Object entity) {
        BsonDocument document = this.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)"_id");
        BsonDocument query = new BsonDocument().append("_id", id);
        collection.replaceOne((Bson)query, entity);
    }

    private void update(MongoCollection collection, List<Object> entities) {
        for (Object entity : entities) {
            this.update(collection, entity);
        }
    }

    private void persistOrUpdate(MongoCollection collection, Object entity) {
        BsonDocument document = this.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)"_id");
        if (id == null) {
            collection.insertOne(entity);
        } else {
            BsonDocument query = new BsonDocument().append("_id", id);
            collection.replaceOne((Bson)query, entity, new ReplaceOptions().upsert(true));
        }
    }

    private void persistOrUpdate(MongoCollection collection, List<Object> entities) {
        ArrayList<Object> bulk = new ArrayList<Object>();
        for (Object entity : entities) {
            BsonDocument document = this.getBsonDocument(collection, entity);
            BsonValue id = document.get((Object)"_id");
            if (id == null) {
                bulk.add(new InsertOneModel(entity));
                continue;
            }
            BsonDocument query = new BsonDocument().append("_id", id);
            bulk.add(new ReplaceOneModel((Bson)query, entity, new ReplaceOptions().upsert(true)));
        }
        collection.bulkWrite(bulk);
    }

    private BsonDocument getBsonDocument(MongoCollection collection, Object entity) {
        BsonDocument document = new BsonDocument();
        Codec codec = collection.getCodecRegistry().get(entity.getClass());
        codec.encode((BsonWriter)new BsonDocumentWriter(document), entity, EncoderContext.builder().build());
        return document;
    }

    private MongoCollection mongoCollection(Object entity) {
        Class<?> entityClass = entity.getClass();
        return this.mongoCollection(entityClass);
    }

    private MongoDatabase mongoDatabase(MongoEntity entity) {
        MongoClient mongoClient = BeanUtils.clientFromArc(entity, MongoClient.class, false);
        if (entity != null && !entity.database().isEmpty()) {
            return mongoClient.getDatabase(entity.database());
        }
        String databaseName = this.getDefaultDatabaseName(entity);
        return mongoClient.getDatabase(databaseName);
    }

    private String getDefaultDatabaseName(final MongoEntity entity) {
        return this.defaultDatabaseName.computeIfAbsent(BeanUtils.beanName(entity), new Function<String, String>(){

            @Override
            public String apply(String beanName) {
                return BeanUtils.getDatabaseName(entity, beanName);
            }
        });
    }

    public Object findById(Class<?> entityClass, Object id) {
        MongoCollection collection = this.mongoCollection(entityClass);
        return collection.find((Bson)new Document("_id", id)).first();
    }

    public Optional findByIdOptional(Class<?> entityClass, Object id) {
        return Optional.ofNullable(this.findById(entityClass, id));
    }

    public QueryType find(Class<?> entityClass, String query, Object ... params) {
        return this.find(entityClass, query, null, params);
    }

    public QueryType find(Class<?> entityClass, String query, Sort sort, Object ... params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        Document docSort = this.sortToDocument(sort);
        MongoCollection collection = this.mongoCollection(entityClass);
        return this.createQuery(collection, docQuery, docSort);
    }

    public String bindFilter(Class<?> clazz, String query, Object[] params) {
        String bindQuery = this.bindQuery(clazz, query, params);
        LOGGER.debug((Object)bindQuery);
        return bindQuery;
    }

    public String bindFilter(Class<?> clazz, String query, Map<String, Object> params) {
        String bindQuery = this.bindQuery(clazz, query, params);
        LOGGER.debug((Object)bindQuery);
        return bindQuery;
    }

    String bindUpdate(Class<?> clazz, String query, Object[] params) {
        String bindUpdate = this.bindQuery(clazz, query, params);
        if (!bindUpdate.contains("$set")) {
            bindUpdate = "{'$set':" + bindUpdate + "}";
        }
        LOGGER.debug((Object)bindUpdate);
        return bindUpdate;
    }

    String bindUpdate(Class<?> clazz, String query, Map<String, Object> params) {
        String bindUpdate = this.bindQuery(clazz, query, params);
        if (!bindUpdate.contains("$set")) {
            bindUpdate = "{'$set':" + bindUpdate + "}";
        }
        LOGGER.debug((Object)bindUpdate);
        return bindUpdate;
    }

    private String bindQuery(Class<?> clazz, String query, Object[] params) {
        String bindQuery = null;
        bindQuery = query.charAt(0) == '{' ? NativeQueryBinder.bindQuery(query, params) : PanacheQlQueryBinder.bindQuery(clazz, query, params);
        return bindQuery;
    }

    private String bindQuery(Class<?> clazz, String query, Map<String, Object> params) {
        String bindQuery = null;
        bindQuery = query.charAt(0) == '{' ? NativeQueryBinder.bindQuery(query, params) : PanacheQlQueryBinder.bindQuery(clazz, query, params);
        return bindQuery;
    }

    public QueryType find(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.find(entityClass, query, null, params);
    }

    public QueryType find(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        Document docSort = this.sortToDocument(sort);
        MongoCollection collection = this.mongoCollection(entityClass);
        return this.createQuery(collection, docQuery, docSort);
    }

    public QueryType find(Class<?> entityClass, String query, Parameters params) {
        return this.find(entityClass, query, null, params.map());
    }

    public QueryType find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.find(entityClass, query, sort, params.map());
    }

    public QueryType find(Class<?> entityClass, Document query, Sort sort) {
        MongoCollection collection = this.mongoCollection(entityClass);
        Document sortDoc = this.sortToDocument(sort);
        return this.createQuery(collection, query, sortDoc);
    }

    public QueryType find(Class<?> entityClass, Document query, Document sort) {
        MongoCollection collection = this.mongoCollection(entityClass);
        return this.createQuery(collection, query, sort);
    }

    public QueryType find(Class<?> entityClass, Document query) {
        return this.find(entityClass, query, (Document)null);
    }

    public List<?> list(Class<?> entityClass, String query, Object ... params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public List<?> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public List<?> list(Class<?> entityClass, String query, Parameters params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public List<?> list(Class<?> entityClass, Document query) {
        return this.list(this.find(entityClass, query));
    }

    public List<?> list(Class<?> entityClass, Document query, Document sort) {
        return this.list(this.find(entityClass, query, sort));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Object ... params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Parameters params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, Document query) {
        return this.stream(this.find(entityClass, query));
    }

    public Stream<?> stream(Class<?> entityClass, Document query, Document sort) {
        return this.stream(this.find(entityClass, query, sort));
    }

    public QueryType findAll(Class<?> entityClass) {
        MongoCollection collection = this.mongoCollection(entityClass);
        return this.createQuery(collection, null, null);
    }

    public QueryType findAll(Class<?> entityClass, Sort sort) {
        MongoCollection collection = this.mongoCollection(entityClass);
        Document sortDoc = this.sortToDocument(sort);
        return this.createQuery(collection, null, sortDoc);
    }

    private Document sortToDocument(Sort sort) {
        if (sort == null) {
            return null;
        }
        Document sortDoc = new Document();
        for (Sort.Column col : sort.getColumns()) {
            sortDoc.append(col.getName(), (Object)(col.getDirection() == Sort.Direction.Ascending ? 1 : -1));
        }
        return sortDoc;
    }

    public List<?> listAll(Class<?> entityClass) {
        return this.list(this.findAll(entityClass));
    }

    public List<?> listAll(Class<?> entityClass, Sort sort) {
        return this.list(this.findAll(entityClass, sort));
    }

    public Stream<?> streamAll(Class<?> entityClass) {
        return this.stream(this.findAll(entityClass));
    }

    public Stream<?> streamAll(Class<?> entityClass, Sort sort) {
        return this.stream(this.findAll(entityClass, sort));
    }

    public long count(Class<?> entityClass) {
        MongoCollection collection = this.mongoCollection(entityClass);
        return collection.countDocuments();
    }

    public long count(Class<?> entityClass, String query, Object ... params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = this.mongoCollection(entityClass);
        return collection.countDocuments((Bson)docQuery);
    }

    public long count(Class<?> entityClass, String query, Map<String, Object> params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = this.mongoCollection(entityClass);
        return collection.countDocuments((Bson)docQuery);
    }

    public long count(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params.map());
    }

    public long count(Class<?> entityClass, Document query) {
        MongoCollection collection = this.mongoCollection(entityClass);
        return collection.countDocuments((Bson)query);
    }

    public long deleteAll(Class<?> entityClass) {
        MongoCollection collection = this.mongoCollection(entityClass);
        return collection.deleteMany((Bson)new Document()).getDeletedCount();
    }

    public boolean deleteById(Class<?> entityClass, Object id) {
        Document query;
        MongoCollection collection = this.mongoCollection(entityClass);
        DeleteResult results = collection.deleteOne((Bson)(query = new Document().append("_id", id)));
        return results.getDeletedCount() == 1L;
    }

    public long delete(Class<?> entityClass, String query, Object ... params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = this.mongoCollection(entityClass);
        return collection.deleteMany((Bson)docQuery).getDeletedCount();
    }

    public long delete(Class<?> entityClass, String query, Map<String, Object> params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = this.mongoCollection(entityClass);
        return collection.deleteMany((Bson)docQuery).getDeletedCount();
    }

    public long delete(Class<?> entityClass, String query, Parameters params) {
        return this.delete(entityClass, query, params.map());
    }

    public long delete(Class<?> entityClass, Document query) {
        MongoCollection collection = this.mongoCollection(entityClass);
        return collection.deleteMany((Bson)query).getDeletedCount();
    }

    public UpdateType update(Class<?> entityClass, String update, Map<String, Object> params) {
        return this.executeUpdate(entityClass, update, params);
    }

    public UpdateType update(Class<?> entityClass, String update, Parameters params) {
        return this.update(entityClass, update, params.map());
    }

    public UpdateType update(Class<?> entityClass, String update, Object ... params) {
        return this.executeUpdate(entityClass, update, params);
    }

    private UpdateType executeUpdate(Class<?> entityClass, String update, Object ... params) {
        String bindUpdate = this.bindUpdate(entityClass, update, params);
        Document docUpdate = Document.parse((String)bindUpdate);
        return this.createUpdate(this.mongoCollection(entityClass), entityClass, docUpdate);
    }

    private UpdateType executeUpdate(Class<?> entityClass, String update, Map<String, Object> params) {
        String bindUpdate = this.bindUpdate(entityClass, update, params);
        Document docUpdate = Document.parse((String)bindUpdate);
        return this.createUpdate(this.mongoCollection(entityClass), entityClass, docUpdate);
    }

    public IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses");
    }
}

