/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.runtime;

import com.mongodb.client.MongoCollection;
import io.quarkus.mongodb.panache.PanacheUpdate;
import io.quarkus.mongodb.panache.runtime.MongoOperations;
import io.quarkus.panache.common.Parameters;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class PanacheUpdateImpl
implements PanacheUpdate {
    private MongoOperations operations;
    private Class<?> entityClass;
    private Bson update;
    private MongoCollection collection;

    public PanacheUpdateImpl(MongoOperations operations, Class<?> entityClass, Bson update, MongoCollection collection) {
        this.operations = operations;
        this.entityClass = entityClass;
        this.update = update;
        this.collection = collection;
    }

    @Override
    public long where(String query, Object ... params) {
        String bindQuery = this.operations.bindFilter(this.entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        return this.collection.updateMany((Bson)docQuery, this.update).getModifiedCount();
    }

    @Override
    public long where(String query, Map<String, Object> params) {
        String bindQuery = this.operations.bindFilter(this.entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        return this.collection.updateMany((Bson)docQuery, this.update).getModifiedCount();
    }

    @Override
    public long where(String query, Parameters params) {
        return this.where(query, params.map());
    }

    @Override
    public long all() {
        return this.collection.updateMany((Bson)new BsonDocument(), this.update).getModifiedCount();
    }
}

