/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.common.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.mongodb.panache.common.MongoEntity;
import io.quarkus.mongodb.runtime.MongoClientBeanUtil;
import io.quarkus.mongodb.runtime.MongoClientConfig;
import io.quarkus.mongodb.runtime.MongoClients;
import java.lang.annotation.Annotation;
import javax.inject.Named;

public final class BeanUtils {
    private BeanUtils() {
    }

    public static String beanName(io.quarkus.mongodb.panache.MongoEntity legacyEntity, MongoEntity entity) {
        if (entity != null && !entity.clientName().isEmpty()) {
            return entity.clientName();
        }
        if (legacyEntity != null && !legacyEntity.clientName().isEmpty()) {
            return legacyEntity.clientName();
        }
        return "<default>";
    }

    public static <T> T clientFromArc(io.quarkus.mongodb.panache.MongoEntity legacyEntity, MongoEntity entity, Class<T> clientClass, boolean isReactive) {
        Object mongoClient = Arc.container().instance(clientClass, new Annotation[]{MongoClientBeanUtil.clientLiteral((String)BeanUtils.beanName(legacyEntity, entity), (boolean)isReactive)}).get();
        if (mongoClient != null) {
            return (T)mongoClient;
        }
        if ((entity == null || entity.clientName().isEmpty()) && (legacyEntity == null || legacyEntity.clientName().isEmpty())) {
            for (InstanceHandle handle : Arc.container().select(clientClass, new Annotation[0]).handles()) {
                InjectableBean bean = handle.getBean();
                boolean hasNamed = false;
                for (Annotation qualifier : bean.getQualifiers()) {
                    if (!qualifier.annotationType().equals(Named.class)) continue;
                    hasNamed = true;
                }
                if (hasNamed) continue;
                return (T)handle.get();
            }
            throw new IllegalStateException(String.format("Unable to find default %s bean", clientClass.getSimpleName()));
        }
        if (entity != null && !entity.clientName().isEmpty()) {
            throw new IllegalStateException(String.format("Unable to find %s bean for entity %s", clientClass.getSimpleName(), entity));
        }
        throw new IllegalStateException(String.format("Unable to find %s bean for entity %s", clientClass.getSimpleName(), legacyEntity));
    }

    public static String getDatabaseName(io.quarkus.mongodb.panache.MongoEntity legacyEntity, MongoEntity mongoEntity, String clientBeanName) {
        MongoClients mongoClients = (MongoClients)Arc.container().instance(MongoClients.class, new Annotation[0]).get();
        MongoClientConfig matchingMongoClientConfig = mongoClients.getMatchingMongoClientConfig(clientBeanName);
        if (matchingMongoClientConfig.database.isPresent()) {
            return (String)matchingMongoClientConfig.database.get();
        }
        if (!clientBeanName.equals("<default>")) {
            MongoClientConfig defaultMongoClientConfig = mongoClients.getMatchingMongoClientConfig("<default>");
            if (defaultMongoClientConfig.database.isPresent()) {
                return (String)defaultMongoClientConfig.database.get();
            }
        }
        if (legacyEntity == null && mongoEntity == null) {
            throw new IllegalArgumentException("The database property was not configured for the default Mongo Client (via 'quarkus.mongodb.database'");
        }
        if (legacyEntity != null && legacyEntity.clientName().isEmpty()) {
            throw new IllegalArgumentException("The database attribute was not set for the @MongoEntity annotation and neither was the database property configured for the default Mongo Client (via 'quarkus.mongodb.database')");
        }
        if (mongoEntity != null && mongoEntity.clientName().isEmpty()) {
            throw new IllegalArgumentException("The database attribute was not set for the @MongoEntity annotation and neither was the database property configured for the default Mongo Client (via 'quarkus.mongodb.database')");
        }
        if (legacyEntity != null) {
            throw new IllegalArgumentException(String.format("The database attribute was not set for the @MongoEntity annotation neither was the database property configured for the named Mongo Client (via 'quarkus.mongodb.%s.database')", legacyEntity.clientName()));
        }
        throw new IllegalArgumentException(String.format("The database attribute was not set for the @MongoEntity annotation neither was the database property configured for the named Mongo Client (via 'quarkus.mongodb.%s.database')", mongoEntity.clientName()));
    }
}

