/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.common.runtime;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.DeleteResult;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.mongodb.panache.binder.NativeQueryBinder;
import io.quarkus.mongodb.panache.binder.PanacheQlQueryBinder;
import io.quarkus.mongodb.panache.common.MongoEntity;
import io.quarkus.mongodb.panache.common.runtime.BeanUtils;
import io.quarkus.mongodb.panache.transaction.MongoTransactionException;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.jboss.logging.Logger;

public abstract class MongoOperations<QueryType, UpdateType> {
    public static final String ID = "_id";
    public static final Object SESSION_KEY = new Object();
    private static final Logger LOGGER = Logger.getLogger(MongoOperations.class);
    private static final List<String> UPDATE_OPERATORS = Arrays.asList("$currentDate", "$inc", "$min", "$max", "$mul", "$rename", "$set", "$setOnInsert", "$unset", "$addToSet", "$pop", "$pull", "$push", "$pullAll", "$each", "$position", "$slice", "$sort", "$bit");
    private final Map<String, String> defaultDatabaseName = new ConcurrentHashMap<String, String>();

    protected abstract QueryType createQuery(MongoCollection<?> var1, ClientSession var2, Document var3, Document var4);

    protected abstract UpdateType createUpdate(MongoCollection var1, Class<?> var2, Document var3);

    protected abstract List<?> list(QueryType var1);

    protected abstract Stream<?> stream(QueryType var1);

    public void persist(Object entity) {
        MongoCollection collection = this.mongoCollection(entity);
        this.persist(collection, entity);
    }

    public void persist(Iterable<?> entities) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object entity : entities) {
            objects.add(entity);
        }
        this.persist((List<Object>)objects);
    }

    public void persist(Object firstEntity, Object ... entities) {
        if (entities == null || entities.length == 0) {
            MongoCollection collection = this.mongoCollection(firstEntity);
            this.persist(collection, firstEntity);
        } else {
            ArrayList<Object> entityList = new ArrayList<Object>();
            entityList.add(firstEntity);
            entityList.addAll(Arrays.asList(entities));
            this.persist((List<Object>)entityList);
        }
    }

    public void persist(Stream<?> entities) {
        List<Object> objects = entities.collect(Collectors.toList());
        this.persist(objects);
    }

    public void update(Object entity) {
        MongoCollection collection = this.mongoCollection(entity);
        this.update(collection, entity);
    }

    public void update(Iterable<?> entities) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object entity : entities) {
            objects.add(entity);
        }
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = this.mongoCollection(firstEntity);
            this.update(collection, objects);
        }
    }

    public void update(Object firstEntity, Object ... entities) {
        MongoCollection collection = this.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            this.update(collection, firstEntity);
        } else {
            ArrayList<Object> entityList = new ArrayList<Object>();
            entityList.add(firstEntity);
            entityList.addAll(Arrays.asList(entities));
            this.update(collection, entityList);
        }
    }

    public void update(Stream<?> entities) {
        List<Object> objects = entities.collect(Collectors.toList());
        if (objects.size() > 0) {
            Object firstEntity = objects.get(0);
            MongoCollection collection = this.mongoCollection(firstEntity);
            this.update(collection, objects);
        }
    }

    public void persistOrUpdate(Object entity) {
        MongoCollection collection = this.mongoCollection(entity);
        this.persistOrUpdate(collection, entity);
    }

    public void persistOrUpdate(Iterable<?> entities) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object entity : entities) {
            objects.add(entity);
        }
        this.persistOrUpdate((List<Object>)objects);
    }

    public void persistOrUpdate(Object firstEntity, Object ... entities) {
        MongoCollection collection = this.mongoCollection(firstEntity);
        if (entities == null || entities.length == 0) {
            this.persistOrUpdate(collection, firstEntity);
        } else {
            ArrayList<Object> entityList = new ArrayList<Object>();
            entityList.add(firstEntity);
            entityList.addAll(Arrays.asList(entities));
            this.persistOrUpdate((List<Object>)entityList);
        }
    }

    public void persistOrUpdate(Stream<?> entities) {
        List<Object> objects = entities.collect(Collectors.toList());
        this.persistOrUpdate(objects);
    }

    public void delete(Object entity) {
        MongoCollection collection = this.mongoCollection(entity);
        BsonDocument document = this.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)ID);
        BsonDocument query = new BsonDocument().append(ID, id);
        ClientSession session = this.getSession(entity);
        if (session == null) {
            collection.deleteOne((Bson)query);
        } else {
            collection.deleteOne(session, (Bson)query);
        }
    }

    public MongoCollection mongoCollection(Class<?> entityClass) {
        io.quarkus.mongodb.panache.MongoEntity legacyMongoEntity = entityClass.getAnnotation(io.quarkus.mongodb.panache.MongoEntity.class);
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        MongoDatabase database = this.mongoDatabase(legacyMongoEntity, mongoEntity);
        if (mongoEntity != null && !mongoEntity.collection().isEmpty()) {
            return database.getCollection(mongoEntity.collection(), entityClass);
        }
        if (legacyMongoEntity != null && !legacyMongoEntity.collection().isEmpty()) {
            return database.getCollection(legacyMongoEntity.collection(), entityClass);
        }
        return database.getCollection(entityClass.getSimpleName(), entityClass);
    }

    public MongoDatabase mongoDatabase(Class<?> entityClass) {
        io.quarkus.mongodb.panache.MongoEntity legacyMongoEntity = entityClass.getAnnotation(io.quarkus.mongodb.panache.MongoEntity.class);
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        return this.mongoDatabase(legacyMongoEntity, mongoEntity);
    }

    private void persist(MongoCollection collection, Object entity) {
        ClientSession session = this.getSession(entity);
        if (session == null) {
            collection.insertOne(entity);
        } else {
            collection.insertOne(session, entity);
        }
    }

    private void persist(List<Object> entities) {
        if (entities.size() > 0) {
            Object firstEntity = entities.get(0);
            MongoCollection collection = this.mongoCollection(firstEntity);
            ClientSession session = this.getSession(firstEntity);
            if (session == null) {
                collection.insertMany(entities);
            } else {
                collection.insertMany(session, entities);
            }
        }
    }

    private void update(MongoCollection collection, Object entity) {
        BsonDocument document = this.getBsonDocument(collection, entity);
        BsonValue id = document.get((Object)ID);
        BsonDocument query = new BsonDocument().append(ID, id);
        ClientSession session = this.getSession(entity);
        if (session == null) {
            collection.replaceOne((Bson)query, entity);
        } else {
            collection.replaceOne(session, (Bson)query, entity);
        }
    }

    private void update(MongoCollection collection, List<Object> entities) {
        for (Object entity : entities) {
            this.update(collection, entity);
        }
    }

    private void persistOrUpdate(MongoCollection collection, Object entity) {
        BsonDocument document = this.getBsonDocument(collection, entity);
        ClientSession session = this.getSession(entity);
        BsonValue id = document.get((Object)ID);
        if (id == null) {
            if (session == null) {
                collection.insertOne(entity);
            } else {
                collection.insertOne(session, entity);
            }
        } else {
            BsonDocument query = new BsonDocument().append(ID, id);
            if (session == null) {
                collection.replaceOne((Bson)query, entity, new ReplaceOptions().upsert(true));
            } else {
                collection.replaceOne(session, (Bson)query, entity, new ReplaceOptions().upsert(true));
            }
        }
    }

    private void persistOrUpdate(List<Object> entities) {
        if (entities.isEmpty()) {
            return;
        }
        Object firstEntity = entities.get(0);
        MongoCollection collection = this.mongoCollection(firstEntity);
        ClientSession session = this.getSession(firstEntity);
        ArrayList<Object> bulk = new ArrayList<Object>();
        for (Object entity : entities) {
            BsonDocument document = this.getBsonDocument(collection, entity);
            BsonValue id = document.get((Object)ID);
            if (id == null) {
                bulk.add(new InsertOneModel(entity));
                continue;
            }
            BsonDocument query = new BsonDocument().append(ID, id);
            bulk.add(new ReplaceOneModel((Bson)query, entity, new ReplaceOptions().upsert(true)));
        }
        if (session == null) {
            collection.bulkWrite(bulk);
        } else {
            collection.bulkWrite(session, bulk);
        }
    }

    private BsonDocument getBsonDocument(MongoCollection collection, Object entity) {
        BsonDocument document = new BsonDocument();
        Codec codec = collection.getCodecRegistry().get(entity.getClass());
        codec.encode((BsonWriter)new BsonDocumentWriter(document), entity, EncoderContext.builder().build());
        return document;
    }

    ClientSession getSession(Object entity) {
        return this.getSession(entity.getClass());
    }

    ClientSession getSession(Class<?> entityClass) {
        ClientSession clientSession;
        TransactionSynchronizationRegistry registry;
        io.quarkus.mongodb.panache.MongoEntity legacyMongoEntity = entityClass.getAnnotation(io.quarkus.mongodb.panache.MongoEntity.class);
        MongoEntity mongoEntity = entityClass.getAnnotation(MongoEntity.class);
        InstanceHandle instance = Arc.container().instance(TransactionSynchronizationRegistry.class, new Annotation[0]);
        if (instance.isAvailable() && (registry = (TransactionSynchronizationRegistry)instance.get()).getTransactionStatus() == 0 && (clientSession = (ClientSession)registry.getResource(SESSION_KEY)) == null) {
            return this.registerClientSession(legacyMongoEntity, mongoEntity, registry);
        }
        return null;
    }

    private ClientSession registerClientSession(io.quarkus.mongodb.panache.MongoEntity legacyMongoEntity, MongoEntity mongoEntity, TransactionSynchronizationRegistry registry) {
        final TransactionManager transactionManager = (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
        MongoClient client = BeanUtils.clientFromArc(legacyMongoEntity, mongoEntity, MongoClient.class, false);
        final ClientSession clientSession = client.startSession();
        clientSession.startTransaction();
        registry.putResource(SESSION_KEY, (Object)clientSession);
        registry.registerInterposedSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int i) {
                block9: {
                    try {
                        if (transactionManager.getStatus() == 4) {
                            try {
                                clientSession.abortTransaction();
                                break block9;
                            }
                            finally {
                                clientSession.close();
                            }
                        }
                        try {
                            clientSession.commitTransaction();
                        }
                        finally {
                            clientSession.close();
                        }
                    }
                    catch (SystemException e) {
                        throw new MongoTransactionException((Exception)((Object)e));
                    }
                }
            }
        });
        return clientSession;
    }

    private MongoCollection mongoCollection(Object entity) {
        Class<?> entityClass = entity.getClass();
        return this.mongoCollection(entityClass);
    }

    private MongoDatabase mongoDatabase(io.quarkus.mongodb.panache.MongoEntity legacyEntity, MongoEntity mongoEntity) {
        MongoClient mongoClient = BeanUtils.clientFromArc(legacyEntity, mongoEntity, MongoClient.class, false);
        if (legacyEntity != null && !legacyEntity.database().isEmpty()) {
            return mongoClient.getDatabase(legacyEntity.database());
        }
        if (mongoEntity != null && !mongoEntity.database().isEmpty()) {
            return mongoClient.getDatabase(mongoEntity.database());
        }
        String databaseName = this.getDefaultDatabaseName(legacyEntity, mongoEntity);
        return mongoClient.getDatabase(databaseName);
    }

    private String getDefaultDatabaseName(final io.quarkus.mongodb.panache.MongoEntity legacyEntity, final MongoEntity mongoEntity) {
        return this.defaultDatabaseName.computeIfAbsent(BeanUtils.beanName(legacyEntity, mongoEntity), new Function<String, String>(){

            @Override
            public String apply(String beanName) {
                return BeanUtils.getDatabaseName(legacyEntity, mongoEntity, beanName);
            }
        });
    }

    public Object findById(Class<?> entityClass, Object id) {
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return session == null ? collection.find((Bson)new Document(ID, id)).first() : collection.find(session, (Bson)new Document(ID, id)).first();
    }

    public Optional findByIdOptional(Class<?> entityClass, Object id) {
        return Optional.ofNullable(this.findById(entityClass, id));
    }

    public QueryType find(Class<?> entityClass, String query, Object ... params) {
        return this.find(entityClass, query, null, params);
    }

    public QueryType find(Class<?> entityClass, String query, Sort sort, Object ... params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        Document docSort = this.sortToDocument(sort);
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return this.createQuery(collection, session, docQuery, docSort);
    }

    public String bindFilter(Class<?> clazz, String query, Object[] params) {
        String bindQuery = this.bindQuery(clazz, query, params);
        LOGGER.debug((Object)bindQuery);
        return bindQuery;
    }

    public String bindFilter(Class<?> clazz, String query, Map<String, Object> params) {
        String bindQuery = this.bindQuery(clazz, query, params);
        LOGGER.debug((Object)bindQuery);
        return bindQuery;
    }

    String bindUpdate(Class<?> clazz, String query, Object[] params) {
        Object bindUpdate = this.bindQuery(clazz, query, params);
        if (!this.containsUpdateOperator(query)) {
            bindUpdate = "{'$set':" + (String)bindUpdate + "}";
        }
        LOGGER.debug(bindUpdate);
        return bindUpdate;
    }

    String bindUpdate(Class<?> clazz, String query, Map<String, Object> params) {
        Object bindUpdate = this.bindQuery(clazz, query, params);
        if (!this.containsUpdateOperator(query)) {
            bindUpdate = "{'$set':" + (String)bindUpdate + "}";
        }
        LOGGER.debug(bindUpdate);
        return bindUpdate;
    }

    private boolean containsUpdateOperator(String update) {
        for (String operator : UPDATE_OPERATORS) {
            if (!update.contains(operator)) continue;
            return true;
        }
        return false;
    }

    private String bindQuery(Class<?> clazz, String query, Object[] params) {
        String bindQuery = null;
        bindQuery = query.charAt(0) == '{' ? NativeQueryBinder.bindQuery(query, params) : PanacheQlQueryBinder.bindQuery(clazz, query, params);
        return bindQuery;
    }

    private String bindQuery(Class<?> clazz, String query, Map<String, Object> params) {
        String bindQuery = null;
        bindQuery = query.charAt(0) == '{' ? NativeQueryBinder.bindQuery(query, params) : PanacheQlQueryBinder.bindQuery(clazz, query, params);
        return bindQuery;
    }

    public QueryType find(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.find(entityClass, query, null, params);
    }

    public QueryType find(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        Document docQuery = Document.parse((String)bindQuery);
        Document docSort = this.sortToDocument(sort);
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return this.createQuery(collection, session, docQuery, docSort);
    }

    public QueryType find(Class<?> entityClass, String query, Parameters params) {
        return this.find(entityClass, query, null, params.map());
    }

    public QueryType find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.find(entityClass, query, sort, params.map());
    }

    public QueryType find(Class<?> entityClass, Document query, Sort sort) {
        MongoCollection collection = this.mongoCollection(entityClass);
        Document sortDoc = this.sortToDocument(sort);
        ClientSession session = this.getSession(entityClass);
        return this.createQuery(collection, session, query, sortDoc);
    }

    public QueryType find(Class<?> entityClass, Document query, Document sort) {
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return this.createQuery(collection, session, query, sort);
    }

    public QueryType find(Class<?> entityClass, Document query) {
        return this.find(entityClass, query, (Document)null);
    }

    public List<?> list(Class<?> entityClass, String query, Object ... params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public List<?> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public List<?> list(Class<?> entityClass, String query, Parameters params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public List<?> list(Class<?> entityClass, Document query) {
        return this.list(this.find(entityClass, query));
    }

    public List<?> list(Class<?> entityClass, Document query, Document sort) {
        return this.list(this.find(entityClass, query, sort));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Object ... params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Parameters params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, Document query) {
        return this.stream(this.find(entityClass, query));
    }

    public Stream<?> stream(Class<?> entityClass, Document query, Document sort) {
        return this.stream(this.find(entityClass, query, sort));
    }

    public QueryType findAll(Class<?> entityClass) {
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return this.createQuery(collection, session, null, null);
    }

    public QueryType findAll(Class<?> entityClass, Sort sort) {
        MongoCollection collection = this.mongoCollection(entityClass);
        Document sortDoc = this.sortToDocument(sort);
        ClientSession session = this.getSession(entityClass);
        return this.createQuery(collection, session, null, sortDoc);
    }

    private Document sortToDocument(Sort sort) {
        if (sort == null) {
            return null;
        }
        Document sortDoc = new Document();
        for (Sort.Column col : sort.getColumns()) {
            sortDoc.append(col.getName(), (Object)(col.getDirection() == Sort.Direction.Ascending ? 1 : -1));
        }
        return sortDoc;
    }

    public List<?> listAll(Class<?> entityClass) {
        return this.list(this.findAll(entityClass));
    }

    public List<?> listAll(Class<?> entityClass, Sort sort) {
        return this.list(this.findAll(entityClass, sort));
    }

    public Stream<?> streamAll(Class<?> entityClass) {
        return this.stream(this.findAll(entityClass));
    }

    public Stream<?> streamAll(Class<?> entityClass, Sort sort) {
        return this.stream(this.findAll(entityClass, sort));
    }

    public long count(Class<?> entityClass) {
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return session == null ? collection.countDocuments() : collection.countDocuments(session);
    }

    public long count(Class<?> entityClass, String query, Object ... params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return session == null ? collection.countDocuments((Bson)docQuery) : collection.countDocuments(session, (Bson)docQuery);
    }

    public long count(Class<?> entityClass, String query, Map<String, Object> params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return session == null ? collection.countDocuments((Bson)docQuery) : collection.countDocuments(session, (Bson)docQuery);
    }

    public long count(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params.map());
    }

    public long count(Class<?> entityClass, Document query) {
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return session == null ? collection.countDocuments((Bson)query) : collection.countDocuments(session, (Bson)query);
    }

    public long deleteAll(Class<?> entityClass) {
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return session == null ? collection.deleteMany((Bson)new Document()).getDeletedCount() : collection.deleteMany(session, (Bson)new Document()).getDeletedCount();
    }

    public boolean deleteById(Class<?> entityClass, Object id) {
        MongoCollection collection = this.mongoCollection(entityClass);
        Document query = new Document().append(ID, id);
        ClientSession session = this.getSession(entityClass);
        DeleteResult results = session == null ? collection.deleteOne((Bson)query) : collection.deleteOne(session, (Bson)query);
        return results.getDeletedCount() == 1L;
    }

    public long delete(Class<?> entityClass, String query, Object ... params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return session == null ? collection.deleteMany((Bson)docQuery).getDeletedCount() : collection.deleteMany(session, (Bson)docQuery).getDeletedCount();
    }

    public long delete(Class<?> entityClass, String query, Map<String, Object> params) {
        String bindQuery = this.bindFilter(entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return session == null ? collection.deleteMany((Bson)docQuery).getDeletedCount() : collection.deleteMany(session, (Bson)docQuery).getDeletedCount();
    }

    public long delete(Class<?> entityClass, String query, Parameters params) {
        return this.delete(entityClass, query, params.map());
    }

    public long delete(Class<?> entityClass, Document query) {
        MongoCollection collection = this.mongoCollection(entityClass);
        ClientSession session = this.getSession(entityClass);
        return session == null ? collection.deleteMany((Bson)query).getDeletedCount() : collection.deleteMany(session, (Bson)query).getDeletedCount();
    }

    public UpdateType update(Class<?> entityClass, String update, Map<String, Object> params) {
        return this.executeUpdate(entityClass, update, params);
    }

    public UpdateType update(Class<?> entityClass, String update, Parameters params) {
        return this.update(entityClass, update, params.map());
    }

    public UpdateType update(Class<?> entityClass, String update, Object ... params) {
        return this.executeUpdate(entityClass, update, params);
    }

    private UpdateType executeUpdate(Class<?> entityClass, String update, Object ... params) {
        String bindUpdate = this.bindUpdate(entityClass, update, params);
        Document docUpdate = Document.parse((String)bindUpdate);
        return this.createUpdate(this.mongoCollection(entityClass), entityClass, docUpdate);
    }

    private UpdateType executeUpdate(Class<?> entityClass, String update, Map<String, Object> params) {
        String bindUpdate = this.bindUpdate(entityClass, update, params);
        Document docUpdate = Document.parse((String)bindUpdate);
        return this.createUpdate(this.mongoCollection(entityClass), entityClass, docUpdate);
    }

    public IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses");
    }
}

