/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.common.runtime;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import io.quarkus.mongodb.panache.common.PanacheUpdate;
import io.quarkus.mongodb.panache.common.runtime.MongoOperations;
import io.quarkus.panache.common.Parameters;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class PanacheUpdateImpl
implements PanacheUpdate {
    private MongoOperations operations;
    private Class<?> entityClass;
    private Bson update;
    private MongoCollection collection;
    private ClientSession session;

    public PanacheUpdateImpl(MongoOperations operations, Class<?> entityClass, Bson update, MongoCollection collection) {
        this.operations = operations;
        this.entityClass = entityClass;
        this.update = update;
        this.collection = collection;
        this.session = operations.getSession(entityClass);
    }

    @Override
    public long where(String query, Object ... params) {
        String bindQuery = this.operations.bindFilter(this.entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        return this.executeUpdate(docQuery);
    }

    @Override
    public long where(String query, Map<String, Object> params) {
        String bindQuery = this.operations.bindFilter(this.entityClass, query, params);
        BsonDocument docQuery = BsonDocument.parse((String)bindQuery);
        return this.executeUpdate(docQuery);
    }

    @Override
    public long where(String query, Parameters params) {
        return this.where(query, params.map());
    }

    @Override
    public long all() {
        BsonDocument all = new BsonDocument();
        return this.executeUpdate(all);
    }

    private long executeUpdate(BsonDocument query) {
        return this.session == null ? this.collection.updateMany((Bson)query, this.update).getModifiedCount() : this.collection.updateMany(this.session, (Bson)query, this.update).getModifiedCount();
    }
}

