/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.common.runtime;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.codecs.pojo.annotations.BsonProperty;
import org.jboss.logging.Logger;

public final class MongoPropertyUtil {
    private static final Logger LOGGER = Logger.getLogger(MongoPropertyUtil.class);
    private static volatile Map<String, Map<String, String>> replacementCache = Collections.emptyMap();

    private MongoPropertyUtil() {
    }

    public static Set<String> collectFields(Class<?> type) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (Method method : type.getMethods()) {
            if (!method.getName().startsWith("get") || method.getName().equals("getClass")) continue;
            String fieldName = MongoPropertyUtil.decapitalize(method.getName().substring(3));
            fieldNames.add(fieldName);
        }
        for (AccessibleObject accessibleObject : type.getFields()) {
            fieldNames.add(((Field)accessibleObject).getName());
        }
        Map<String, String> replacementMap = MongoPropertyUtil.getReplacementMap(type);
        for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
            if (!fieldNames.contains(entry.getKey())) continue;
            fieldNames.remove(entry.getKey());
            fieldNames.add(entry.getValue());
        }
        return fieldNames;
    }

    public static void setReplacementCache(Map<String, Map<String, String>> newReplacementCache) {
        replacementCache = newReplacementCache;
    }

    public static Map<String, String> getReplacementMap(Class<?> clazz) {
        return replacementCache.computeIfAbsent(clazz.getName(), s -> MongoPropertyUtil.buildWithReflection(clazz));
    }

    private static Map<String, String> buildWithReflection(Class<?> clazz) {
        BsonProperty bsonProperty;
        LOGGER.info((Object)("No replacement map found for " + clazz.getName() + ", default to using reflection. To avoid that, make sure the class is in the Jandex index or, if using class based projection, annotated it with @ProjectionFor"));
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        for (Field field : clazz.getDeclaredFields()) {
            bsonProperty = field.getAnnotation(BsonProperty.class);
            if (bsonProperty == null) continue;
            replacementMap.put(field.getName(), bsonProperty.value());
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            if (!((Method)accessibleObject).getName().startsWith("get") || (bsonProperty = ((Method)accessibleObject).getAnnotation(BsonProperty.class)) == null) continue;
            String fieldName = MongoPropertyUtil.decapitalize(((Method)accessibleObject).getName().substring(3));
            replacementMap.put(fieldName, bsonProperty.value());
        }
        return replacementMap;
    }

    private static String decapitalize(String name) {
        if (name != null && name.length() != 0) {
            if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
                return name;
            }
            char[] chars = name.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            return new String(chars);
        }
        return name;
    }
}

