/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.jackson.spi.JacksonModuleBuildItem;
import io.quarkus.jsonb.spi.JsonbDeserializerBuildItem;
import io.quarkus.jsonb.spi.JsonbSerializerBuildItem;
import io.quarkus.mongodb.panache.PanacheMongoEntity;
import io.quarkus.mongodb.panache.PanacheMongoEntityBase;
import io.quarkus.mongodb.panache.PanacheMongoRecorder;
import io.quarkus.mongodb.panache.PanacheMongoRepository;
import io.quarkus.mongodb.panache.PanacheMongoRepositoryBase;
import io.quarkus.mongodb.panache.ProjectionFor;
import io.quarkus.mongodb.panache.deployment.PanacheMongoEntityEnhancer;
import io.quarkus.mongodb.panache.deployment.PanacheMongoRepositoryEnhancer;
import io.quarkus.mongodb.panache.deployment.ProjectionForEnhancer;
import io.quarkus.mongodb.panache.deployment.PropertyMappingClassBuildStep;
import io.quarkus.mongodb.panache.deployment.ReactivePanacheMongoEntityEnhancer;
import io.quarkus.mongodb.panache.deployment.ReactivePanacheMongoRepositoryEnhancer;
import io.quarkus.mongodb.panache.jsonb.ObjectIdDeserializer;
import io.quarkus.mongodb.panache.jsonb.ObjectIdSerializer;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoEntity;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoEntityBase;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoRepository;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoRepositoryBase;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.bson.codecs.pojo.annotations.BsonProperty;
import org.bson.types.ObjectId;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class PanacheResourceProcessor {
    static final DotName DOTNAME_PANACHE_REPOSITORY_BASE = DotName.createSimple((String)PanacheMongoRepositoryBase.class.getName());
    private static final DotName DOTNAME_PANACHE_REPOSITORY = DotName.createSimple((String)PanacheMongoRepository.class.getName());
    static final DotName DOTNAME_PANACHE_ENTITY_BASE = DotName.createSimple((String)PanacheMongoEntityBase.class.getName());
    private static final DotName DOTNAME_PANACHE_ENTITY = DotName.createSimple((String)PanacheMongoEntity.class.getName());
    private static final DotName DOTNAME_PROJECTION_FOR = DotName.createSimple((String)ProjectionFor.class.getName());
    private static final DotName DOTNAME_BSON_PROPERTY = DotName.createSimple((String)BsonProperty.class.getName());
    static final DotName DOTNAME_MUTINY_PANACHE_REPOSITORY_BASE = DotName.createSimple((String)ReactivePanacheMongoRepositoryBase.class.getName());
    private static final DotName DOTNAME_MUTINY_PANACHE_REPOSITORY = DotName.createSimple((String)ReactivePanacheMongoRepository.class.getName());
    static final DotName DOTNAME_MUTINY_PANACHE_ENTITY_BASE = DotName.createSimple((String)ReactivePanacheMongoEntityBase.class.getName());
    private static final DotName DOTNAME_MUTINY_PANACHE_ENTITY = DotName.createSimple((String)ReactivePanacheMongoEntity.class.getName());
    private static final DotName DOTNAME_OBJECT_ID = DotName.createSimple((String)ObjectId.class.getName());
    private static final DotName DOTNAME_OBJECT = DotName.createSimple((String)Object.class.getName());

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("io.quarkus.mongodb.panache");
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("mongodb-panache");
    }

    @BuildStep
    void registerJsonbSerDeser(BuildProducer<JsonbSerializerBuildItem> jsonbSerializers, BuildProducer<JsonbDeserializerBuildItem> jsonbDeserializers) {
        jsonbSerializers.produce((BuildItem)new JsonbSerializerBuildItem(ObjectIdSerializer.class.getName()));
        jsonbDeserializers.produce((BuildItem)new JsonbDeserializerBuildItem(ObjectIdDeserializer.class.getName()));
    }

    @BuildStep
    void registerJacksonSerDeser(BuildProducer<JacksonModuleBuildItem> customSerDeser) {
        customSerDeser.produce((BuildItem)new JacksonModuleBuildItem.Builder("ObjectIdModule").add(io.quarkus.mongodb.panache.jackson.ObjectIdSerializer.class.getName(), io.quarkus.mongodb.panache.jackson.ObjectIdDeserializer.class.getName(), ObjectId.class.getName()).build());
    }

    @BuildStep
    ReflectiveHierarchyBuildItem registerForReflection(CombinedIndexBuildItem index) {
        Indexer indexer = new Indexer();
        HashSet additionalIndex = new HashSet();
        IndexingUtil.indexClass((String)ObjectId.class.getName(), (Indexer)indexer, (IndexView)index.getIndex(), additionalIndex, (ClassLoader)PanacheResourceProcessor.class.getClassLoader());
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{index.getIndex(), indexer.complete()});
        Type type = Type.create((DotName)DOTNAME_OBJECT_ID, (Type.Kind)Type.Kind.CLASS);
        return new ReflectiveHierarchyBuildItem(type, (IndexView)compositeIndex);
    }

    @BuildStep
    void unremovableProducers(BuildProducer<UnremovableBeanBuildItem> unremovable, BeanArchiveIndexBuildItem beanArchiveIndex) {
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion("io.quarkus.mongodb.runtime.MongoClientProducer")));
    }

    @BuildStep
    void buildImperative(CombinedIndexBuildItem index, ApplicationIndexBuildItem applicationIndex, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, BuildProducer<PanacheEntityClassesBuildItem> entityClasses) {
        PanacheMongoRepositoryEnhancer daoEnhancer = new PanacheMongoRepositoryEnhancer(index.getIndex());
        HashSet<String> daoClasses = new HashSet<String>();
        HashSet daoTypeParameters = new HashSet();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_PANACHE_REPOSITORY) || PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex()));
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY)) {
            if (PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex()));
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)((Object)daoEnhancer)));
        }
        for (Type parameterType : daoTypeParameters) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{parameterType.name().toString()}));
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(parameterType.name().toString()));
        }
        PanacheMongoEntityEnhancer modelEnhancer = new PanacheMongoEntityEnhancer(index.getIndex());
        HashSet<String> modelClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownSubclasses(DOTNAME_PANACHE_ENTITY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_PANACHE_ENTITY) || !modelClasses.add(classInfo.name().toString())) continue;
            modelEnhancer.collectFields(classInfo);
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownSubclasses(DOTNAME_PANACHE_ENTITY)) {
            if (!modelClasses.add(classInfo.name().toString())) continue;
            modelEnhancer.collectFields(classInfo);
        }
        for (String modelClass : modelClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(modelClass, (BiFunction)((Object)modelEnhancer)));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{modelClass}));
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(modelClass));
        }
        if (!modelClasses.isEmpty()) {
            entityClasses.produce((BuildItem)new PanacheEntityClassesBuildItem(modelClasses));
        }
        if (!modelEnhancer.entities.isEmpty()) {
            PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelEnhancer.getModelInfo());
            for (ClassInfo classInfo : applicationIndex.getIndex().getKnownClasses()) {
                String className = classInfo.name().toString();
                if (modelClasses.contains(className)) continue;
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(className, (BiFunction)panacheFieldAccessEnhancer));
            }
        }
    }

    @BuildStep
    void buildMutiny(CombinedIndexBuildItem index, ApplicationIndexBuildItem applicationIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        ReactivePanacheMongoRepositoryEnhancer daoEnhancer = new ReactivePanacheMongoRepositoryEnhancer(index.getIndex());
        HashSet<String> daoClasses = new HashSet<String>();
        HashSet daoTypeParameters = new HashSet();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_MUTINY_PANACHE_REPOSITORY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_MUTINY_PANACHE_REPOSITORY) || PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex()));
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_MUTINY_PANACHE_REPOSITORY)) {
            if (PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex()));
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)((Object)daoEnhancer)));
        }
        for (Type parameterType : daoTypeParameters) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{parameterType.name().toString()}));
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(parameterType.name().toString()));
        }
        ReactivePanacheMongoEntityEnhancer modelEnhancer = new ReactivePanacheMongoEntityEnhancer(index.getIndex());
        HashSet<String> modelClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownSubclasses(DOTNAME_MUTINY_PANACHE_ENTITY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_MUTINY_PANACHE_ENTITY) || !modelClasses.add(classInfo.name().toString())) continue;
            modelEnhancer.collectFields(classInfo);
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownSubclasses(DOTNAME_MUTINY_PANACHE_ENTITY)) {
            if (!modelClasses.add(classInfo.name().toString())) continue;
            modelEnhancer.collectFields(classInfo);
        }
        for (String modelClass : modelClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(modelClass, (BiFunction)((Object)modelEnhancer)));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{modelClass}));
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(modelClass));
        }
        if (!modelEnhancer.entities.isEmpty()) {
            PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelEnhancer.getModelInfo());
            for (ClassInfo classInfo : applicationIndex.getIndex().getKnownClasses()) {
                String className = classInfo.name().toString();
                if (modelClasses.contains(className)) continue;
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(className, (BiFunction)panacheFieldAccessEnhancer));
            }
        }
    }

    @BuildStep
    void handleProjectionFor(CombinedIndexBuildItem index, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        Type targetClass;
        HashMap<DotName, HashMap<String, String>> propertyMapping = new HashMap<DotName, HashMap<String, String>>();
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(DOTNAME_PROJECTION_FOR)) {
            targetClass = annotationInstance.value().asClass();
            ClassInfo target = index.getIndex().getClassByName(targetClass.name());
            HashMap<String, String> classPropertyMapping = new HashMap<String, String>();
            this.extractMappings(classPropertyMapping, target, index);
            propertyMapping.put(targetClass.name(), classPropertyMapping);
        }
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(DOTNAME_PROJECTION_FOR)) {
            targetClass = annotationInstance.value().asClass();
            Map targetPropertyMapping = (Map)propertyMapping.get(targetClass.name());
            if (targetPropertyMapping != null && !targetPropertyMapping.isEmpty()) {
                ClassInfo info = annotationInstance.target().asClass();
                ProjectionForEnhancer fieldEnhancer = new ProjectionForEnhancer(targetPropertyMapping);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(info.name().toString(), (BiFunction)fieldEnhancer));
            }
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(targetClass.name().toString(), annotationInstance.target().asClass().name().toString()));
        }
    }

    private void extractMappings(Map<String, String> classPropertyMapping, ClassInfo target, CombinedIndexBuildItem index) {
        AnnotationInstance bsonProperty;
        for (FieldInfo fieldInfo : target.fields()) {
            if (!fieldInfo.hasAnnotation(DOTNAME_BSON_PROPERTY)) continue;
            bsonProperty = fieldInfo.annotation(DOTNAME_BSON_PROPERTY);
            classPropertyMapping.put(fieldInfo.name(), bsonProperty.value().asString());
        }
        for (MethodInfo methodInfo : target.methods()) {
            if (!methodInfo.hasAnnotation(DOTNAME_BSON_PROPERTY)) continue;
            bsonProperty = methodInfo.annotation(DOTNAME_BSON_PROPERTY);
            classPropertyMapping.put(methodInfo.name(), bsonProperty.value().asString());
        }
        if (!target.superClassType().name().equals((Object)DOTNAME_OBJECT)) {
            Type superType = target.superClassType();
            ClassInfo superClass = index.getIndex().getClassByName(superType.name());
            this.extractMappings(classPropertyMapping, superClass, index);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildReplacementMap(List<PropertyMappingClassBuildStep> propertyMappingClasses, CombinedIndexBuildItem index, PanacheMongoRecorder recorder) {
        ConcurrentHashMap<String, Map> replacementMap = new ConcurrentHashMap<String, Map>();
        for (PropertyMappingClassBuildStep classToMap : propertyMappingClasses) {
            DotName dotName = DotName.createSimple((String)classToMap.getClassName());
            ClassInfo classInfo = index.getIndex().getClassByName(dotName);
            if (classInfo == null) continue;
            Map classReplacementMap = replacementMap.computeIfAbsent(classToMap.getClassName(), className -> this.computeReplacement(classInfo));
            if (classToMap.getAliasClassName() == null) continue;
            replacementMap.put(classToMap.getAliasClassName(), classReplacementMap);
        }
        recorder.setReplacementCache(replacementMap);
    }

    private Map<String, String> computeReplacement(ClassInfo classInfo) {
        AnnotationInstance bsonProperty;
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        for (FieldInfo field : classInfo.fields()) {
            bsonProperty = field.annotation(DOTNAME_BSON_PROPERTY);
            if (bsonProperty == null) continue;
            replacementMap.put(field.name(), bsonProperty.value().asString());
        }
        for (MethodInfo method : classInfo.methods()) {
            if (!method.name().startsWith("get") || (bsonProperty = method.annotation(DOTNAME_BSON_PROPERTY)) == null) continue;
            String fieldName = JavaBeanUtil.decapitalize((String)method.name().substring(3));
            replacementMap.put(fieldName, bsonProperty.value().asString());
        }
        return replacementMap.isEmpty() ? Collections.emptyMap() : replacementMap;
    }
}

