/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.deployment;

import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.mongodb.panache.deployment.PanacheMongoResourceProcessor;
import io.quarkus.mongodb.panache.runtime.MongoOperations;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class PanacheMongoEntityEnhancer
extends PanacheEntityEnhancer<MetamodelInfo<EntityModel<EntityField>>> {
    public static final String MONGO_OPERATIONS_NAME = MongoOperations.class.getName();
    public static final String MONGO_OPERATIONS_BINARY_NAME = MONGO_OPERATIONS_NAME.replace('.', '/');
    private static final DotName DOTNAME_BSON_IGNORE = DotName.createSimple((String)BsonIgnore.class.getName());
    final Map<String, EntityModel> entities = new HashMap<String, EntityModel>();

    public PanacheMongoEntityEnhancer(IndexView index, List<PanacheMethodCustomizer> methodCustomizers) {
        super(index, PanacheMongoResourceProcessor.DOTNAME_PANACHE_ENTITY_BASE, methodCustomizers);
        this.modelInfo = new MetamodelInfo();
    }

    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new PanacheMongoEntityClassVisitor(className, outputClassVisitor, (MetamodelInfo<EntityModel<EntityField>>)this.modelInfo, this.panacheEntityBaseClassInfo, this.indexView.getClassByName(DotName.createSimple((String)className)), this.methodCustomizers);
    }

    public void collectFields(ClassInfo classInfo) {
        EntityModel entityModel = new EntityModel(classInfo);
        for (FieldInfo fieldInfo : classInfo.fields()) {
            String name = fieldInfo.name();
            if (!Modifier.isPublic(fieldInfo.flags()) || fieldInfo.hasAnnotation(DOTNAME_BSON_IGNORE)) continue;
            entityModel.addField(new EntityField(name, DescriptorUtils.typeToString((Type)fieldInfo.type())));
        }
        this.modelInfo.addEntityModel(entityModel);
    }

    static class PanacheMongoEntityClassVisitor
    extends PanacheEntityEnhancer.PanacheEntityClassVisitor<EntityField> {
        public PanacheMongoEntityClassVisitor(String className, ClassVisitor outputClassVisitor, MetamodelInfo<EntityModel<EntityField>> modelInfo, ClassInfo panacheEntityBaseClassInfo, ClassInfo entityInfo, List<PanacheMethodCustomizer> methodCustomizers) {
            super(className, outputClassVisitor, modelInfo, panacheEntityBaseClassInfo, entityInfo, methodCustomizers);
        }

        protected void injectModel(MethodVisitor mv) {
            mv.visitLdcInsn((Object)this.thisClass);
        }

        protected String getModelDescriptor() {
            return "Ljava/lang/Class;";
        }

        protected String getPanacheOperationsBinaryName() {
            return MONGO_OPERATIONS_BINARY_NAME;
        }

        protected void generateAccessorSetField(MethodVisitor mv, EntityField field) {
            mv.visitFieldInsn(181, this.thisClass.getInternalName(), field.name, field.descriptor);
        }

        protected void generateAccessorGetField(MethodVisitor mv, EntityField field) {
            mv.visitFieldInsn(180, this.thisClass.getInternalName(), field.name, field.descriptor);
        }
    }
}

