/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.deployment;

import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.jackson.spi.JacksonModuleBuildItem;
import io.quarkus.jsonb.spi.JsonbDeserializerBuildItem;
import io.quarkus.jsonb.spi.JsonbSerializerBuildItem;
import io.quarkus.mongodb.deployment.MongoClientNameBuildItem;
import io.quarkus.mongodb.deployment.MongoUnremovableClientsBuildItem;
import io.quarkus.mongodb.panache.MongoEntity;
import io.quarkus.mongodb.panache.PanacheMongoEntity;
import io.quarkus.mongodb.panache.PanacheMongoEntityBase;
import io.quarkus.mongodb.panache.PanacheMongoRecorder;
import io.quarkus.mongodb.panache.PanacheMongoRepository;
import io.quarkus.mongodb.panache.PanacheMongoRepositoryBase;
import io.quarkus.mongodb.panache.ProjectionFor;
import io.quarkus.mongodb.panache.deployment.PanacheMongoEntityClassBuildItem;
import io.quarkus.mongodb.panache.deployment.PanacheMongoEntityEnhancer;
import io.quarkus.mongodb.panache.deployment.PanacheMongoRepositoryEnhancer;
import io.quarkus.mongodb.panache.deployment.ProjectionForEnhancer;
import io.quarkus.mongodb.panache.deployment.PropertyMappingClassBuildStep;
import io.quarkus.mongodb.panache.deployment.ReactivePanacheMongoEntityEnhancer;
import io.quarkus.mongodb.panache.deployment.ReactivePanacheMongoRepositoryEnhancer;
import io.quarkus.mongodb.panache.jsonb.ObjectIdDeserializer;
import io.quarkus.mongodb.panache.jsonb.ObjectIdSerializer;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoEntity;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoEntityBase;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoRepository;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoRepositoryBase;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonProperty;
import org.bson.types.ObjectId;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class PanacheMongoResourceProcessor {
    static final DotName DOTNAME_PANACHE_REPOSITORY_BASE = DotName.createSimple((String)PanacheMongoRepositoryBase.class.getName());
    private static final DotName DOTNAME_PANACHE_REPOSITORY = DotName.createSimple((String)PanacheMongoRepository.class.getName());
    static final DotName DOTNAME_PANACHE_ENTITY_BASE = DotName.createSimple((String)PanacheMongoEntityBase.class.getName());
    private static final DotName DOTNAME_PANACHE_ENTITY = DotName.createSimple((String)PanacheMongoEntity.class.getName());
    private static final DotName DOTNAME_PROJECTION_FOR = DotName.createSimple((String)ProjectionFor.class.getName());
    private static final DotName DOTNAME_BSON_PROPERTY = DotName.createSimple((String)BsonProperty.class.getName());
    private static final DotName DOTNAME_BSON_ID = DotName.createSimple((String)BsonId.class.getName());
    private static final DotName DOTNAME_MONGO_ENTITY = DotName.createSimple((String)MongoEntity.class.getName());
    static final DotName DOTNAME_MUTINY_PANACHE_REPOSITORY_BASE = DotName.createSimple((String)ReactivePanacheMongoRepositoryBase.class.getName());
    private static final DotName DOTNAME_MUTINY_PANACHE_REPOSITORY = DotName.createSimple((String)ReactivePanacheMongoRepository.class.getName());
    static final DotName DOTNAME_MUTINY_PANACHE_ENTITY_BASE = DotName.createSimple((String)ReactivePanacheMongoEntityBase.class.getName());
    private static final DotName DOTNAME_MUTINY_PANACHE_ENTITY = DotName.createSimple((String)ReactivePanacheMongoEntity.class.getName());
    private static final DotName DOTNAME_OBJECT_ID = DotName.createSimple((String)ObjectId.class.getName());
    protected static final String META_INF_PANACHE_ARCHIVE_MARKER = "META-INF/panache-archive.marker";

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.MONGODB_PANACHE);
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.MONGODB_PANACHE);
    }

    @BuildStep
    void contributeClassesToIndex(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses) {
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(new String[]{DOTNAME_OBJECT_ID.toString()}));
    }

    @BuildStep
    void registerJsonbSerDeser(BuildProducer<JsonbSerializerBuildItem> jsonbSerializers, BuildProducer<JsonbDeserializerBuildItem> jsonbDeserializers) {
        jsonbSerializers.produce((BuildItem)new JsonbSerializerBuildItem(ObjectIdSerializer.class.getName()));
        jsonbDeserializers.produce((BuildItem)new JsonbDeserializerBuildItem(ObjectIdDeserializer.class.getName()));
    }

    @BuildStep
    void registerJacksonSerDeser(BuildProducer<JacksonModuleBuildItem> customSerDeser) {
        customSerDeser.produce((BuildItem)new JacksonModuleBuildItem.Builder("ObjectIdModule").add(io.quarkus.mongodb.panache.jackson.ObjectIdSerializer.class.getName(), io.quarkus.mongodb.panache.jackson.ObjectIdDeserializer.class.getName(), ObjectId.class.getName()).build());
    }

    @BuildStep
    ReflectiveHierarchyBuildItem registerForReflection(CombinedIndexBuildItem index) {
        Type type = Type.create((DotName)DOTNAME_OBJECT_ID, (Type.Kind)Type.Kind.CLASS);
        return new ReflectiveHierarchyBuildItem(type, index.getIndex());
    }

    @BuildStep
    void unremoveableClients(BuildProducer<MongoUnremovableClientsBuildItem> unremovable) {
        unremovable.produce((BuildItem)new MongoUnremovableClientsBuildItem());
    }

    @BuildStep
    public void mongoClientNames(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<MongoClientNameBuildItem> mongoClientName) {
        HashSet<String> values = new HashSet<String>();
        IndexView indexView = applicationArchivesBuildItem.getRootArchive().getIndex();
        Collection instances = indexView.getAnnotations(DOTNAME_MONGO_ENTITY);
        for (AnnotationInstance annotation : instances) {
            AnnotationValue clientName = annotation.value("clientName");
            if (clientName == null || clientName.asString().isEmpty()) continue;
            values.add(clientName.asString());
        }
        for (String value : values) {
            mongoClientName.produce((BuildItem)new MongoClientNameBuildItem(value, false));
        }
    }

    @BuildStep
    void collectEntityClasses(CombinedIndexBuildItem index, BuildProducer<PanacheMongoEntityClassBuildItem> entityClasses) {
        for (ClassInfo panacheEntityBaseSubclass : index.getIndex().getAllKnownSubclasses(DOTNAME_PANACHE_ENTITY_BASE)) {
            if (panacheEntityBaseSubclass.name().equals((Object)DOTNAME_PANACHE_ENTITY)) continue;
            entityClasses.produce((BuildItem)new PanacheMongoEntityClassBuildItem(panacheEntityBaseSubclass));
        }
    }

    @BuildStep
    PanacheEntityClassesBuildItem findEntityClasses(List<PanacheMongoEntityClassBuildItem> entityClasses) {
        if (!entityClasses.isEmpty()) {
            HashSet<String> ret = new HashSet<String>();
            for (PanacheMongoEntityClassBuildItem entityClass : entityClasses) {
                ret.add(entityClass.get().name().toString());
            }
            return new PanacheEntityClassesBuildItem(ret);
        }
        return null;
    }

    @BuildStep
    void buildImperative(CombinedIndexBuildItem index, ApplicationIndexBuildItem applicationIndex, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, List<PanacheMongoEntityClassBuildItem> entityClasses, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) {
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(bi -> bi.getMethodCustomizer()).collect(Collectors.toList());
        PanacheMongoRepositoryEnhancer daoEnhancer = new PanacheMongoRepositoryEnhancer(index.getIndex());
        HashSet<String> daoClasses = new HashSet<String>();
        HashSet daoTypeParameters = new HashSet();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_PANACHE_REPOSITORY) || PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex()));
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY)) {
            if (PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex()));
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)((Object)daoEnhancer)));
        }
        for (Type parameterType : daoTypeParameters) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{parameterType.name().toString()}));
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(parameterType.name().toString()));
        }
        PanacheMongoEntityEnhancer modelEnhancer = new PanacheMongoEntityEnhancer(index.getIndex(), methodCustomizers);
        HashSet<String> modelClasses = new HashSet<String>();
        HashSet<String> modelClassNamesInternal = new HashSet<String>();
        for (PanacheMongoEntityClassBuildItem entityClass : entityClasses) {
            String entityClassName = entityClass.get().name().toString();
            modelClasses.add(entityClassName);
            modelEnhancer.collectFields(entityClass.get());
            modelClassNamesInternal.add(entityClassName.replace(".", "/"));
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(entityClassName, (BiFunction)((Object)modelEnhancer)));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{entityClassName}));
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(entityClassName));
        }
        if (!modelEnhancer.entities.isEmpty()) {
            PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelEnhancer.getModelInfo());
            QuarkusClassLoader tccl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            List archives = tccl.getElementsWithResource(META_INF_PANACHE_ARCHIVE_MARKER);
            for (ClassPathElement i : archives) {
                for (String res : i.getProvidedResources()) {
                    String cn;
                    if (!res.endsWith(".class") || modelClasses.contains(cn = res.replace("/", ".").substring(0, res.length() - 6))) continue;
                    transformers.produce((BuildItem)new BytecodeTransformerBuildItem(cn, (BiFunction)panacheFieldAccessEnhancer, modelClassNamesInternal));
                }
            }
        }
    }

    @BuildStep
    void buildMutiny(CombinedIndexBuildItem index, ApplicationIndexBuildItem applicationIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, BuildProducer<BytecodeTransformerBuildItem> transformers, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) {
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(bi -> bi.getMethodCustomizer()).collect(Collectors.toList());
        ReactivePanacheMongoRepositoryEnhancer daoEnhancer = new ReactivePanacheMongoRepositoryEnhancer(index.getIndex());
        HashSet<String> daoClasses = new HashSet<String>();
        HashSet daoTypeParameters = new HashSet();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_MUTINY_PANACHE_REPOSITORY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_MUTINY_PANACHE_REPOSITORY) || PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex()));
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_MUTINY_PANACHE_REPOSITORY)) {
            if (PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex()));
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)((Object)daoEnhancer)));
        }
        for (Type parameterType : daoTypeParameters) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{parameterType.name().toString()}));
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(parameterType.name().toString()));
        }
        ReactivePanacheMongoEntityEnhancer modelEnhancer = new ReactivePanacheMongoEntityEnhancer(index.getIndex(), methodCustomizers);
        HashSet<String> modelClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownSubclasses(DOTNAME_MUTINY_PANACHE_ENTITY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_MUTINY_PANACHE_ENTITY) || !modelClasses.add(classInfo.name().toString())) continue;
            modelEnhancer.collectFields(classInfo);
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownSubclasses(DOTNAME_MUTINY_PANACHE_ENTITY)) {
            if (!modelClasses.add(classInfo.name().toString())) continue;
            modelEnhancer.collectFields(classInfo);
        }
        for (String modelClass : modelClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(modelClass, (BiFunction)((Object)modelEnhancer)));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{modelClass}));
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(modelClass));
        }
        if (!modelEnhancer.entities.isEmpty()) {
            PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelEnhancer.getModelInfo());
            for (ClassInfo classInfo : applicationIndex.getIndex().getKnownClasses()) {
                String className = classInfo.name().toString();
                if (modelClasses.contains(className)) continue;
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(className, (BiFunction)panacheFieldAccessEnhancer));
            }
        }
    }

    @BuildStep
    ValidationPhaseBuildItem.ValidationErrorBuildItem validate(ValidationPhaseBuildItem validationPhase, CombinedIndexBuildItem index) throws BuildException {
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(DOTNAME_BSON_ID)) {
            ClassInfo info = JandexUtil.getEnclosingClass((AnnotationInstance)annotationInstance);
            if (JandexUtil.isSubclassOf((IndexView)index.getIndex(), (ClassInfo)info, (DotName)DOTNAME_PANACHE_ENTITY)) {
                BuildException be = new BuildException("You provide a MongoDB identifier via @BsonId inside '" + info.name() + "' but one is already provided by PanacheMongoEntity, your class should extend PanacheMongoEntityBase instead, or use the id provided by PanacheMongoEntity", Collections.emptyList());
                return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{be});
            }
            if (!JandexUtil.isSubclassOf((IndexView)index.getIndex(), (ClassInfo)info, (DotName)DOTNAME_MUTINY_PANACHE_ENTITY)) continue;
            BuildException be = new BuildException("You provide a MongoDB identifier via @BsonId inside '" + info.name() + "' but one is already provided by ReactivePanacheMongoEntity, your class should extend ReactivePanacheMongoEntityBase instead, or use the id provided by ReactivePanacheMongoEntity", Collections.emptyList());
            return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{be});
        }
        return null;
    }

    @BuildStep
    void handleProjectionFor(CombinedIndexBuildItem index, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        Type targetClass;
        HashMap<DotName, HashMap<String, String>> propertyMapping = new HashMap<DotName, HashMap<String, String>>();
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(DOTNAME_PROJECTION_FOR)) {
            targetClass = annotationInstance.value().asClass();
            ClassInfo target = index.getIndex().getClassByName(targetClass.name());
            HashMap<String, String> classPropertyMapping = new HashMap<String, String>();
            this.extractMappings(classPropertyMapping, target, index);
            propertyMapping.put(targetClass.name(), classPropertyMapping);
        }
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(DOTNAME_PROJECTION_FOR)) {
            targetClass = annotationInstance.value().asClass();
            Map targetPropertyMapping = (Map)propertyMapping.get(targetClass.name());
            if (targetPropertyMapping != null && !targetPropertyMapping.isEmpty()) {
                ClassInfo info = annotationInstance.target().asClass();
                ProjectionForEnhancer fieldEnhancer = new ProjectionForEnhancer(targetPropertyMapping);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(info.name().toString(), (BiFunction)fieldEnhancer));
            }
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(targetClass.name().toString(), annotationInstance.target().asClass().name().toString()));
        }
    }

    private void extractMappings(Map<String, String> classPropertyMapping, ClassInfo target, CombinedIndexBuildItem index) {
        AnnotationInstance bsonProperty;
        for (FieldInfo fieldInfo : target.fields()) {
            if (!fieldInfo.hasAnnotation(DOTNAME_BSON_PROPERTY)) continue;
            bsonProperty = fieldInfo.annotation(DOTNAME_BSON_PROPERTY);
            classPropertyMapping.put(fieldInfo.name(), bsonProperty.value().asString());
        }
        for (MethodInfo methodInfo : target.methods()) {
            if (!methodInfo.hasAnnotation(DOTNAME_BSON_PROPERTY)) continue;
            bsonProperty = methodInfo.annotation(DOTNAME_BSON_PROPERTY);
            classPropertyMapping.put(methodInfo.name(), bsonProperty.value().asString());
        }
        if (!target.superClassType().name().equals((Object)JandexUtil.DOTNAME_OBJECT)) {
            Type superType = target.superClassType();
            ClassInfo superClass = index.getIndex().getClassByName(superType.name());
            this.extractMappings(classPropertyMapping, superClass, index);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildReplacementMap(List<PropertyMappingClassBuildStep> propertyMappingClasses, CombinedIndexBuildItem index, PanacheMongoRecorder recorder) {
        ConcurrentHashMap<String, Map> replacementMap = new ConcurrentHashMap<String, Map>();
        for (PropertyMappingClassBuildStep classToMap : propertyMappingClasses) {
            DotName dotName = DotName.createSimple((String)classToMap.getClassName());
            ClassInfo classInfo = index.getIndex().getClassByName(dotName);
            if (classInfo == null) continue;
            Map classReplacementMap = replacementMap.computeIfAbsent(classToMap.getClassName(), className -> this.computeReplacement(classInfo));
            if (classToMap.getAliasClassName() == null) continue;
            replacementMap.put(classToMap.getAliasClassName(), classReplacementMap);
        }
        recorder.setReplacementCache(replacementMap);
    }

    private Map<String, String> computeReplacement(ClassInfo classInfo) {
        AnnotationInstance bsonProperty;
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        for (FieldInfo field : classInfo.fields()) {
            bsonProperty = field.annotation(DOTNAME_BSON_PROPERTY);
            if (bsonProperty == null) continue;
            replacementMap.put(field.name(), bsonProperty.value().asString());
        }
        for (MethodInfo method : classInfo.methods()) {
            if (!method.name().startsWith("get") || (bsonProperty = method.annotation(DOTNAME_BSON_PROPERTY)) == null) continue;
            String fieldName = JavaBeanUtil.decapitalize((String)method.name().substring(3));
            replacementMap.put(fieldName, bsonProperty.value().asString());
        }
        return replacementMap.isEmpty() ? Collections.emptyMap() : replacementMap;
    }
}

