/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.deployment;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ProjectionForEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private static final String BSONPROPERTY_BINARY_NAME = "org/bson/codecs/pojo/annotations/BsonProperty";
    private static final String BSONPROPERTY_SIGNATURE = "Lorg/bson/codecs/pojo/annotations/BsonProperty;";
    private Map<String, String> propertyMapping;

    public ProjectionForEnhancer(Map<String, String> propertyMapping) {
        this.propertyMapping = propertyMapping;
    }

    @Override
    public ClassVisitor apply(String className, ClassVisitor classVisitor) {
        return new BsonPropertyClassVisitor(classVisitor, this.propertyMapping);
    }

    static class BsonPropertyClassVisitor
    extends ClassVisitor {
        Map<String, String> propertyMapping;

        BsonPropertyClassVisitor(ClassVisitor outputClassVisitor, Map<String, String> propertyMapping) {
            super(524288, outputClassVisitor);
            this.propertyMapping = propertyMapping;
        }

        public FieldVisitor visitField(int access, final String name, String descriptor, String signature, Object value) {
            FieldVisitor superVisitor = super.visitField(access, name, descriptor, signature, value);
            if (this.propertyMapping.containsKey(name)) {
                return new FieldVisitor(524288, superVisitor){
                    private Set<String> descriptors;
                    {
                        super(x0, x1);
                        this.descriptors = new HashSet<String>();
                    }

                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        this.descriptors.add(descriptor);
                        return super.visitAnnotation(descriptor, visible);
                    }

                    public void visitEnd() {
                        if (!this.descriptors.contains(ProjectionForEnhancer.BSONPROPERTY_SIGNATURE)) {
                            AnnotationVisitor visitor = super.visitAnnotation(ProjectionForEnhancer.BSONPROPERTY_SIGNATURE, true);
                            visitor.visit("value", (Object)propertyMapping.get(name));
                            visitor.visitEnd();
                        }
                        super.visitEnd();
                    }
                };
            }
            return superVisitor;
        }

        public MethodVisitor visitMethod(int access, final String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor superVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (this.propertyMapping.containsKey(name)) {
                return new MethodVisitor(524288, superVisitor){
                    private Set<String> descriptors;
                    {
                        super(x0, x1);
                        this.descriptors = new HashSet<String>();
                    }

                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        this.descriptors.add(descriptor);
                        return super.visitAnnotation(descriptor, visible);
                    }

                    public void visitEnd() {
                        if (!this.descriptors.contains(ProjectionForEnhancer.BSONPROPERTY_SIGNATURE)) {
                            AnnotationVisitor visitor = super.visitAnnotation(ProjectionForEnhancer.BSONPROPERTY_SIGNATURE, true);
                            visitor.visit("value", (Object)propertyMapping.get(name));
                            visitor.visitEnd();
                        }
                        super.visitEnd();
                    }
                };
            }
            return superVisitor;
        }
    }
}

