/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.deployment;

import io.quarkus.mongodb.panache.deployment.PanacheMongoResourceProcessor;
import io.quarkus.mongodb.panache.deployment.ReactivePanacheMongoEntityEnhancer;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoRepository;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheMongoRepositoryBase;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ReactivePanacheMongoRepositoryEnhancer
extends PanacheRepositoryEnhancer {
    public static final DotName PANACHE_REPOSITORY_BASE_NAME = DotName.createSimple((String)ReactivePanacheMongoRepositoryBase.class.getName());
    public static final DotName PANACHE_REPOSITORY_NAME = DotName.createSimple((String)ReactivePanacheMongoRepository.class.getName());

    public ReactivePanacheMongoRepositoryEnhancer(IndexView index) {
        super(index, PanacheMongoResourceProcessor.DOTNAME_MUTINY_PANACHE_REPOSITORY_BASE);
    }

    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new PanacheMongoRepositoryClassVisitor(className, outputClassVisitor, this.panacheRepositoryBaseClassInfo, this.indexView);
    }

    static class PanacheMongoRepositoryClassVisitor
    extends PanacheRepositoryEnhancer.PanacheRepositoryClassVisitor {
        public PanacheMongoRepositoryClassVisitor(String className, ClassVisitor outputClassVisitor, ClassInfo panacheRepositoryBaseClassInfo, IndexView indexView) {
            super(className, outputClassVisitor, panacheRepositoryBaseClassInfo, indexView);
        }

        protected DotName getPanacheRepositoryDotName() {
            return PANACHE_REPOSITORY_NAME;
        }

        protected DotName getPanacheRepositoryBaseDotName() {
            return PANACHE_REPOSITORY_BASE_NAME;
        }

        protected String getPanacheOperationsBinaryName() {
            return ReactivePanacheMongoEntityEnhancer.MONGO_OPERATIONS_BINARY_NAME;
        }

        protected void injectModel(MethodVisitor mv) {
            mv.visitLdcInsn((Object)this.entityType);
        }

        protected String getModelDescriptor() {
            return "Ljava/lang/Class;";
        }
    }
}

