/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.mongodb.panache.deployment.BasePanacheMongoResourceProcessor;
import io.quarkus.mongodb.panache.deployment.ByteCodeType;
import io.quarkus.mongodb.panache.deployment.TypeBundle;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.visitors.PanacheRepositoryClassVisitor;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class PanacheMongoRepositoryClassVisitor
extends PanacheRepositoryClassVisitor {
    private static final ByteCodeType CLASS = new ByteCodeType(Class.class);
    private final TypeBundle typeBundle;

    public PanacheMongoRepositoryClassVisitor(String className, ClassVisitor outputClassVisitor, IndexView indexView, TypeBundle typeBundle) {
        super(className, outputClassVisitor, indexView);
        this.typeBundle = typeBundle;
    }

    protected void generateModelBridge(MethodInfo method, AnnotationValue targetReturnTypeErased) {
        int i;
        String descriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> (String)this.typeArguments.get(name));
        String signature = AsmUtil.getSignature((MethodInfo)method, name -> (String)this.typeArguments.get(name));
        List parameters = method.parameters();
        MethodVisitor mv = super.visitMethod(1, method.name(), descriptor, signature, null);
        for (i = 0; i < parameters.size(); ++i) {
            mv.visitParameter(method.parameterName(i), 0);
        }
        mv.visitFieldInsn(178, this.daoBinaryName, "operations", this.typeBundle.operations().descriptor());
        mv.visitCode();
        this.injectModel(mv);
        for (i = 0; i < parameters.size(); ++i) {
            mv.visitIntInsn(25, i + 1);
        }
        this.invokeOperation(mv, method);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void invokeOperation(MethodVisitor mv, MethodInfo method) {
        Function<String, String> argMapper = type -> null;
        AnnotationInstance bridge = method.annotation(PanacheEntityEnhancer.DOTNAME_GENERATE_BRIDGE);
        AnnotationValue targetReturnTypeErased = bridge.value("targetReturnTypeErased");
        boolean erased = targetReturnTypeErased != null && targetReturnTypeErased.asBoolean();
        StringJoiner joiner = new StringJoiner("", "(", ")");
        joiner.add(CLASS.descriptor());
        for (Type parameter : method.parameters()) {
            joiner.add(AsmUtil.getDescriptor((Type)parameter, argMapper));
        }
        List<String> names = Arrays.asList(this.typeBundle.queryType().dotName().toString(), this.typeBundle.updateType().dotName().toString());
        String operationDescriptor = joiner + (erased || names.contains(method.returnType().name().toString()) ? BasePanacheMongoResourceProcessor.OBJECT_SIGNATURE : AsmUtil.getDescriptor((Type)method.returnType(), argMapper));
        mv.visitMethodInsn(182, this.typeBundle.operations().internalName(), method.name(), operationDescriptor, false);
        if (method.returnType().kind() != Type.Kind.PRIMITIVE) {
            Type type2 = method.returnType();
            String cast = erased ? this.entityBinaryType : type2.name().toString().replace('.', '/');
            mv.visitTypeInsn(192, cast);
        }
        mv.visitInsn(AsmUtil.getReturnInstruction((Type)method.returnType()));
    }

    protected DotName getPanacheRepositoryDotName() {
        return this.typeBundle.repository().dotName();
    }

    protected DotName getPanacheRepositoryBaseDotName() {
        return this.typeBundle.repositoryBase().dotName();
    }

    protected String getPanacheOperationsInternalName() {
        return this.typeBundle.operations().internalName();
    }
}

