/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.kotlin.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.mongodb.panache.deployment.BasePanacheMongoResourceProcessor;
import io.quarkus.mongodb.panache.deployment.PropertyMappingClassBuildStep;
import io.quarkus.mongodb.panache.kotlin.deployment.KotlinImperativeTypeBundle;
import io.quarkus.mongodb.panache.kotlin.deployment.KotlinPanacheMongoEntityEnhancer;
import io.quarkus.mongodb.panache.kotlin.deployment.KotlinPanacheMongoRepositoryEnhancer;
import io.quarkus.mongodb.panache.kotlin.deployment.KotlinReactiveTypeBundle;
import io.quarkus.mongodb.panache.kotlin.deployment.PanacheMongoCompanionEnhancer;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheCompanionEnhancer;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import io.quarkus.panache.common.deployment.TypeBundle;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;

public class KotlinPanacheMongoResourceProcessor
extends BasePanacheMongoResourceProcessor {
    public static final KotlinImperativeTypeBundle IMPERATIVE_TYPE_BUNDLE = new KotlinImperativeTypeBundle();
    public static final KotlinReactiveTypeBundle REACTIVE_TYPE_BUNDLE = new KotlinReactiveTypeBundle();

    @BuildStep
    public void buildImperativeCompanions(CombinedIndexBuildItem index, ApplicationIndexBuildItem applicationIndex, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) {
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(bi -> bi.getMethodCustomizer()).collect(Collectors.toList());
        this.processCompanions(index, transformers, reflectiveClass, propertyMappingClass, this.createCompanionEnhancer(index, methodCustomizers), this.getImperativeTypeBundle());
    }

    @BuildStep
    public void buildReactiveCompanions(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, BuildProducer<BytecodeTransformerBuildItem> transformers, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) {
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(bi -> bi.getMethodCustomizer()).collect(Collectors.toList());
        this.processCompanions(index, transformers, reflectiveClass, propertyMappingClass, this.createReactiveCompanionEnhancer(index, methodCustomizers), this.getReactiveTypeBundle());
    }

    protected KotlinImperativeTypeBundle getImperativeTypeBundle() {
        return IMPERATIVE_TYPE_BUNDLE;
    }

    protected KotlinReactiveTypeBundle getReactiveTypeBundle() {
        return REACTIVE_TYPE_BUNDLE;
    }

    @BuildStep
    protected CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.MONGODB_PANACHE_KOTLIN);
    }

    @BuildStep
    protected FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.MONGODB_PANACHE_KOTLIN);
    }

    public PanacheEntityEnhancer createEntityEnhancer(CombinedIndexBuildItem index, List<PanacheMethodCustomizer> methodCustomizers, MetamodelInfo modelInfo) {
        return new KotlinPanacheMongoEntityEnhancer(index.getIndex(), methodCustomizers, this.getImperativeTypeBundle());
    }

    private PanacheMongoCompanionEnhancer createCompanionEnhancer(CombinedIndexBuildItem index, List<PanacheMethodCustomizer> methodCustomizers) {
        return new PanacheMongoCompanionEnhancer(index.getIndex(), methodCustomizers, this.getImperativeTypeBundle());
    }

    private PanacheMongoCompanionEnhancer createReactiveCompanionEnhancer(CombinedIndexBuildItem index, List<PanacheMethodCustomizer> methodCustomizers) {
        return new PanacheMongoCompanionEnhancer(index.getIndex(), methodCustomizers, this.getReactiveTypeBundle());
    }

    public PanacheEntityEnhancer createReactiveEntityEnhancer(CombinedIndexBuildItem index, List<PanacheMethodCustomizer> methodCustomizers, MetamodelInfo modelInfo) {
        return new KotlinPanacheMongoEntityEnhancer(index.getIndex(), methodCustomizers, this.getImperativeTypeBundle());
    }

    public PanacheRepositoryEnhancer createRepositoryEnhancer(CombinedIndexBuildItem index, List<PanacheMethodCustomizer> methodCustomizers) {
        return new KotlinPanacheMongoRepositoryEnhancer(index.getIndex(), this.getImperativeTypeBundle());
    }

    public PanacheRepositoryEnhancer createReactiveRepositoryEnhancer(CombinedIndexBuildItem index, List<PanacheMethodCustomizer> methodCustomizers) {
        return new KotlinPanacheMongoRepositoryEnhancer(index.getIndex(), this.getReactiveTypeBundle());
    }

    private void processCompanions(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, PanacheCompanionEnhancer companionEnhancer, TypeBundle typeBundle) {
        HashSet<String> modelClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(typeBundle.entityCompanionBase().dotName())) {
            if (classInfo.name().equals((Object)typeBundle.entityCompanion().dotName())) continue;
            modelClasses.add(classInfo.name().toString());
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(typeBundle.entityCompanion().dotName())) {
            modelClasses.add(classInfo.name().toString());
        }
        for (String modelClass : modelClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(modelClass, (BiFunction)companionEnhancer));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{modelClass}));
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(modelClass));
        }
    }
}

