/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.binder;

import io.quarkus.mongodb.panache.binder.CommonQueryBinder;
import io.quarkus.panacheql.internal.HqlParser;
import io.quarkus.panacheql.internal.HqlParserBaseVisitor;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

class MongoParserVisitor
extends HqlParserBaseVisitor<String> {
    private Map<String, String> replacementMap;
    private Map<String, Object> parameterMaps;

    public MongoParserVisitor(Map<String, String> replacementMap, Map<String, Object> parameterMaps) {
        this.replacementMap = replacementMap;
        this.parameterMaps = parameterMaps;
    }

    public String visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (HqlParser.PredicateContext predicate : ctx.predicate()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)predicate.accept((ParseTreeVisitor)this));
        }
        return sb.toString();
    }

    public String visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        StringBuilder sb = new StringBuilder("'$or':[");
        for (HqlParser.PredicateContext predicate : ctx.predicate()) {
            if (sb.length() > 7) {
                sb.append(",");
            }
            sb.append('{').append((String)predicate.accept((ParseTreeVisitor)this)).append('}');
        }
        sb.append("]");
        return sb.toString();
    }

    public String visitEqualityPredicate(HqlParser.EqualityPredicateContext ctx) {
        return (String)ctx.expression(0).accept((ParseTreeVisitor)this) + ":" + (String)ctx.expression(1).accept((ParseTreeVisitor)this);
    }

    public String visitInequalityPredicate(HqlParser.InequalityPredicateContext ctx) {
        return (String)ctx.expression(0).accept((ParseTreeVisitor)this) + ":{'$ne':" + (String)ctx.expression(1).accept((ParseTreeVisitor)this) + "}";
    }

    public String visitLessThanOrEqualPredicate(HqlParser.LessThanOrEqualPredicateContext ctx) {
        return (String)ctx.expression(0).accept((ParseTreeVisitor)this) + ":{'$lte':" + (String)ctx.expression(1).accept((ParseTreeVisitor)this) + "}";
    }

    public String visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        return (String)ctx.expression(0).accept((ParseTreeVisitor)this) + ":{'$regex':" + (String)ctx.expression(1).accept((ParseTreeVisitor)this) + "}";
    }

    public String visitGreaterThanPredicate(HqlParser.GreaterThanPredicateContext ctx) {
        return (String)ctx.expression(0).accept((ParseTreeVisitor)this) + ":{'$gt':" + (String)ctx.expression(1).accept((ParseTreeVisitor)this) + "}";
    }

    public String visitLessThanPredicate(HqlParser.LessThanPredicateContext ctx) {
        return (String)ctx.expression(0).accept((ParseTreeVisitor)this) + ":{'$lt':" + (String)ctx.expression(1).accept((ParseTreeVisitor)this) + "}";
    }

    public String visitGreaterThanOrEqualPredicate(HqlParser.GreaterThanOrEqualPredicateContext ctx) {
        return (String)ctx.expression(0).accept((ParseTreeVisitor)this) + ":{'$gte':" + (String)ctx.expression(1).accept((ParseTreeVisitor)this) + "}";
    }

    public String visitIsNullPredicate(HqlParser.IsNullPredicateContext ctx) {
        boolean exists = ctx.NOT() != null;
        return (String)ctx.expression().accept((ParseTreeVisitor)this) + ":{'$exists':" + exists + "}";
    }

    public String visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        return CommonQueryBinder.escape(ctx.getText());
    }

    public String visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        if (this.parameterMaps.containsKey(ctx.getText())) {
            Object value = this.parameterMaps.get(ctx.getText());
            return CommonQueryBinder.escape(value);
        }
        return ctx.getText();
    }

    public String visitPathExpression(HqlParser.PathExpressionContext ctx) {
        return "'" + this.replacementMap.getOrDefault(ctx.getText(), ctx.getText()) + "'";
    }
}

