/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.reactive.runtime;

import io.quarkus.mongodb.FindOptions;
import io.quarkus.mongodb.panache.reactive.ReactivePanacheQuery;
import io.quarkus.mongodb.reactive.ReactiveMongoCollection;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.exception.PanacheQueryException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ReactivePanacheQueryImpl<Entity>
implements ReactivePanacheQuery<Entity> {
    private ReactiveMongoCollection collection;
    private Document mongoQuery;
    private Document sort;
    private Page page;
    private Uni<Long> count;

    ReactivePanacheQueryImpl(ReactiveMongoCollection<? extends Entity> collection, Class<? extends Entity> entityClass, Document mongoQuery, Document sort) {
        this.collection = collection;
        this.mongoQuery = mongoQuery;
        this.sort = sort;
        this.page = new Page(0, Integer.MAX_VALUE);
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> page(Page page) {
        this.page = page;
        return this;
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> page(int pageIndex, int pageSize) {
        return this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> nextPage() {
        return this.page(this.page.next());
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> previousPage() {
        return this.page(this.page.previous());
    }

    @Override
    public <T extends Entity> ReactivePanacheQuery<T> firstPage() {
        return this.page(this.page.first());
    }

    @Override
    public <T extends Entity> Uni<ReactivePanacheQuery<T>> lastPage() {
        return this.pageCount().map(pageCount -> this.page(this.page.index(pageCount - 1)));
    }

    @Override
    public Uni<Boolean> hasNextPage() {
        return this.pageCount().map(pageCount -> this.page.index < pageCount - 1);
    }

    @Override
    public boolean hasPreviousPage() {
        return this.page.index > 0;
    }

    @Override
    public Uni<Integer> pageCount() {
        return this.count().map(count -> {
            if (count == 0L) {
                return 1;
            }
            return (int)Math.ceil((double)count.longValue() / (double)this.page.size);
        });
    }

    @Override
    public Page page() {
        return this.page;
    }

    @Override
    public Uni<Long> count() {
        if (this.count == null) {
            this.count = this.collection.countDocuments((Bson)this.mongoQuery);
        }
        return this.count;
    }

    @Override
    public <T extends Entity> Uni<List<T>> list() {
        FindOptions options = new FindOptions();
        options.sort((Bson)this.sort).skip(this.page.index).limit(this.page.size);
        Multi results = this.mongoQuery == null ? this.collection.find(options) : this.collection.find((Bson)this.mongoQuery, options);
        return results.collectItems().asList();
    }

    @Override
    public <T extends Entity> Multi<T> stream() {
        FindOptions options = new FindOptions();
        options.sort((Bson)this.sort).skip(this.page.index).limit(this.page.size);
        return this.mongoQuery == null ? this.collection.find(options) : this.collection.find((Bson)this.mongoQuery, options);
    }

    @Override
    public <T extends Entity> Uni<T> firstResult() {
        Uni<Optional<T>> optionalEntity = this.firstResultOptional();
        return optionalEntity.map(optional -> optional.orElse(null));
    }

    @Override
    public <T extends Entity> Uni<Optional<T>> firstResultOptional() {
        FindOptions options = new FindOptions();
        options.sort((Bson)this.sort).skip(this.page.index).limit(1);
        Multi results = this.mongoQuery == null ? this.collection.find(options) : this.collection.find((Bson)this.mongoQuery, options);
        return results.collectItems().first().map(o -> Optional.ofNullable(o));
    }

    @Override
    public <T extends Entity> Uni<T> singleResult() {
        FindOptions options = new FindOptions();
        options.sort((Bson)this.sort).skip(this.page.index).limit(2);
        Multi results = this.mongoQuery == null ? this.collection.find(options) : this.collection.find((Bson)this.mongoQuery, options);
        return results.collectItems().asList().map(list -> {
            if (list.size() == 0 || list.size() > 1) {
                throw new PanacheQueryException("There should be only one result");
            }
            return list.get(0);
        });
    }

    @Override
    public <T extends Entity> Uni<Optional<T>> singleResultOptional() {
        FindOptions options = new FindOptions();
        options.sort((Bson)this.sort).skip(this.page.index).limit(2);
        Multi results = this.mongoQuery == null ? this.collection.find(options) : this.collection.find((Bson)this.mongoQuery, options);
        return results.collectItems().asList().map(list -> {
            if (list.size() == 2) {
                throw new PanacheQueryException("There should be no more than one result");
            }
            return list.isEmpty() ? Optional.empty() : Optional.of(list.get(0));
        });
    }
}

