/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.runtime;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import io.quarkus.mongodb.panache.PanacheQuery;
import io.quarkus.mongodb.panache.runtime.MongoPropertyUtil;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.exception.PanacheQueryException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PanacheQueryImpl<Entity>
implements PanacheQuery<Entity> {
    private MongoCollection collection;
    private Class<? extends Entity> entityClass;
    private Document mongoQuery;
    private Document sort;
    private Document projections;
    private Page page;
    private Long count;

    PanacheQueryImpl(MongoCollection<? extends Entity> collection, Class<? extends Entity> entityClass, Document mongoQuery, Document sort) {
        this.collection = collection;
        this.entityClass = entityClass;
        this.mongoQuery = mongoQuery;
        this.sort = sort;
        this.page = new Page(0, Integer.MAX_VALUE);
    }

    @Override
    public <T> PanacheQuery<T> project(Class<T> type) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (Method method : type.getMethods()) {
            if (!method.getName().startsWith("get") || method.getName().equals("getClass")) continue;
            String fieldName = MongoPropertyUtil.decapitalize(method.getName().substring(3));
            fieldNames.add(fieldName);
        }
        for (AccessibleObject accessibleObject : type.getFields()) {
            fieldNames.add(((Field)accessibleObject).getName());
        }
        Map<String, String> replacementMap = MongoPropertyUtil.getReplacementMap(type);
        for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
            if (!fieldNames.contains(entry.getKey())) continue;
            fieldNames.remove(entry.getKey());
            fieldNames.add(entry.getValue());
        }
        this.projections = new Document();
        for (String fieldName : fieldNames) {
            this.projections.append(fieldName, (Object)1);
        }
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> page(Page page) {
        this.page = page;
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> page(int pageIndex, int pageSize) {
        return this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    @Override
    public <T extends Entity> PanacheQuery<T> nextPage() {
        return this.page(this.page.next());
    }

    @Override
    public <T extends Entity> PanacheQuery<T> previousPage() {
        return this.page(this.page.previous());
    }

    @Override
    public <T extends Entity> PanacheQuery<T> firstPage() {
        return this.page(this.page.first());
    }

    @Override
    public <T extends Entity> PanacheQuery<T> lastPage() {
        return this.page(this.page.index(this.pageCount() - 1));
    }

    @Override
    public boolean hasNextPage() {
        return this.page.index < this.pageCount() - 1;
    }

    @Override
    public boolean hasPreviousPage() {
        return this.page.index > 0;
    }

    @Override
    public int pageCount() {
        long count = this.count();
        if (count == 0L) {
            return 1;
        }
        return (int)Math.ceil((double)count / (double)this.page.size);
    }

    @Override
    public Page page() {
        return this.page;
    }

    @Override
    public long count() {
        if (this.count == null) {
            this.count = this.collection.countDocuments((Bson)this.mongoQuery);
        }
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Entity> List<T> list() {
        FindIterable find;
        ArrayList<Object> list = new ArrayList<Object>();
        FindIterable findIterable = find = this.mongoQuery == null ? this.collection.find() : this.collection.find((Bson)this.mongoQuery);
        if (this.projections != null) {
            find.projection((Bson)this.projections);
        }
        try (MongoCursor cursor = find.sort((Bson)this.sort).skip(this.page.index).limit(this.page.size).iterator();){
            while (cursor.hasNext()) {
                Object entity = cursor.next();
                list.add(entity);
            }
        }
        return list;
    }

    @Override
    public <T extends Entity> Stream<T> stream() {
        return this.list().stream();
    }

    @Override
    public <T extends Entity> T firstResult() {
        List<T> list = this.list();
        return list.isEmpty() ? null : (T)list.get(0);
    }

    @Override
    public <T extends Entity> Optional<T> firstResultOptional() {
        return Optional.ofNullable(this.firstResult());
    }

    @Override
    public <T extends Entity> T singleResult() {
        List<T> list = this.list();
        if (list.isEmpty() || list.size() > 1) {
            throw new PanacheQueryException("There should be only one result");
        }
        return list.get(0);
    }

    @Override
    public <T extends Entity> Optional<T> singleResultOptional() {
        List<T> list = this.list();
        if (list.size() > 1) {
            throw new PanacheQueryException("There should be no more than one result");
        }
        return list.isEmpty() ? Optional.empty() : Optional.of(list.get(0));
    }
}

